<?php
include( "assets/inc/template.php" );

function main() {
	global $conn;
	?>

    <main>

        <!-- breadcrumb area start -->
        <section class="rs-breadcrumb-area rs-breadcrumb-one p-relative">
            <div class="rs-breadcrumb-bg" data-background="assets/images/bg/breadcrumb-bg-01.png"></div>
            <div class="container">
                <div class="row">
                    <div class="col-xxl-6 col-xl-8 col-lg-8">
                        <div class="rs-breadcrumb-content-wrapper">
                            <div class="rs-breadcrumb-title-wrapper">
                                <h1 class="rs-breadcrumb-title">Inquiry Us</h1>
                            </div>
                            <div class="rs-breadcrumb-menu">
                                <nav>
                                    <ul>
                                        <li><span><a href="index.php">Home</a></span></li>
                                        <li><span>Inquiry Us</span></li>
                                    </ul>
                                </nav>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- breadcrumb area end -->

       
			<section class="rs-contact-form-area rs-contact-ten section-space">
            <div class="container">
                
                <div class="row justify-content-center">
                    <div class="col-xl-12">
						
                        <div class="rs-contact-form">
                            <h3 class="rs-contact-form-title">Product Inquiry Form</h3>
                            
                            <form id="contact-form" action="assets/mailer.php" method="POST">
  <div class="row g-5">
    <div class="col-md-6">
      <div class="rs-contact-input">
        <label for="name">Full Name <span>*</span></label>
        <input type="text" id="name" name="name" placeholder="Your Name" required>
      </div>
    </div>

    <div class="col-md-6">
      <div class="rs-contact-input">
        <label for="company">Company Name </label>
        <input type="text" id="company" name="company" placeholder="Your Company">
      </div>
    </div>

    <div class="col-md-6">
      <div class="rs-contact-input">
        <label for="email">Email Address <span>*</span></label>
        <input type="email" id="email" name="email" placeholder="Email Address" required>
      </div>
    </div>

    <div class="col-md-6">
      <div class="rs-contact-input">
        <label for="phone">Phone Number <span>*</span></label>
        <input type="tel" id="phone" name="phone" placeholder="Phone Number" required>
      </div>
    </div>
    <div class="col-md-6">
      <div class="rs-contact-input">
        <label for="city">City / State <span>*</span></label>
        <input type="text" id="city" name="city" placeholder="e.g., Ahmedabad, Gujarat" required>
      </div>
    </div>
    <div class="col-md-6">
      <div class="rs-contact-input">
        <label for="country">Country / Region <span>*</span></label>
        <input type="text" id="country" name="country" placeholder="Country Name" required>
      </div>
    </div>

    <?php

require_once 'models/ProductCategoryModel.php'; // Model file

$productCategoryModel = new ProductCategoryModel($conn);
$productcat = $productCategoryModel->getAllProducts(); // Fetch categories
?>

<div class="col-md-6">
  <div class="rs-contact-input">
    <label for="product">Product Interested In <span>*</span></label>
    <select name="product" id="product"  required>
      <option value="">Select Product</option>
      <?php foreach ($productcat as $cat): ?>
        <option value="<?= htmlspecialchars($cat['id']) ?>">
          <?= htmlspecialchars($cat['catname']) ?>
        </option>
      <?php endforeach; ?>
    </select>
  </div>
</div>


    <div class="col-md-6">
      <div class="rs-contact-input">
        <label for="quantity">Required Quantity </label>
        <input type="number" id="quantity" name="quantity" placeholder="e.g., 500 Units" required>
      </div>
    </div>

    <div class="col-md-12">
      <div class="rs-contact-input">
        <label for="message">Additional Message</label>
        <textarea id="message" name="message" placeholder="Write Your Message or Requirement Here"></textarea>
      </div>
    </div>

    <div class="col-md-12">
      <div class="rs-contact-btn">
        <button type="submit" class="rs-btn has-theme-orange">Send Inquiry</button>
      </div>
    </div>
  </div>
</form>

                            <div id="form-messages"></div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- checkout area start -->
        

        

    </main>
   <?php } ?>