<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
require_once 'inc/config.php';

$response = [];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $action = $_POST['action'] ?? '';

    // Generate slug function
    // function generateSlug($string) {
    //     $slug = strtolower(trim(preg_replace('/[^A-Za-z0-9-]+/', '-', $string), '-'));
    //     return $slug;
    // }

    // === CREATE SERVICE ===
    if ($action === 'Create') {
       // $title = mysqli_real_escape_string($conn, $_POST['title'] ?? '');
        $category_id = intval($_POST['category_id'] ?? 0);
        $description = mysqli_real_escape_string($conn, $_POST['description'] ?? '');
        $price = floatval($_POST['price'] ?? 0);
        $duration = mysqli_real_escape_string($conn, $_POST['duration'] ?? '');
        //$slug = generateSlug($title);

        // Handle image upload
        $imagePath = null;
        if (isset($_FILES['image']) && $_FILES['image']['error'] === 0) {
            $ext = pathinfo($_FILES['image']['name'], PATHINFO_EXTENSION);
            $uniqueName = uniqid('service_', true) . '.' . $ext;
            $imagePath = 'uploads/' . $uniqueName;
            move_uploaded_file($_FILES['image']['tmp_name'], $imagePath);
        }

        // Insert query
        $sql = "INSERT INTO service_details (category_id, description, image, price, duration)
                VALUES ('$category_id', '$description', " . ($imagePath ? "'$imagePath'" : "NULL") . ", '$price', '$duration')";

        if (mysqli_query($conn, $sql)) {
            $response = ['status' => 'success', 'message' => 'Service created successfully'];
        } else {
            $response = ['status' => 'error', 'message' => 'Database insert error: ' . mysqli_error($conn)];
        }
    }

    // === UPDATE SERVICE ===
    elseif ($action === 'Update') {
        $id = intval($_POST['id']);
       // $title = mysqli_real_escape_string($conn, $_POST['title'] ?? '');
        $category_id = intval($_POST['category_id'] ?? 0);
        $description = mysqli_real_escape_string($conn, $_POST['description'] ?? '');
        $price = floatval($_POST['price'] ?? 0);
        $duration = mysqli_real_escape_string($conn, $_POST['duration'] ?? '');
        //$slug = generateSlug($title);

        $imagePath = null;
        if (isset($_FILES['image']) && $_FILES['image']['error'] === 0) {
            $ext = pathinfo($_FILES['image']['name'], PATHINFO_EXTENSION);
            $uniqueName = uniqid('service_', true) . '.' . $ext;
            $imagePath = 'uploads/' . $uniqueName;
            move_uploaded_file($_FILES['image']['tmp_name'], $imagePath);

            // Delete old image
            $result = mysqli_query($conn, "SELECT image FROM service_details WHERE id = '$id'");
            if ($result && mysqli_num_rows($result) > 0) {
                $old = mysqli_fetch_assoc($result);
                if ($old['image'] && file_exists($old['image'])) {
                    unlink($old['image']);
                }
            }

            $sql = "UPDATE service_details SET category_id='$category_id',  description='$description',
                    image='$imagePath', price='$price', duration='$duration WHERE id='$id'";
        } else {
            $sql = "UPDATE service_details SET category_id='$category_id', description='$description',
                    price='$price', duration='$duration' WHERE id='$id'";
        }

        if (mysqli_query($conn, $sql)) {
            $response = ['status' => 'success', 'message' => 'Service updated successfully'];
        } else {
            $response = ['status' => 'error', 'message' => 'Update failed: ' . mysqli_error($conn)];
        }
    }

    // === SELECT SERVICE ===
    elseif ($action === 'Select') {
        $id = intval($_POST['id']);
        $result = mysqli_query($conn, "SELECT * FROM service_details WHERE id = '$id'");

        if ($result && mysqli_num_rows($result) > 0) {
            $data = mysqli_fetch_assoc($result);
            $response = ['status' => 'Select', 'data' => $data];
        } else {
            $response = ['status' => 'error', 'message' => 'Service not found'];
        }
    }

    // === DELETE SERVICE ===
    elseif ($action === 'Delete') {
        $id = intval($_POST['id']);

        $result = mysqli_query($conn, "SELECT image FROM service_details WHERE id = '$id'");
        if ($result && mysqli_num_rows($result) > 0) {
            $data = mysqli_fetch_assoc($result);
            if (!empty($data['image']) && file_exists($data['image'])) {
                unlink($data['image']);
            }
        }

        $del = mysqli_query($conn, "DELETE FROM service_details WHERE id = '$id'");
        if ($del) {
            $response = ['status' => 'Success', 'message' => 'Service deleted successfully'];
        } else {
            $response = ['status' => 'Error', 'message' => 'Delete failed: ' . mysqli_error($conn)];
        }
    }

    // === STATUS CHANGE ===
    elseif ($action === 'StatusChange') {
        $id = intval($_POST['id']);
        $query = mysqli_query($conn, "SELECT status FROM service_details WHERE id = '$id'");
        if ($query && mysqli_num_rows($query) > 0) {
            $row = mysqli_fetch_assoc($query);
            $newStatus = $row['status'] == 1 ? 0 : 1;
            $update = mysqli_query($conn, "UPDATE service_details SET status = '$newStatus' WHERE id = '$id'");
            if ($update) {
                $response = ['status' => 'Success', 'message' => 'Status changed to ' . ($newStatus == 1 ? 'Active' : 'Inactive')];
            } else {
                $response = ['status' => 'Error', 'message' => 'Failed to update status'];
            }
        } else {
            $response = ['status' => 'Error', 'message' => 'Service not found'];
        }
    }

    // === INVALID ACTION ===
    else {
        $response = ['status' => 'error', 'message' => 'Invalid action'];
    }

    header('Content-Type: application/json');
    echo json_encode($response);
    exit;
}
