<?php
require_once __DIR__ . '/../inc/db.php';

class ProductDetailsModel {
    private $conn;
    private $uploadDir;

    public function __construct($db_conn) {
        $this->conn = $db_conn;
        $this->uploadDir = __DIR__ . '/../../uploads/';
    }

    public function create($data) {
    // ✅ Make sure 'product_name' is passed in $data
   // $slug = $this->generateSlug($data['product_name']); 

    $stmt = $this->conn->prepare("INSERT INTO product_details (cat_id, subcat_id, short_description, full_description, product_description, product_image) VALUES (?, ?, ?, ?, ?, ?)");

    $stmt->bind_param(
        "iissss",
        $data['cat_id'],
        $data['subcat_id'],
        $data['short_description'],
        $data['full_description'],
        $data['product_description'],
        $data['product_image']
        
    );

    if (!$stmt->execute()) {
        // ✅ Add this for debugging
        return [
            'status' => 'error',
            'message' => 'DB Error: ' . $stmt->error
        ];
    }

    return ['status' => 'success', 'message' => 'Product created successfully'];
}

    public function update($id, $data) {
    $existing = $this->getById($id);
    if (!$existing) return false;

    if (!empty($data['product_image'])) {
        $this->unlinkOldImage($id);
        $image = $data['product_image'];
    } else {
        $image = $existing['product_image'];
    }

   // $slug = $data['product_slug']; // or generateSlug() if needed

    $stmt = $this->conn->prepare("UPDATE product_details SET 
        cat_id = ?, 
        subcat_id = ?, 
        product_name = ?, 
        short_description = ?, 
        full_description = ?, 
        product_description = ?, 
        product_image = ? 
        WHERE id = ?
    ");

    if (!$stmt) {
        die("Prepare failed: " . $this->conn->error);
    }

    $stmt->bind_param(
        "iisssssi",
        $data['cat_id'],
        $data['subcat_id'],
        $data['product_name'],
        $data['short_description'],
        $data['full_description'],
        $data['product_description'],
        $image,
        $id
    );

    return $stmt->execute();
}


    public function getById($id) {
        $stmt = $this->conn->prepare("SELECT * FROM product_details WHERE id=?");
        $stmt->bind_param("i", $id);
        $stmt->execute();
        return $stmt->get_result()->fetch_assoc();
    }
	
	public function delete($id) {
        $this->unlinkOldImage($id);
        $stmt = $this->conn->prepare("DELETE FROM product_details WHERE id=?");
        $stmt->bind_param("i", $id);
        return $stmt->execute();
    }

    public function toggleStatus($id) {
    $stmt = $this->conn->prepare("
        UPDATE product_details 
        SET status = CASE 
            WHEN status = 'active' THEN 'inactive' 
            ELSE 'active' 
        END 
        WHERE id = ?
    ");
    $stmt->bind_param("i", $id);
    return $stmt->execute();
}


    // DELETE OLD IMAGE FILE
    private function unlinkOldImage($id) {
        $category = $this->getById($id);
        if ($category && !empty($category['image'])) {
            $oldImagePath = $this->uploadDir . $category['image'];
            if (file_exists($oldImagePath)) {
                unlink($oldImagePath);
            }
        }
    }

    // Generate slug
    private function generateSlug($product_name) {
        return strtolower(preg_replace('/[^A-Za-z0-9-]+/', '-', trim($product_name)));
    }
}
