<?php
session_start();
require_once 'inc/db.php';  // your DB connection file

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $email = trim($_POST['email-username']);
    $password = trim($_POST['password']);

    if (empty($email) || empty($password)) {
        echo json_encode(['status' => 'error', 'message' => 'Please fill in all fields.']);
        exit;
    }

    $stmt = $conn->prepare("SELECT * FROM users WHERE email = ? AND status = '1' LIMIT 1");
    $stmt->bind_param("s", $email);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows === 1) {
        $user = $result->fetch_assoc();

        if (password_verify($password, $user['password'])) {
            $_SESSION['user_id'] = $user['id'];
            $_SESSION['user_name'] = $user['name'];
            $_SESSION['user_role'] = $user['role'];

            // Handle Remember Me
            if (isset($_POST['rememberMe']) && $_POST['rememberMe'] === 'on') {
                setcookie("remember_email", $email, time() + (86400 * 30), "/");
                setcookie("remember_pass", $password, time() + (86400 * 30), "/"); // You can hash this too
            } else {
                setcookie("remember_email", "", time() - 3600, "/");
                setcookie("remember_pass", "", time() - 3600, "/");
            }

            echo json_encode(['status' => 'success', 'message' => 'Login successful! Redirecting...']);
        } else {
            echo json_encode(['status' => 'error', 'message' => 'Invalid password.']);
        }
    } else {
        echo json_encode(['status' => 'error', 'message' => 'User not found or inactive.']);
    }

    $stmt->close();
    $conn->close();
}
?>
