<?php
require_once '../inc/db.php';
require_once '../models/ProductSubcategoryModel.php';


$productSubcategory = new ProductSubcategoryModel($conn); // Corrected variable name

if ($_SERVER['REQUEST_METHOD'] === 'GET' && ($_GET['action'] ?? '') === 'productsubcatlist') {
    $result = $conn->query("SELECT psc.*, pc.catname AS category_name FROM product_subcategories psc JOIN product_categories pc ON pc.id = psc.cat_id ORDER BY psc.id ASC");
    $html = '';

    while ($row = $result->fetch_assoc()) {
        $img = $row['image'] ? "<img src='../uploads/subproducts/{$row['image']}' width='60'>" : 'No image';
		$statusText = $row['status'] ? '1' : '0';
        //$imageTag = $user['profile_photo'] ? "<img src='uploads/{$user['profile_photo']}' style='max-width:50px;'>" : '';
        $checked = $row['status'] ? 'checked' : '';
        $statusSwitch = "<label class='switch switch-success'>
            <input type='checkbox' class='switch-input toggleStatus' data-id='{$row['id']}' $checked />
            <span class='switch-toggle-slider'>
              <span class='switch-on'><i class='icon-base ti tabler-check'></i></span>
              <span class='switch-off'><i class='icon-base ti tabler-x'></i></span>
            </span>
          </label>";
        
        $html .= "<tr>
            <td>" . ucwords($row['category_name']) . "</td>
            <td>" . ucwords($row['subcat_name']) . "</td>
            <td>$img</td>
            <td>
              <input type='number' class='form-control form-control-sm sort-order-input' 
              data-id='{$row['id']}' value='{$row['sort_order']}' style='width: 60px;'>
            </td>
            <td>{$statusSwitch}</td>
			<td>
                    <button class='btn btn-xs btn-info rounded-pill editBtn' data-id='{$row['id']}' data-bs-toggle='tooltip'
                            data-bs-placement='top'
                            title='edit'><i class='far fa-edit'></i></button>
                    <button class='btn btn-xs btn-danger rounded-pill deleteBtn' data-id='{$row['id']}' data-bs-toggle='tooltip'
                            data-bs-placement='top'
                            title='delete'><i class='far fa-trash-alt'></i></button>
                </td>
            
        </tr>";
    }

    echo $html;
    exit;
}

// 2. Update Sort Order
//
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action']) && $_POST['action'] === 'updateSortOrder') {
    $id = (int)$_POST['id'];
    $sort_order = (int)$_POST['sort_order'];

    $success = $productSubcategory->updateSortOrder($id, $sort_order);

    echo json_encode([
        'status' => $success ? 'success' : 'error',
        'message' => $success ? 'Sort order updated.' : 'Failed to update sort order.'
    ]);
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $action = $_POST['action'] ?? 'Create';

    // 🔹 Handle getCategory request
    if ($action === 'getSubcategory') {
        $id = $_POST['id'] ?? 0;
        $subcategory = $productSubcategory->getById($id);
        echo json_encode($subcategory);
        exit;
    }

    // 🔹 Handle Create/Update
    $cat_id = $_POST['cat_id'] ?? '';
	$subcat_name = $_POST['subcat_name'] ?? '';
    $description = $_POST['description'] ?? '';
    $id = $_POST['id'] ?? null;

    // File upload
   $imageName = '';

if (isset($_FILES['photo']) && $_FILES['photo']['error'] === 0) {
    $uploadDir = '../../uploads/subproducts/';
    if (!file_exists($uploadDir)) mkdir($uploadDir, 0777, true);

    // 🔹 Sanitize the original filename (remove spaces, special characters)
    $originalName = pathinfo($_FILES['photo']['name'], PATHINFO_FILENAME); // without extension
    $extension = pathinfo($_FILES['photo']['name'], PATHINFO_EXTENSION);

    // 🔹 Clean filename: lowercase, dashes, no spaces or parentheses
    $safeName = preg_replace('/[^a-zA-Z0-9-_]/', '', str_replace(' ', '-', strtolower($originalName)));

    // 🔹 Final image name: timestamp_safe-name.ext
    $imageName = time() . '_' . $safeName . '.' . $extension;

    move_uploaded_file($_FILES['photo']['tmp_name'], $uploadDir . $imageName);
}


    // Prepare data
    $data = [
        'cat_id' => $cat_id,
		'subcat_name' => $subcat_name,
        'description' => $description,
        'image' => $imageName
    ];

    $response = ['status' => 'error', 'message' => 'Something went wrong'];

    if ($action === 'Create') {
        if ($productSubcategory->create($data)) {
            $response = ['status' => 'success', 'message' => 'Product subcategory added'];
        }
    } elseif ($action === 'Update' && $id) {
        if ($productSubcategory->update($id, $data)) {
            $response = ['status' => 'success', 'message' => 'Product subcategory updated'];
        }
    } elseif ($action === 'delete') {
        $id = $_POST['id'] ?? 0;
        $result = $productSubcategory->delete($id);
        echo json_encode(['status' => $result ? 'success' : 'error', 'message' => $result ? 'Deleted successfully' : 'Failed to delete']);
        exit;
    } elseif ($action === 'toggleStatus') {
        $id = $_POST['id'] ?? 0;
        $result = $productSubcategory->toggleStatus($id);
        echo json_encode(['status' => $result ? 'success' : 'error', 'message' => $result ? 'Status updated' : 'Status update failed']);
        exit;
    }

	
	

    echo json_encode($response);
    exit;
}
