<?php
error_reporting( E_ALL );
ini_set( 'display_errors', 1 );
include( "inc/template.php" );

function main() {
	global $conn;
	?>

<div class="container-xxl flex-grow-1 container-p-y">
	<div class="d-flex flex-column justify-content-center">
     <h5 class="card-header mb-2">Blog List</h5>
      </div>
	<button class="btn btn-primary" onclick="window.location.href='blog_details_add.php'" type="button"><span><i class="ti ti-plus me-sm-1"></i> <span class="d-none d-sm-inline-block">Add New Blog</span></span></button>
	
			<div class="card">
                 <div class="card-datatable table-responsive">
<?php
$query = "SELECT * FROM blogs ORDER BY id DESC";
$result = mysqli_query($conn, $query);
?>

<table class="datatables-ajax table">
    <thead>
       <tr>
            <th>Photo</th>
            <th>Title</th>
            <th>Description</th>
            <th>Status</th>
            <th>Action</th>
        </tr>
    </thead>
    <tbody>
        <?php while ($row = mysqli_fetch_array($result)) { ?>
        <tr>
            <td>
                <img src="../<?= !empty($row['image']) ? htmlspecialchars($row['image']) : 'assets/img/no-image.jpg'; ?>" 
                     alt="Blog Image" width="60" height="60">
            </td>
            <td><?= htmlspecialchars($row['title']); ?></td>
            <td><?= htmlspecialchars(mb_strimwidth(strip_tags($row['description']), 0, 80, '...')); ?></td>

            <td>
                <label class="switch switch-success">
                    <input type="checkbox" class="switch-input" 
                        value="<?= $row['id']; ?>"
                        <?= $row['status'] == '1' ? 'checked' : ''; ?>
                        onclick="statusChange(<?= $row['id']; ?>);">
                    <span class="switch-toggle-slider">
                        <span class="switch-on"><i class="ti ti-check"></i></span>
                        <span class="switch-off"><i class="ti ti-x"></i></span>
                    </span>
                </label>
            </td>

            <td>
                <button type="button" class="btn btn-warning btn-xs" 
                        onclick="window.location.href='blog_details_add.php?id=<?= $row['id']; ?>';">
                    <i class="far fa-edit"></i>
                </button>
                <button type="button" id="<?= $row['id']; ?>" class="btn btn-danger btn-xs delete">
                    <i class="far fa-trash-alt"></i>
                </button>
            </td>
        </tr>
        <?php } ?>
    </tbody>
</table>

<!-- Modal -->


                </div>
              </div>
	

</div>

<script>
	
  $(document).ready(function () {
    // Handle delete action
    $(document).on('click', '.delete', function () {
        var id = $(this).attr("id");
        var row = $(this).closest('tr'); // Reference the row for deletion

        // SweetAlert2 confirmation
        Swal.fire({
            title: 'Are you sure?',
            text: 'You are about to delete this blog.',
            icon: 'warning',
            showCancelButton: true,
            confirmButtonText: 'Yes, delete it!',
            cancelButtonText: 'Cancel',
            reverseButtons: true
        }).then((result) => {
            if (result.isConfirmed) {
                // Proceed with AJAX delete request
                $.ajax({
                    url: "blog_details_action.php",
                    method: "POST",
                    data: { id: id, action: 'Delete' },
                    dataType: 'json',  // Ensure the response is JSON format
                    success: function(response) {
                        console.log(response);  // Debug the response
                        if (response.status === 'Success') {
                            Swal.fire({
                                title: 'Deleted!',
                                text: 'Blog Deleted Successfully.',
                                icon: 'success',
                                confirmButtonText: 'OK'
                            });

                            // Animate row removal
                            row.css('background-color', '#f8d7da').fadeOut(800, function () {
                                $(this).remove();
                            });
                        } else {
                            Swal.fire({
                                title: 'Error!',
                                text: response.message || 'There was an error deleting the blog.',
                                icon: 'error',
                                confirmButtonText: 'OK'
                            });
                        }
                    },
                    error: function(xhr, status, error) {
                        // Handle AJAX errors (network issues, etc.)
                        Swal.fire({
                            title: 'Error!',
                            text: 'Error deleting blog: ' + error,
                            icon: 'error',
                            confirmButtonText: 'OK'
                        });
                    }
                });
            }
        });
    });

    window.statusChange = function (id) {
        $.ajax({
            url: 'blog_details_action.php',
            method: 'POST',
            data: { id: id, action: 'StatusChange' },
            success: function (response) {
                // Parse the response manually
                const data = response;  // Directly use the response object as it's already JSON

                if (data.success) {
                    alert(`Status changed to ${data.new_status}`);
                } else {
                    alert(data.message);
                }
            },
            error: function () {
                alert('Error while updating status.');
            }
        });
    };
	  
	
  });
</script>

<?php } ?>