<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
require_once 'inc/config.php';

$response = [];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $action = $_POST['action'] ?? '';

    // Create Blog
    if ($action === 'Create') {
        $title = mysqli_real_escape_string($conn, $_POST['title'] ?? '');
        $slug = strtolower(trim(preg_replace('/[^A-Za-z0-9-]+/', '-', $title), '-'));
        $description = mysqli_real_escape_string($conn, $_POST['description'] ?? '');
        $imagePath = null;

        $dbImagePath = ''; // Default empty value

if (isset($_FILES['image']) && $_FILES['image']['error'] === 0) {
    $image = $_FILES['image'];
    $ext = pathinfo($image['name'], PATHINFO_EXTENSION);
    $uniqueName = uniqid('blog_', true) . '.' . $ext;
    $imagePath = '../uploads/' . $uniqueName; // Outside admin folder
    $dbImagePath = 'uploads/' . $uniqueName;

    move_uploaded_file($image['tmp_name'], $imagePath);
}



        $sql = "INSERT INTO blogs (title,slug, description, image) VALUES ('$title','$slug', '$description', " . ($dbImagePath ? "'$dbImagePath'" : "NULL") . ")";
        if (mysqli_query($conn, $sql)) {
            $response = ['status' => 'success', 'message' => 'Blog created successfully'];
        } else {
            $response = ['status' => 'error', 'message' => 'Database insert error: ' . mysqli_error($conn)];
        }
    }

    // Update Blog
    elseif ($action === 'Update') {
        $id = mysqli_real_escape_string($conn, $_POST['id']);
        $title = mysqli_real_escape_string($conn, $_POST['title'] ?? '');
        $slug = strtolower(trim(preg_replace('/[^A-Za-z0-9-]+/', '-', $title), '-'));
        $description = mysqli_real_escape_string($conn, $_POST['description'] ?? '');

        $imagePath = null;
        if (isset($_FILES['image']) && $_FILES['image']['error'] === 0) {
            $image = $_FILES['image'];
            $ext = pathinfo($image['name'], PATHINFO_EXTENSION);
            $uniqueName = uniqid('blog_', true) . '.' . $ext;
            $imagePath = '../uploads/' . $uniqueName;
            $dbImagePath = 'uploads/' . $uniqueName;
            move_uploaded_file($image['tmp_name'], $imagePath);

            // Delete old image
            $result = mysqli_query($conn, "SELECT image FROM blogs WHERE id = '$id'");
            if ($result && mysqli_num_rows($result) > 0) {
                $old = mysqli_fetch_assoc($result);
                if ($old['image'] && file_exists($old['image'])) {
                    unlink($old['image']);
                }
            }

            $sql = "UPDATE blogs SET title='$title',slug='$slug', description='$description', image='$dbImagePath' WHERE id='$id'";
        } else {
            $sql = "UPDATE blogs SET title='$title',slug='$slug', description='$description' WHERE id='$id'";
        }

        if (mysqli_query($conn, $sql)) {
            $response = ['status' => 'success', 'message' => 'Blog updated successfully'];
        } else {
            $response = ['status' => 'error', 'message' => 'Update failed: ' . mysqli_error($conn)];
        }
    }

    // Select Blog
    elseif ($action === 'Select') {
        $id = mysqli_real_escape_string($conn, $_POST['id']);
        $sql = "SELECT * FROM blogs WHERE id = '$id'";
        $result = mysqli_query($conn, $sql);

        if ($result && mysqli_num_rows($result) > 0) {
            $data = mysqli_fetch_assoc($result);
            $response = ['status' => 'Select', 'data' => $data];
        } else {
            $response = ['status' => 'error', 'message' => 'Blog not found'];
        }
    }

    // Delete Blog (Optional)
elseif ($action === 'Delete') {
    $id = mysqli_real_escape_string($conn, $_POST['id']);

    // Delete image if exists
    $result = mysqli_query($conn, "SELECT image FROM blogs WHERE id = '$id'");
    if ($result && mysqli_num_rows($result) > 0) {
        $data = mysqli_fetch_assoc($result);
        if (!empty($data['image']) && file_exists($data['image'])) {
            unlink($data['image']);
        }
    }

    $del = mysqli_query($conn, "DELETE FROM blogs WHERE id = '$id'");
    if ($del) {
        $response = ['status' => 'Success', 'message' => 'Blog deleted successfully']; // Capital "Success"
    } else {
        $response = ['status' => 'Error', 'message' => 'Delete failed: ' . mysqli_error($conn)];
    }
}

	elseif ($action === 'StatusChange') {
    $id = mysqli_real_escape_string($conn, $_POST['id']);

    // Fetch current status
    $statusQuery = mysqli_query($conn, "SELECT status FROM blogs WHERE id = '$id'");
    if ($statusQuery && mysqli_num_rows($statusQuery) > 0) {
        $current = mysqli_fetch_assoc($statusQuery);
        $newStatus = $current['status'] == 1 ? 0 : 1;

        // Update status
        $update = mysqli_query($conn, "UPDATE blogs SET status = '$newStatus' WHERE id = '$id'");
        if ($update) {
            $statusText = $newStatus == 1 ? 'Active' : 'Inactive';
            $response = ['status' => 'Success', 'message' => "Status changed to $statusText."];
        } else {
            $response = ['status' => 'Error', 'message' => 'Failed to update status.'];
        }
    } else {
        $response = ['status' => 'Error', 'message' => 'Blog not found.'];
    }
}


    else {
        $response = ['status' => 'error', 'message' => 'Invalid action'];
    }

    header('Content-Type: application/json');
    echo json_encode($response);
    exit;
}
