
'use strict';

(function () {
  
  const fullToolbar = [
    [
      {
        font: []
      },
      {
        size: []
      }
    ],
    ['bold', 'italic', 'underline', 'strike'],
    [
      {
        color: []
      },
      {
        background: []
      }
    ],
    [
      {
        script: 'super'
      },
      {
        script: 'sub'
      }
    ],
    [
      {
        header: '1'
      },
      {
        header: '2'
      },
      'blockquote',
      'code-block'
    ],
    [
      {
        list: 'ordered'
      },
      {
        list: 'bullet'
      },
      {
        indent: '-1'
      },
      {
        indent: '+1'
      }
    ],
    [{ direction: 'rtl' }],
    ['link', 'image', 'video', 'formula'],
    ['clean']
  ];
  const fullEditor = new Quill('#full-editor', {
    bounds: '#full-editor',
    placeholder: 'Type Something...',
    modules: {
      formula: true,
      toolbar: fullToolbar
    },
    theme: 'snow'
  });

  // Room Inclusion Editor Initialization
  const roomInclusionEditor = new Quill('#roomInclusionEditor', {
    bounds: '#roomInclusionEditor',
    placeholder: 'Type Room Inclusion...',
    modules: {
      toolbar: fullToolbar
    },
    theme: 'snow'
  });

  // Cancellation Policy Editor Initialization
  const cancellationPolicyEditor = new Quill('#cancellationPolicyEditor', {
    bounds: '#cancellationPolicyEditor',
    placeholder: 'Type Cancellation Policy...',
    modules: {
      toolbar: fullToolbar
    },
    theme: 'snow'
  });
})();
