<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

include('inc/config.php');

header('Content-Type: application/json'); // Always return JSON response

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['action'])) {
        $action = $_POST['action'];

        if ($action === 'Create' || $action === 'Update') {
            $required_fields = ['adminname', 'mobile', 'adminuser'];
            //$missing = array_filter($required_fields, fn($field) => empty($_POST[$field]));
				$missing = array_filter($required_fields, function ($field) {
    return empty($_POST[$field]);
});

            if (!empty($missing)) {
                echo json_encode(['success' => false, 'message' => 'All fields are required.']);
                exit;
            }

            $adminname = ucwords(mysqli_real_escape_string($conn, $_POST['adminname']));
            $mobile = $_POST['mobile'];
            $adminuser = $_POST['adminuser'];
            $password = $_POST['password'] ?? '';
            $id = $_POST['id'] ?? '';
            $role = $_POST['role'] ?? 'admin';

            // Duplicate check
            $check_sql = "SELECT * FROM users WHERE (phone = '$mobile' OR email = '$adminuser')" . ($action === 'Update' ? " AND id != '$id'" : "");
            $check_result = mysqli_query($conn, $check_sql);

            if (mysqli_num_rows($check_result) > 0) {
                echo json_encode(['success' => false, 'message' => 'Duplicate']);
                exit;
            }

            if ($action === 'Create') {
                if (empty($password)) {
                    echo json_encode(['success' => false, 'message' => 'Password is required.']);
                    exit;
                }

                $hashed_password = password_hash($password, PASSWORD_DEFAULT);
                $status = 1;
                $created_at = date('Y-m-d H:i:s');

                 $insert_sql = "INSERT INTO users (email, password, role, name, phone, status, created_at) 
                               VALUES ('$adminuser', '$hashed_password', '$role', '$adminname', '$mobile', '$status', '$created_at')";

                if (mysqli_query($conn, $insert_sql)) {
                    echo json_encode(['success' => true, 'action' => 'Create']);
                } else {
                    echo json_encode(['success' => false, 'message' => 'Insert error']);
                }
            } elseif ($action === 'Update') {
                $update_sql = "UPDATE users SET name = '$adminname', phone = '$mobile', email = '$adminuser' WHERE id = $id";
                if (mysqli_query($conn, $update_sql)) {
                    echo json_encode(['success' => true, 'action' => 'Update']);
                } else {
                    echo json_encode(['success' => false, 'message' => 'Update error']);
                }
            }
        }

        elseif ($action === 'Select') {
            if (!empty($_POST['id'])) {
                $id = $_POST['id'];
                $select_sql = "SELECT * FROM users WHERE id = $id";
                $result = mysqli_query($conn, $select_sql);
                if ($row = mysqli_fetch_assoc($result)) {
                    echo json_encode($row);
                } else {
                    echo json_encode(['success' => false, 'message' => 'User not found']);
                }
            } else {
                echo json_encode(['success' => false, 'message' => 'ID is required']);
            }
        }

        elseif ($action === 'Delete') {
            if (!empty($_POST['id'])) {
                $id = $_POST['id'];
                $delete_sql = "DELETE FROM users WHERE id = $id";
                if (mysqli_query($conn, $delete_sql)) {
                    echo json_encode(['success' => true, 'action' => 'Delete']);
                } else {
                    echo json_encode(['success' => false, 'message' => 'Delete error']);
                }
            } else {
                echo json_encode(['success' => false, 'message' => 'ID is required']);
            }
        }

        elseif ($action === 'StatusChange') {
            if (!empty($_POST['id'])) {
                $id = $_POST['id'];
                $result = mysqli_query($conn, "SELECT status FROM users WHERE id = $id");

                if ($row = mysqli_fetch_assoc($result)) {
                    $new_status = $row['status'] == 1 ? 0 : 1;
                    $update = mysqli_query($conn, "UPDATE users SET status = '$new_status' WHERE id = $id");
                    if ($update) {
                        echo json_encode(['success' => true, 'new_status' => $new_status]);
                    } else {
                        echo json_encode(['success' => false, 'message' => 'Status update failed']);
                    }
                } else {
                    echo json_encode(['success' => false, 'message' => 'User not found']);
                }
            } else {
                echo json_encode(['success' => false, 'message' => 'ID is required']);
            }
        }

        else {
            echo json_encode(['success' => false, 'message' => 'Invalid action']);
        }
    } else {
        echo json_encode(['success' => false, 'message' => 'Action is required']);
    }
} else {
    echo json_encode(['success' => false, 'message' => 'Invalid request method']);
}
?>
