<?php
require_once '../models/ProductSubCategoryModel.php';
require_once '../iadmin/inc/db.php';

$productSubCategory = new ProductSubCategoryModel($conn);

if ($_GET['action'] == 'fetch' && isset($_GET['category'])) {
    $slug = $_GET['category'];
	$offset = isset($_GET['offset']) ? intval($_GET['offset']) : 0;
    $limit = isset($_GET['limit']) ? intval($_GET['limit']) : 12;

    
    $productSubCategorys = $productSubCategory->getAllSubProducts($slug, $offset, $limit);
	if (empty($productSubCategorys)) {
        echo '<div class="no-products-marker" style="display:none;"></div>';
        exit;
    }
    $aosAnimations = ['fade-up', 'fade-down', 'zoom-in', 'flip-left', 'fade-right', 'fade-left'];

    foreach ($productSubCategorys as $index => $row) {
        $aos = $aosAnimations[$index % count($aosAnimations)];
		
?>


<div class="col-xl-3 col-lg-4 col-md-6" data-aos="<?= $aos ?>" data-aos-duration="1000">
							<div class="rs-services-wrapper">
								<div class="rs-services-item">
									<div class="rs-services-thumb">
										<a href="product-details.php?product=<?= urlencode($row['slug']) ?>">
    <img src="uploads/subproducts/<?= urlencode($row['image']) ?>" alt="<?= htmlspecialchars($row['subcat_name']) ?>"></a>
										
									</div>
									<div class="rs-services-content">
										<h6 class="rs-services-title"><a href="product-details.php?product=<?= $row['slug'] ?>"> <?= htmlspecialchars($row['subcat_name']) ?>
                                        </a></h6>
										
										<div class="rs-services-number"></div>
										<div class="rs-services-btn-wrapper">
											<div class="rs-services-text-btn underline">
												<a class="rs-text-btn" href="product-details.php?product=<?= $row['slug'] ?>">View
                                                Details</a>
											</div>
											<a class="rs-square-btn has-icon has-light-bg" href="product-details.php?product=<?= $row['slug'] ?>">
                                            <span class="icon-box">
                                    <svg class="icon-first" xmlns="http://www.w3.org/2000/svg" width="12" height="10"
                                       viewBox="0 0 12 10" fill="none">
                                       <path fill-rule="evenodd" clip-rule="evenodd"
                                          d="M0 5C0 4.60551 0.319797 4.28571 0.714286 4.28571L8.98985 4.28571L5.92349 1.21936C5.64455 0.940417 5.64455 0.488155 5.92349 0.209209C6.20244 -0.0697365 6.6547 -0.0697365 6.93365 0.209209L11.2194 4.49492C11.4983 4.77387 11.4983 5.22613 11.2194 5.50508L6.93365 9.79079C6.6547 10.0697 6.20244 10.0697 5.92349 9.79079C5.64455 9.51184 5.64455 9.05958 5.92349 8.78064L8.98985 5.71429L0.714286 5.71429C0.319797 5.71429 0 5.39449 0 5Z"
                                          fill="#616161"></path>
                                    </svg>
                                    <svg class="icon-second" xmlns="http://www.w3.org/2000/svg" width="12" height="10"
                                       viewBox="0 0 12 10" fill="none">
                                       <path fill-rule="evenodd" clip-rule="evenodd"
                                          d="M0 5C0 4.60551 0.319797 4.28571 0.714286 4.28571L8.98985 4.28571L5.92349 1.21936C5.64455 0.940417 5.64455 0.488155 5.92349 0.209209C6.20244 -0.0697365 6.6547 -0.0697365 6.93365 0.209209L11.2194 4.49492C11.4983 4.77387 11.4983 5.22613 11.2194 5.50508L6.93365 9.79079C6.6547 10.0697 6.20244 10.0697 5.92349 9.79079C5.64455 9.51184 5.64455 9.05958 5.92349 8.78064L8.98985 5.71429L0.714286 5.71429C0.319797 5.71429 0 5.39449 0 5Z"
                                          fill="#616161"></path>
                                    </svg>
                                 </span>
                                        </a>
										
										</div>
									</div>
								</div>
							</div>
						</div>
		
       
        <?php
    }
} 

if ($_GET['action'] === 'related' && isset($_GET['product'])) {
    require_once '../iadmin/inc/db.php';
    require_once '../models/ProductSubCategoryModel.php';

    $slug = $_GET['product'];
    $productSubCategory = new ProductSubCategoryModel($conn);
    $relatedProducts = $productSubCategory->getRelatedProducts($slug);

    if (empty($relatedProducts)) {
        echo '<div class="swiper-slide"><div class="text-center text-warning">No related products found.</div></div>';
        exit;
    }
	$aosAnimations = ['fade-up', 'fade-down', 'zoom-in', 'flip-left', 'fade-right', 'fade-left'];
    foreach ($relatedProducts as $index => $row) {
		$aos = $aosAnimations[$index % count($aosAnimations)];
        echo '<div class="swiper-slide" data-aos="' . $aos . '" data-aos-duration="1000">
            <div class="rs-services-item">
                <div class="rs-services-thumb">
                    <a href="product-details.php?product=' . urlencode($row['slug']) . '">
                        <img src="uploads/subproducts/' . htmlspecialchars($row['image']) . '" alt="' . htmlspecialchars($row['subcat_name']) . '" style="height:200px;object-fit:cover;">
                    </a>
                </div>
                <div class="rs-services-content">
                    <h5 class="rs-services-title">
                        <a href="product-details.php?product=' . urlencode($row['slug']) . '">' . htmlspecialchars($row['subcat_name']) . '</a>
                    </h5>
                    <div class="rs-services-btn-wrapper">
                        <div class="rs-services-text-btn underline has-theme-yellow">
                            <a class="rs-text-btn" href="product-details.php?product=' . urlencode($row['slug']) . '">View Details</a>
                        </div>
						<a class="rs-square-btn has-icon has-light-bg" href="services-details.html">
                                                    <span class="icon-box">
                                          <svg class="icon-first" xmlns="http://www.w3.org/2000/svg" width="12"
                                             height="10" viewBox="0 0 12 10" fill="none">
                                             <path fill-rule="evenodd" clip-rule="evenodd"
                                                d="M0 5C0 4.60551 0.319797 4.28571 0.714286 4.28571L8.98985 4.28571L5.92349 1.21936C5.64455 0.940417 5.64455 0.488155 5.92349 0.209209C6.20244 -0.0697365 6.6547 -0.0697365 6.93365 0.209209L11.2194 4.49492C11.4983 4.77387 11.4983 5.22613 11.2194 5.50508L6.93365 9.79079C6.6547 10.0697 6.20244 10.0697 5.92349 9.79079C5.64455 9.51184 5.64455 9.05958 5.92349 8.78064L8.98985 5.71429L0.714286 5.71429C0.319797 5.71429 0 5.39449 0 5Z"
                                                fill="#616161"></path>
                                          </svg>
                                          <svg class="icon-second" xmlns="http://www.w3.org/2000/svg" width="12"
                                             height="10" viewBox="0 0 12 10" fill="none">
                                             <path fill-rule="evenodd" clip-rule="evenodd"
                                                d="M0 5C0 4.60551 0.319797 4.28571 0.714286 4.28571L8.98985 4.28571L5.92349 1.21936C5.64455 0.940417 5.64455 0.488155 5.92349 0.209209C6.20244 -0.0697365 6.6547 -0.0697365 6.93365 0.209209L11.2194 4.49492C11.4983 4.77387 11.4983 5.22613 11.2194 5.50508L6.93365 9.79079C6.6547 10.0697 6.20244 10.0697 5.92349 9.79079C5.64455 9.51184 5.64455 9.05958 5.92349 8.78064L8.98985 5.71429L0.714286 5.71429C0.319797 5.71429 0 5.39449 0 5Z"
                                                fill="#616161"></path>
                                          </svg>
                                       </span>
                                                </a>
                    </div>
                </div>
            </div>
        </div>';
    }
    exit;
}
