jQuery().ready(function () {
    var submiturl = 'submit/submit.php';
    jQuery.validator.addMethod("textonly", function (value, element)
    {
        return this.optional(element) || /^[a-z," "]+$/i.test(value);
    }, "Please enter only characters.");

    //VALIDATE USER EMAIL            
    jQuery.validator.addMethod("validateUserEmail", function (value, element) {
        var response;
        jQuery.ajax({
            type: "POST",
            url: submiturl,
            dataType: "json",
            data: "email=" + value + "&method=is_contact_exist&module_name=Contacts",
            async: false,
            success: function (data) {
                response = data;
            },
        });
        if (response.success == true) {
            return true;
        } else {
            return false;
        }
    }, 'This email ID is already exist.');

    jQuery('#open_live_account').validate({
        rules: {
            firstname: {
                required: true,
                textonly: true,
                maxlength: 25
            },
            lastname: {
                required: true,
                textonly: true,
                maxlength: 25
            },
            email: {
                required: true,
                email: true,
                maxlength: 100,
                validateUserEmail: true
            },
            country_name: {
                required: true
            },
            city: {
                textonly: true,
            },
            mobile: {
                required: true,
                number: true,
                minlength: 8,
                maxlength: 14
            },
            captcha_live: {
                required: true,
                remote: {
                    url: 'captcha/checkLive.php',
                    type: 'post',
                    data: {
                        code: function() {
                            return jQuery(':input[name="captcha_live"]').val();
                        }
                    }
                },
            },
        },
        messages: {
            firstname: {
                required: "Please enter firstname.",
                maxlength: 'First name length should not be more than 25.'
            },
            lastname: {
                required: "Please enter lastname.",
                maxlength: 'Last name length should not be more than 25.'
            },
            email: {
                required: "Please enter email address."
            },
            country_name: {
                required: "Please select country."
            },
            mobile: {
                required: "Please enter a phone number.",
                number: "Please enter a valid phone number.",
                minlength: "Phone number length should be between 8 to 14.",
                maxlength: "Phone number length should be between 8 to 14."
            },
            captcha_live: {
                required: "Please enter the verification code.",
                remote: "Verification code incorrect, please try again.",
            },
        },
        submitHandler: function(form) {
            $.ajax({
                url: submiturl,
                type: 'POST',
                data: jQuery("#open_live_account").serialize(),
                dataType: 'json',
                beforeSend: function () {
                    jQuery('.submit-live').hide();
                    jQuery('.loader_img').show();
                },
                complete: function () {
                    jQuery('.submit-live').show();
                    jQuery('.loader_img').hide();
                },
                success: function (response) {
                    if (response.success) {
                        showalert(langobj[response.success_message.code], 'open_live_account', 'alert-success');
                    } else {
                        if (response.error.code == 0) {
                            showalert(langobj[response.error.message], 'open_live_account', 'alert-danger');
                        } else {
                            if (langobj[response.error.code] == 'undefined') {
                                showalert(response.error.code, 'open_live_account', 'alert-danger');
							} else {
                                showalert(langobj[response.error.code], 'open_live_account', 'alert-danger');
							}
                        }
                    }
                    jQuery("#open_live_account").trigger("reset");
					reloadCaptchaLive();
                }
            });
            return false;
        },
    });
});




jQuery().ready(function () {
    var submitdemourl = 'submit/submit-demo.php';
    jQuery.validator.addMethod("textonly", function (value, element)
    {
        return this.optional(element) || /^[a-z," "]+$/i.test(value);
    }, "Please enter only characters.");

    jQuery('#open_demo_account').validate({
        rules: {
            firstname: {
                required: true,
                textonly: true,
                maxlength: 25
            },
            lastname: {
                required: true,
                textonly: true,
                maxlength: 25
            },
            email: {
                required: true,
                email: true,
                maxlength: 100
            },
            country_name: {
                required: true
            },
            city: {
                textonly: true,
            },
            mobile: {
                required: true,
                number: true,
                minlength: 8,
                maxlength: 14
            },
            leverage: {
                required: true
            },
            balance: {
                required: true
            },
            captcha_demo: {
                required: true,
                remote: {
                    url: 'captcha/checkDemo.php',
                    type: 'post',
                    data: {
                        code: function() {
                            return jQuery(':input[name="captcha_demo"]').val();
                        }
                    }
                },
            },
        },
        messages: {
            firstname: {
                required: "Please enter firstname.",
                maxlength: 'First name length should not be more than 25.'
            },
            lastname: {
                required: "Please enter lastname.",
                maxlength: 'Last name length should not be more than 25.'
            },
            email: {
                required: "Please enter email address."
            },
            country_name: {
                required: "Please select country."
            },
            mobile: {
                required: "Please enter a phone number.",
                number: "Please enter a valid phone number.",
                minlength: "Phone number length should be between 8 to 14.",
                maxlength: "Phone number length should be between 8 to 14."
            },
            leverage: {
                required: "Please select leverage."
            },
            balance: {
                required: "Please select balance."
            },
            captcha_demo: {
                required: "Please enter the verification code.",
                remote: "Verification code incorrect, please try again.",
            },
        },
        submitHandler: function(form) {
            $.ajax({
                url: submitdemourl,
                type: 'POST',
                data: jQuery("#open_demo_account").serialize(),
                dataType: 'json',
                beforeSend: function () {
                    jQuery('.submit-demo').hide();
                    jQuery('.loader_img').show();
                },
                complete: function () {
                    jQuery('.submit-demo').show();
                    jQuery('.loader_img').hide();
                },
                success: function (response) {
                    if (response.success) {
                        showalert(langobj[response.success_message.code], 'open_demo_account', 'alert-success');
                    } else {
                        if (response.error.code == 0) {
                            showalert(langobj[response.error.message], 'open_demo_account', 'alert-danger');
                        } else {
                            if (langobj[response.error.code] == 'undefined') {
                                showalert(response.error.code, 'open_demo_account', 'alert-danger');
                            } else {
                                showalert(langobj[response.error.code], 'open_demo_account', 'alert-danger');
                            }
                        }                           
                    }
                    jQuery("#open_demo_account").trigger("reset");
                    reloadCaptchaDemo();
                }
            });
            return false;
        },
    });
});




jQuery().ready(function () {
    var submitcontacturl = 'submit/submit-contact.php';
    jQuery.validator.addMethod("textonly", function (value, element)
    {
        return this.optional(element) || /^[a-z," "]+$/i.test(value);
    }, "Please enter only characters.");
   
    jQuery('#contact_us').validate({
        rules: {
            firstname: {
                required: true,
                textonly: true,
                maxlength: 25
            },
            lastname: {
                required: true,
                textonly: true,
                maxlength: 25
            },
            email: {
                required: true,
                email: true,
                maxlength: 100,
            },
            country_name: {
                required: true
            },
            city: {
                textonly: true,
            },
            mobile: {
                required: true,
                number: true,
                minlength: 8,
                maxlength: 14
            },
            ticket_title: {
                required: true
            },
            description: {
                required: true
            },
            captcha_contact: {
                required: true,
                remote: {
                    url: 'captcha/checkContact.php',
                    type: 'post',
                    data: {
                        code: function() {
                            return jQuery(':input[name="captcha_contact"]').val();
                        }
                    }
                },
            },
        },
        messages: {
            firstname: {
                required: "Please enter firstname.",
                maxlength: 'First name length should not be more than 25.'
            },
            lastname: {
                required: "Please enter lastname.",
                maxlength: 'Last name length should not be more than 25.'
            },
            email: {
                required: "Please enter email address."
            },
            country_name: {
                required: "Please select country."
            },
            mobile: {
                required: "Please enter a phone number.",
                number: "Please enter a valid phone number.",
                minlength: "Phone number length should be between 8 to 14.",
                maxlength: "Phone number length should be between 8 to 14."
            },
            ticket_title: {
                required: "Please enter subject."
            },
            description: {
                required: "Please enter description."
            },
            captcha_contact: {
                required: "Please enter the verification code.",
                remote: "Verification code incorrect, please try again.",
            },
        },
        submitHandler: function(form) {
            $.ajax({
                url: submitcontacturl,
                type: 'POST',
                data: jQuery("#contact_us").serialize(),
                dataType: 'json',
                beforeSend: function () {
                    jQuery('.submit-contact').hide();
                    jQuery('.loader_img').show();
                },
                complete: function () {
                    jQuery('.submit-contact').show();
                    jQuery('.loader_img').hide();
                },
                success: function (response) {
                    if (response.success) {
                        showalert(langobj[response.success_message.code], 'contact_us', 'alert-success');
                    } else {
                        if (response.error.code == 0) {
                            showalert(langobj[response.error.message], 'contact_us', 'alert-danger');
                        } else {
                            if (langobj[response.error.code] == 'undefined') {
                                showalert(response.error.code, 'contact_us', 'alert-danger');
                            } else {
                                showalert(langobj[response.error.code], 'contact_us', 'alert-danger');
                            }
                        }
                    }
                    jQuery("#contact_us").trigger("reset");
                    reloadCaptchaContact();
                }
            });
            return false;
        },
    });
});



//get_template_directory_uri()
function reloadCaptchaContact() {
    jQuery('img#contactCaptcha').attr("src", "captcha/captchaContact.php");
    jQuery('#captcha_contact').val("");
}

//get_template_directory_uri()
function reloadCaptchaDemo() {
    jQuery('img#demoCaptcha').attr("src", "captcha/captchaDemo.php");
    jQuery('#captcha_demo').val("");
}

//get_template_directory_uri()
function reloadCaptchaLive() {
    jQuery('img#liveCaptcha').attr("src", "captcha/captchaLive.php");
    jQuery('#captcha_live').val("");
}

function showalert(message, container_id, alert_type) {
    jQuery("#" + container_id).find(".popup_message").html('');
    jQuery("#" + container_id).find(".popup_message").css('display', 'block');
    jQuery("#" + container_id).find(".popup_message").html('<div id="gobal_alert_message"><div class="alert ' + alert_type + ' alert-dismissible">' + message + '</div></div>');

    setTimeout(function () {
        jQuery("#gobal_alert_message").remove();
    }, 10000);
    jQuery(window).scrollTop(100);
}