<?php $__env->startSection('pageTitle'); ?> <?php echo $__env->make('layouts.includes.title', ['moduleTitle' => __('Student')], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?> <?php $__env->stopSection(); ?>

<?php $__env->startSection('pageBreadcrumb'); ?> <?php echo $__env->make('layouts.includes.breadcrumb', ['moduleTitle' => __('Add').' '.__('student') ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?> <?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-sm-12">
            <div class="card-box">
                <?php echo $__env->make('layouts.modules.header', [ 'title' => __('student::locale.student_admission')], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <div class="card-body row">
                    <?php if(isset($student) && isset($isStudentProfile)): ?>
                        <?php echo Form::model($student, ['route' => ['students-profile.update', $student->id] ,'files' => true, "type" => "card" ]); ?>

                    <?php elseif(isset($student)): ?>
                        <?php echo Form::model($student, ['route' => [$moduleName.'.update', $student->id] ,'files' => true, "type" => "card" ]); ?>

                    <?php else: ?>
                        <?php echo Form::open([ 'route' => $moduleName.'.store' ,'files' => true, "type" => "card"]); ?>

                    <?php endif; ?>
                        <?php echo Form::hidden('user_id', $student->user->id ??  old('user_id')); ?>


                        <div class="row <?php echo e(\App\Facades\General::isSchoolAdmin() ? 'show' : 'hide'); ?>">
                            <?php echo Form::openGroup('admission_no', __('student::locale.admission_no')); ?>

                            <?php echo Form::text('admission_no', $student->admission_no ?? old('admission_no') ); ?>

                            <?php echo Form::closeGroup(); ?>


                            <?php echo Form::openGroup('roll_no', __('student::locale.roll_no')); ?>

                            <?php echo Form::text('roll_no', $student->roll_no ?? old('roll_no')); ?>

                            <?php echo Form::closeGroup(); ?>


                            <?php echo Form::openGroup('class_id', __('student::locale.class') ,array("lbl_class" => "required")); ?>

                            <?php echo Form::select('class_id', [null=>__('locale.please_select')] +$data['studentClasses'], $student->class_id ?? old('class_id'), array("required" => "true", 'class'=> 'form-control __change__student__class', 'data-url' => route('class.ajax_on_change', 'classId'),'defaultTxt' => __( 'locale.select' ) ) ); ?>

                            <?php echo Form::closeGroup(); ?>


                            <?php echo Form::openGroup('section_id', __('student::locale.section') ,array("lbl_class" => "required")); ?>

                            <div class="__replace__section__byClass">
                                <?php echo Form::select('section_id', [null=>__('locale.please_select')]+$data["sections"],$student->section_id ?? old('section_id'), array("required" => "true", 'class'=> 'form-control','defaultTxt' => __( 'locale.select' ) ) ); ?>

                            </div>
                            <?php echo Form::closeGroup(); ?>

                        </div>

                    <div class="row">
                        <?php echo Form::openGroup('name', __('locale.name'),array("lbl_class" => "required")); ?>

                        <?php echo Form::text('name',$student->user->name ?? old('name'),array("required" => true)); ?>

                        <?php echo Form::closeGroup(); ?>


                        <?php echo Form::openGroup('gender', __('student::locale.gender') ); ?>

                        <?php echo Form::select('gender', [null=>__('locale.please_select')]+$data['gender'],$student->user->gender ?? old('gender'), array('class'=> 'form-control','defaultTxt' => __( 'locale.select' ) ) ); ?>

                        <?php echo Form::closeGroup(); ?>


                        <?php echo Form::openGroup('dob', __('locale.dob')); ?>

                        <?php echo Form::text('dob',$student->user->dob ?? old('dob'),[ "autocomplete" => "off",'class' => 'form-control setDatePicker']); ?>

                        <?php echo Form::closeGroup(); ?>


                        <?php echo Form::openGroup('category_id', __('student::locale.category') ); ?>

                        <?php echo Form::select('category_id', [null=>__('locale.please_select')]+$data['categories'],$student->category_id ?? old('category_id'), array('class'=> 'form-control','defaultTxt' => __( 'locale.select' ) ) ); ?>

                        <?php echo Form::closeGroup(); ?>

                    </div>

                    <div class="row">
                        <?php echo Form::openGroup('religion', 'student::locale.religion'); ?>

                        <?php echo Form::text('religion',$student->religion ?? old('religion')); ?>

                        <?php echo Form::closeGroup(); ?>


                        <?php echo Form::openGroup('cast', 'student::locale.cast'); ?>

                        <?php echo Form::text('cast',$student->cast ?? old('cast')); ?>

                        <?php echo Form::closeGroup(); ?>


                        <?php echo Form::openGroup('mobile_number', 'student::locale.mobile_number',array("lbl_class" => "required")); ?>

                        <?php echo Form::text('mobile_number',$student->user->mobile_number ?? old('mobile_number'),array("required" => true)); ?>

                        <?php echo Form::closeGroup(); ?>


                        <?php echo Form::openGroup('email', 'student::locale.email',array("lbl_class" => "required")); ?>

                        <?php echo Form::text('email',$student->user->email ?? old('email'),array("required" => true)); ?>

                        <?php echo Form::closeGroup(); ?>

                    </div>

                    <div class="row">
                        <?php echo Form::openGroup('admission_date', __('locale.admission_date')); ?>

                        <?php echo Form::text('admission_date',$student->admission_date ?? old('admission_date'),["autocomplete" => "off",'class' => 'form-control setDatePicker']); ?>

                        <?php echo Form::closeGroup(); ?>


                        <?php echo Form::openGroup('avatar',  Lang::get('student::locale.avatar')); ?>

                        <?php echo Form::file('avatar'); ?>

                        <?php $__env->startPush("scripts-footer"); ?>
                            <?php
                                $options = [];
                                if (isset($student->user->avatar)) {
                                    $options["initialPreview"][] = $student->user->avatar;
                                } ?>
                            <?php echo Form::filejs(); ?>

                        <?php $__env->stopPush(); ?>
                        <?php echo Form::closeGroup(); ?>


                        <?php echo Form::openGroup('blood_group', __('student::locale.blood_group') ,array("lbl_class" => "required")); ?>

                        <?php echo Form::select('blood_group', [null=>__('locale.please_select')]+$data['bloodGroup'],$student->user->blood_group ?? old('blood_group'), array("required" => "true",'class'=> 'form-control','defaultTxt' => __( 'locale.select' ) ) ); ?>

                        <?php echo Form::closeGroup(); ?>


                        <?php echo Form::openGroup('house_id', __('student::locale.house') ); ?>

                        <?php echo Form::select('house_id', [null=>__('locale.please_select')]+$data['houses'],$student->house_id ?? old('house_id'), array('class'=> 'form-control','defaultTxt' => __( 'locale.select' ) ) ); ?>

                        <?php echo Form::closeGroup(); ?>

                    </div>

                    <div class="row">
                        <?php echo Form::openGroup('height', 'student::locale.height'); ?>

                        <?php echo Form::text('height',$student->height ?? old('height')); ?>

                        <?php echo Form::closeGroup(); ?>


                        <?php echo Form::openGroup('weight', 'student::locale.weight'); ?>

                        <?php echo Form::text('weight',$student->weight ?? old('weight')); ?>

                        <?php echo Form::closeGroup(); ?>


                        <?php echo Form::openGroup('measure_date', __('student::locale.measure_date')); ?>

                        <?php echo Form::text('measure_date',$student->measure_date ?? old('measure_date'),["autocomplete" => "off",'class' => 'form-control setDatePicker']); ?>

                        <?php echo Form::closeGroup(); ?>


                        <?php echo Form::openGroup('medical_history', 'student::locale.medical_history'); ?>

                        <?php echo Form::textarea('medical_history',$student->medical_history ?? old('medical_history'),["rows" => 4]); ?>

                        <?php echo Form::closeGroup(); ?>

                    </div>
                </div>
            </div>

            <?php if(\App\Facades\General::isSchoolAdmin()): ?>
            <div class="card card-topline-aqua">
                <?php echo $__env->make('layouts.modules.header', [ 'title' => __('student::locale.parent_guardian_detail'), 'hide'=> true], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <div class="card-body row">
                    <div class="row">
                        <?php echo Form::openGroup('father_name', 'student::locale.father_name'); ?>

                        <?php echo Form::text('father_name', $student->father_name ?? old('father_name')); ?>

                        <?php echo Form::closeGroup(); ?>


                        <?php echo Form::openGroup('father_phone', 'student::locale.father_phone'); ?>

                        <?php echo Form::text('father_phone', $student->father_phone ?? old('father_phone')); ?>

                        <?php echo Form::closeGroup(); ?>


                        <?php echo Form::openGroup('father_occupation', 'student::locale.father_occupation'); ?>

                        <?php echo Form::text('father_occupation', $student->father_occupation ?? old('father_occupation')); ?>

                        <?php echo Form::closeGroup(); ?>


                        <?php echo Form::openGroup('father_photo',  Lang::get('student::locale.father_photo')); ?>

                        <?php echo Form::file('father_photo'); ?>

                        <?php $__env->startPush("scripts-joining_letter"); ?>
                            <?php echo Form::filejs(); ?>

                        <?php $__env->stopPush(); ?>
                        <?php echo Form::closeGroup(); ?>

                    </div>
                    <div class="row">
                        <?php echo Form::openGroup('mother_name', 'student::locale.mother_name'); ?>

                        <?php echo Form::text('mother_name', $student->mother_name ?? old('mother_name')); ?>

                        <?php echo Form::closeGroup(); ?>


                        <?php echo Form::openGroup('mother_phone', 'student::locale.mother_phone'); ?>

                        <?php echo Form::text('mother_phone', $student->mother_phone ?? old('mother_phone')); ?>

                        <?php echo Form::closeGroup(); ?>


                        <?php echo Form::openGroup('mother_occupation', 'student::locale.mother_occupation'); ?>

                        <?php echo Form::text('mother_occupation', $student->mother_occupation ?? old('mother_occupation')); ?>

                        <?php echo Form::closeGroup(); ?>


                        <?php echo Form::openGroup('mother_photo',  Lang::get('student::locale.mother_photo')); ?>

                        <?php echo Form::file('mother_photo'); ?>

                        <?php $__env->startPush("scripts-joining_letter"); ?>
                            <?php echo Form::filejs(); ?>

                        <?php $__env->stopPush(); ?>
                        <?php echo Form::closeGroup(); ?>

                    </div>
                    <div class="row">
                        <div class="col-lg-12 p-t-20 text-right">
                            <label><?php echo e(__('student::locale.if_guardian_is')); ?>

                                <small class="req"> *</small>&nbsp;&nbsp;&nbsp;</label>
                            <label class="radio-inline">
                                <input type="radio" name="guardian_is" value="father" class="__sms__copy__guardian"
                                       <?php echo e(isset($student) && $student->guardian_is == 'father' ? 'checked' : ''); ?> autocomplete="off"> <?php echo e(__('student::locale.father')); ?>

                            </label>
                            
                            <label class="radio-inline">
                                <input type="radio" name="guardian_is" value="mother"
                                       class="__sms__copy__guardian" <?php echo e(isset($student) && $student->guardian_is == 'mother' ? 'checked' : ''); ?>> <?php echo e(__('student::locale.mother')); ?>

                            </label>
                            <label class="radio-inline">
                                <input type="radio" name="guardian_is" value="other"
                                       class="__sms__copy__guardian" <?php echo e(isset($student) && $student->guardian_is == 'other' ? 'checked' : ''); ?>> <?php echo e(__('student::locale.other')); ?>

                            </label>
                            <span class="text-danger"></span>
                        </div>
                    </div>
                    <div class="row">
                        <?php echo Form::hidden('guardian_id', $student->guardian->id ??  old('guardian_id')); ?>

                        <?php echo Form::openGroup('guardian_name', 'student::locale.guardian_name'); ?>

                        <?php echo Form::text('guardian_name', $student->guardian->name ??  old('guardian_name')); ?>

                        <?php echo Form::closeGroup(); ?>


                        <?php echo Form::openGroup('guardian_relation', 'student::locale.guardian_relation'); ?>

                        <?php echo Form::text('guardian_relation', $student->guardian_relation ?? old('guardian_relation')); ?>

                        <?php echo Form::closeGroup(); ?>


                        <?php echo Form::openGroup('guardian_email', 'student::locale.guardian_email'); ?>

                        <?php echo Form::text('guardian_email', $student->guardian->email ??  old('guardian_email')); ?>

                        <?php echo Form::closeGroup(); ?>


                        <?php echo Form::openGroup('guardian_avatar',  Lang::get('student::locale.guardian_avatar')); ?>

                        <?php echo Form::file('guardian_avatar'); ?>

                        <?php $__env->startPush("scripts-joining_letter"); ?>
                            <?php echo Form::filejs(); ?>

                        <?php $__env->stopPush(); ?>
                        <?php echo Form::closeGroup(); ?>

                    </div>
                    <div class="row">
                        <?php echo Form::openGroup('guardian_phone', 'student::locale.guardian_phone'); ?>

                        <?php echo Form::text('guardian_phone', $student->guardian->mobile_number ??  old('guardian_phone')); ?>

                        <?php echo Form::closeGroup(); ?>


                        <?php echo Form::openGroup('guardian_occupation', 'student::locale.guardian_occupation'); ?>

                        <?php echo Form::text('guardian_occupation', $student->guardian_occupation ?? old('guardian_occupation')); ?>

                        <?php echo Form::closeGroup(); ?>


                        <?php echo Form::openGroup('guardian_address', 'student::locale.guardian_address', ["class" => "col-lg-6"]); ?>

                        <?php echo Form::textarea('guardian_address', $student->guardian->current_address ??  old('guardian_address'),["rows" => 3]); ?>

                        <?php echo Form::closeGroup(); ?>

                    </div>
                </div>
            </div>
            <?php endif; ?>

            <div class="card card-topline-aqua">
                <?php echo $__env->make('layouts.modules.header', [ 'title' => __('student::locale.student_address_details'), 'hide'=> true], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <div class="card-body row">
                    <div class="row">
                        <div class="col-lg-6 p-t-20">
                            <label>
                                <input type="checkbox" id="__fill__current__address">
                                <?php echo e(__('student::locale.guardian_address_is_current_address')); ?>

                            </label>
                        </div>
                        <div class="col-lg-6 p-t-20">
                            <label>
                                <input type="checkbox" id="__fill__permanent__address">
                                <?php echo e(__('student::locale.permanent_address_is_current_address')); ?>

                            </label>
                        </div>

                        <?php echo Form::openGroup('current_address', 'student::locale.current_address', ["class" => "col-lg-6", "lbl_class" => "required"]); ?>

                        <?php echo Form::textarea('current_address',$student->user->current_address ?? old('current_address'),["required" => "true","rows" => 3]); ?>

                        <?php echo Form::closeGroup(); ?>


                        <?php echo Form::openGroup('permanent_address', 'student::locale.permanent_address', ["class" => "col-lg-6", "lbl_class" => "required"]); ?>

                        <?php echo Form::textarea('permanent_address',$student->user->permanent_address ?? old('permanent_address'),["required" => "true","rows" => 3]); ?>

                        <?php echo Form::closeGroup(); ?>

                    </div>
                </div>
            </div>

            <?php if(\App\Facades\General::isSchoolAdmin()): ?>
            <div class="card card-topline-aqua">
                <?php echo $__env->make('layouts.modules.header', [ 'title' => __('student::locale.miscellaneous_details'), 'hide'=> true], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <div class="card-body row">
                    <div class="row">
                        <?php echo Form::openGroup('bank_account_no', 'student::locale.bank_account_no'); ?>

                        <?php echo Form::text('bank_account_no', $student->bank_account_no ?? old('bank_account_no')); ?>

                        <?php echo Form::closeGroup(); ?>


                        <?php echo Form::openGroup('bank_name', 'student::locale.bank_name'); ?>

                        <?php echo Form::text('bank_name', $student->bank_name ?? old('bank_name')); ?>

                        <?php echo Form::closeGroup(); ?>


                        <?php echo Form::openGroup('ifsc_code', 'student::locale.ifsc_code'); ?>

                        <?php echo Form::text('ifsc_code', $student->ifsc_code ?? old('ifsc_code')); ?>

                        <?php echo Form::closeGroup(); ?>


                        <?php echo Form::openGroup('bank_branch', 'student::locale.bank_branch'); ?>

                        <?php echo Form::text('bank_branch', $student->bank_branch ?? old('bank_branch')); ?>

                        <?php echo Form::closeGroup(); ?>

                    </div>
                    <div class="row">
                        <?php echo Form::openGroup('national_ident_no', 'student::locale.national_ident_no'); ?>

                        <?php echo Form::text('national_ident_no', $student->national_ident_no ?? old('national_ident_no')); ?>

                        <?php echo Form::closeGroup(); ?>


                        <?php echo Form::openGroup('local_ident_no', 'student::locale.local_ident_no'); ?>

                        <?php echo Form::text('local_ident_no', $student->local_ident_no ?? old('local_ident_no')); ?>

                        <?php echo Form::closeGroup(); ?>


                        <?php echo Form::openGroup('prev_school', 'student::locale.prev_school'); ?>

                        <?php echo Form::text('prev_school', $student->prev_school ?? old('prev_school')); ?>

                        <?php echo Form::closeGroup(); ?>


                        <?php echo Form::openGroup('note', 'student::locale.note'); ?>

                        <?php echo Form::textarea('note', $student->note ?? old('note'), ["rows" => 3]); ?>

                        <?php echo Form::closeGroup(); ?>

                    </div>
                </div>
            </div>
            <?php endif; ?>
            <div class="row"> <?php echo $__env->make('layouts.forms.actions', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?></div>
            <?php echo Form::close(); ?>

        </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/sms/app/Modules/Student/Resources/Views/createOrUpdate.blade.php ENDPATH**/ ?>