<?php $__env->startSection('pageTitle'); ?> <?php echo $__env->make('layouts.includes.title', ['moduleTitle' => __('Users')], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?> <?php $__env->stopSection(); ?>

<?php $__env->startSection('pageBreadcrumb'); ?> <?php echo $__env->make('layouts.includes.breadcrumb', ['moduleTitle' => __('Student').' '. __('Details') ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?> <?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="row __sms__show__details">
        <div class="col-lg-4">
            <div class="card card-topline-yellow">
                <div class="card-body no-padding height-9">
                    <div class="row">
                        <div class="profile-userpic">
                            <img src="<?php echo e(\Illuminate\Support\Facades\Storage::url( $student->user->avatar ?? 'avatars/dp.png')); ?>" class="img-responsive" alt="">
                        </div>
                    </div>
                    <div class="profile-usertitle">
                        <div class="profile-usertitle-name text-muted "><?php echo e($student->user->name); ?></div>
                    </div>
                    <ul class="list-group list-group-unbordered">
                        <li class="list-group-item">
                            <b class="float-left text-muted mb-0">Admission No</b>
                            <a class="pull-right"><?php echo e($student->admission_no); ?></a>
                        </li>
                        <li class="list-group-item">
                            <b class="float-left text-muted mb-0">Roll Number</b>
                            <a class="pull-right"><?php echo e($student->roll_no); ?></a>
                        </li>
                        <li class="list-group-item">
                            <b class="float-left text-muted mb-0">Class</b>
                            <a class="pull-right"><?php echo e($student->studentClass->title); ?></a>
                        </li>
                        <li class="list-group-item">
                            <b class="float-left text-muted mb-0">Section</b>
                            <a class="pull-right"><?php echo e($student->section->title); ?></a>
                        </li>
                        <li class="list-group-item">
                            <b class="float-left text-muted mb-0">Gender</b>
                            <a class="pull-right"><?php echo e($student->user->gender); ?></a>
                        </li>
                    </ul>
                    <!-- END SIDEBAR USER TITLE -->
                </div>
            </div>
            <div class="card card-topline-yellow">
                <div class="card-head">
                    <header>Address</header>
                </div>
                <div class="card-body no-padding height-9 white-box">
                    <div class="row m-t-10">
                        <div class="col-md-12 mt-4">
                            <label class="text-muted mb-0">Current Address</label><br>
                            <p><?php echo e($student->user->current_address); ?></p>
                        </div>
                        <div class="col-md-12 mt-4">
                            <label class="text-muted mb-0">Permanent Address</label><br>
                            <p><?php echo e($student->user->permanent_address); ?></p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-lg-8">
            <div class="card card-topline-yellow">
                <div class="card-body ">

                    <div class="white-box">
                        <!-- Nav tabs -->
                        <div class="p-rl-20">
                            <ul class="nav customtab nav-tabs" role="tablist">
                                <li class="nav-item">
                                    <a class="nav-link active" data-toggle="tab" href="#__profile">Profile</a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link" data-toggle="tab" href="#__fees">Fees</a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link" data-toggle="tab" href="#__documents">Documents</a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link" data-toggle="tab" href="#__timeline">Timeline</a>
                                </li>
                            </ul>
                        </div><!-- Tab panes -->
                        <div class="tab-content">
                            <div class="tab-pane active fontawesome-demo" id="__profile">
                                <div id="biography">
                                    <div class="row">
                                        <div class="col-md-3 col-6 b-r mt-4">
                                            <label class="text-muted mb-0">Admission Date</label><br>
                                            <p><?php echo e(\Carbon\Carbon::parse($student->admission_date)->format('d/m/Y')); ?></p>
                                        </div>
                                        <div class="col-md-3 col-6 b-r mt-4">
                                            <label class="text-muted mb-0">Date of Birth</label><br>
                                            <p><?php echo e(\Carbon\Carbon::parse($student->user->dob)->format('d/m/Y')); ?></p>
                                        </div>
                                        <div class="col-md-3 col-6 b-r mt-4">
                                            <label class="text-muted mb-0">Category</label><br>
                                            <p><?php echo e($student->castCategory->title); ?></p>
                                        </div>
                                        <div class="col-md-3 col-6 mt-4">
                                            <label class="text-muted mb-0">Mobile Number</label><br>
                                            <p><?php echo e($student->user->mobile_number); ?></p>
                                        </div>
                                        <div class="col-md-3 col-6 mt-4">
                                            <label class="text-muted mb-0">Caste</label><br>
                                            <p><?php echo e($student->cast); ?></p>
                                        </div>
                                        <div class="col-md-3 col-6 mt-4">
                                            <label class="text-muted mb-0">Religion</label><br>
                                            <p><?php echo e($student->religion); ?></p>
                                        </div>
                                        <div class="col-md-6 col-6 mt-4">
                                            <label class="text-muted mb-0">Email</label><br>
                                            <p><?php echo e($student->user->email); ?></p>
                                        </div>
                                        <div class="col-md-12 col-6 mt-4">
                                            <label class="text-muted mb-0">Medical History</label><br>
                                            <p><?php echo e($student->medical_history); ?></p>
                                        </div>
                                    </div>
                                    <hr>
                                </div>
                            </div>
                            <div class="tab-pane" id="__fees">
                                <div class="container-fluid">
                                    <div class="row">
                                        <p> Fee Management</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="card card-topline-yellow">
                <div class="card-body ">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="card" style="box-shadow: none;">
                                <div class="card-head">
                                    <header>Father</header>
                                </div>
                                <div class="card-body no-padding height-9">
                                    <div class="row">
                                        <div class="profile-userpic">
                                            <img src="<?php echo e(\Illuminate\Support\Facades\Storage::url( $student->father_photo ?? 'avatars/dp.png')); ?>" class="img-responsive" alt="">
                                        </div>
                                    </div>
                                    <div class="profile-usertitle">
                                        <div
                                            class="profile-usertitle-name text-muted "><?php echo e($student->father_name); ?></div>
                                    </div>
                                    <ul class="list-group list-group-unbordered">
                                        <li class="list-group-item">
                                            <b class="float-left text-muted mb-0">Phone</b>
                                            <a class="pull-right"><?php echo e($student->father_phone); ?></a>
                                        </li>
                                        <li class="list-group-item">
                                            <b class="float-left text-muted mb-0">Occupation</b>
                                            <a class="pull-right"><?php echo e($student->father_occupation); ?></a>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="card" style="box-shadow: none;">
                                <div class="card-head ">
                                    <header>Mother</header>
                                </div>
                                <div class="card-body no-padding height-9">
                                    <div class="row">
                                        <div class="profile-userpic">
                                            <img src="<?php echo e(\Illuminate\Support\Facades\Storage::url( $student->mother_photo ?? 'avatars/dp.png')); ?>" class="img-responsive" alt="">
                                        </div>
                                    </div>
                                    <div class="profile-usertitle">
                                        <div
                                            class="profile-usertitle-name text-muted "><?php echo e($student->mother_name); ?></div>
                                    </div>
                                    <ul class="list-group list-group-unbordered">
                                        <li class="list-group-item">
                                            <b class="float-left text-muted mb-0">Phone</b> <a
                                                class="pull-right"><?php echo e($student->mother_phone); ?></a>
                                        </li>
                                        <li class="list-group-item">
                                            <b class="float-left text-muted mb-0">Occupation</b> <a
                                                class="pull-right"><?php echo e($student->mother_occupation); ?></a>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="card card-topline-yellow">
                <div class="card-head">
                    <header>Guardian</header>
                </div>
                <div class="card-body ">
                    <div class="row white-box no-padding">
                        <div class="col-md-4">
                            <div class="profile-userpic">
                                <img src="<?php echo e(\Illuminate\Support\Facades\Storage::url( $student->guardian->avatar ?? 'avatars/dp.png')); ?>" class="img-responsive" alt="">
                            </div>
                            <div class="profile-usertitle">
                                <div
                                    class="profile-usertitle-name text-muted "><?php echo e($student->guardian->name); ?></div>
                            </div>
                        </div>
                        <div class="col-md-8">
                            <div class="row">
                                <div class="col-md-6 col-6 mt-4">
                                    <label class="text-muted mb-0">Email</label><br>
                                    <p><?php echo e($student->guardian->email); ?></p>
                                </div>
                                <div class="col-md-6 col-6 mt-4">
                                    <label class="text-muted mb-0">Relation</label><br>
                                    <p><?php echo e($student->guardian_relation); ?></p>
                                </div>
                                <div class="col-md-6 col-6 mt-4">
                                    <label class="text-muted mb-0">Phone</label><br>
                                    <p><?php echo e($student->guardian->mobile_number); ?></p>
                                </div>
                                <div class="col-md-6 col-6 mt-4">
                                    <label class="text-muted mb-0">Occupation</label><br>
                                    <p><?php echo e($student->guardian_occupation); ?></p>
                                </div>
                                <div class="col-md-12 col-12 mt-4">
                                    <label class="text-muted mb-0">Address</label><br>
                                    <p><?php echo e($student->guardian->current_address); ?></p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="card card-topline-yellow">
                <div class="card-head">
                    <header>Miscellaneous Details</header>
                </div>
                <div class="card-body ">
                    <div class="row m-t-10 white-box no-padding">

                        <div class="col-md-4 col-6 mt-4">
                            <label class="text-muted mb-0">Blood Group</label><br>
                            <p><?php echo e($student->user->blood_group); ?></p>
                        </div>
                        <div class="col-md-4 col-6 mt-4">
                            <label class="text-muted mb-0">Student House</label><br>
                            <p><?php echo e($student->studentHouse->title); ?></p>
                        </div>
                        <div class="col-md-4 col-6 mt-4">
                            <label class="text-muted mb-0">Height</label><br>
                            <p><?php echo e($student->height); ?></p>
                        </div>
                        <div class="col-md-4 col-6 mt-4">
                            <label class="text-muted mb-0">Weight</label><br>
                            <p><?php echo e($student->weight); ?></p>
                        </div>
                        <div class="col-md-4 col-6 mt-4">
                            <label class="text-muted mb-0">As on Date</label><br>
                            <p><?php echo e($student->measure_date); ?></p>
                        </div>
                        <div class="col-md-4 col-6 mt-4">
                            <label class="text-muted mb-0">Previous School Details</label><br>
                            <p><?php echo e($student->prev_school); ?></p>
                        </div>
                        <div class="col-md-4 col-6 mt-4">
                            <label class="text-muted mb-0">Bank Account Number</label><br>
                            <p><?php echo e($student->bank_account_no); ?></p>
                        </div>
                        <div class="col-md-4 col-6 mt-4">
                            <label class="text-muted mb-0">Bank Name</label><br>
                            <p><?php echo e($student->bank_name); ?></p>
                        </div>
                        <div class="col-md-4 col-6 mt-4">
                            <label class="text-muted mb-0">IFSC Code</label><br>
                            <p><?php echo e($student->ifsc_code); ?></p>
                        </div>
                        <div class="col-md-6 col-6 mt-4">
                            <label class="text-muted mb-0">National Identification Number</label><br>
                            <p><?php echo e($student->national_ident_no); ?></p>
                        </div>
                        <div class="col-md-6 col-6 mt-4">
                            <label class="text-muted mb-0">Local Identification Number</label><br>
                            <p><?php echo e($student->local_ident_no); ?></p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>

<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/sms/app/Modules/Student/Resources/Views/show.blade.php ENDPATH**/ ?>