<!DOCTYPE html>
<html <?php if(app()->getLocale() != "en") { ?> dir="rtl" <?php } ?> lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<!-- BEGIN HEAD -->

<head>
    <meta charset="utf-8"/>
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta content="width=device-width, initial-scale=1" name="viewport"/>
    <!-- CSRF Token -->
    <meta name="csrf-token" content="{{ csrf_token() }}">

@yield('pageTitle')

<!-- google font -->
    <link href="https://fonts.googleapis.com/css?family=Poppins:300,400,500,600,700" rel="stylesheet" type="text/css"/>
    <!-- icons -->
    <link href="{{ asset('fonts/simple-line-icons/simple-line-icons.min.css') }}" rel="stylesheet" type="text/css"/>
    <link href="{{ asset('fonts/font-awesome/css/font-awesome.min.css') }}" rel="stylesheet" type="text/css"/>
    <link href="{{ asset('fonts/material-design-icons/material-icon.css') }}" rel="stylesheet" type="text/css"/>
    <!--bootstrap -->
    <link href="{{ asset('assets/plugins/bootstrap/css/bootstrap.min.css') }}" rel="stylesheet" type="text/css"/>
    <link href="{{ asset('assets/plugins/summernote/summernote.css') }}" rel="stylesheet">
    <!-- Material Design Lite CSS -->
    <link rel="stylesheet" href="{{ asset('assets/plugins/material/material.min.css') }}">
    @if (app()->getLocale() != "en")
    <link rel="stylesheet" href="{{ asset('assets/plugins/material/material.rtl.min.css') }}">
    @endif
    <link rel="stylesheet" href="{{ asset('assets/css/material_style.css') }}">
    <!-- inbox style -->
    <link href="{{ asset('assets/css/pages/inbox.min.css') }}" rel="stylesheet" type="text/css"/>
    <!-- Theme Styles -->
    @if (app()->getLocale() != "en")
    <link href="{{ asset('assets/css/theme/rtl/theme_style.css') }}" rel="stylesheet" id="rt_style_components"
          type="text/css"/>
    <link href="{{ asset('assets/css/theme/rtl/style.css') }}" rel="stylesheet" type="text/css"/>
    <link href="{{ asset('assets/css/theme/rtl/theme-color.css') }}" rel="stylesheet" type="text/css"/>
    <link href="{{ asset('assets/css/theme/rtl/rtl.css') }}" rel="stylesheet" type="text/css"/>
        <link href="{{ asset('assets/css/custom-rtl.css') }}" rel="stylesheet" type="text/css"/>
    @else
         <link href="{{ asset('assets/css/theme/light/theme_style.css') }}" rel="stylesheet" type="text/css"/>
         <link href="{{ asset('assets/css/theme/light/style.css') }}" rel="stylesheet" type="text/css"/>
         <link href="{{ asset('assets/css/theme/light/theme-color.css') }}" rel="stylesheet" type="text/css"/>
        <link href="{{ asset('assets/css/custom-ltr.css') }}" rel="stylesheet" type="text/css"/>
    @endif
    <link href="{{ asset('assets/css/plugins.min.css') }}" rel="stylesheet" type="text/css"/>
    <link href="{{ asset('assets/css/responsive.css') }}" rel="stylesheet" type="text/css"/>
    <link href="{{ asset('assets/plugins/jquery-toast/dist/jquery.toast.min.css') }}" rel="stylesheet" type="text/css"/>

    <!-- Date Time item CSS -->
    <link rel="stylesheet" href="{{ asset('assets/plugins/flatpicker/css/flatpickr.min.css') }}"/>

    <!-- Datatable -->
    <link href="{{ asset('assets/plugins/datatables/plugins/bootstrap/dataTables.bootstrap4.min.css') }}" rel="stylesheet" type="text/css"/>

    <!-- favicon -->
    <link rel="shortcut icon" href="{{ asset('assets/img/favicon.ico') }}"/>
</head>
<!-- END HEAD -->
<?php
$body_class = "page-header-fixed sidemenu-closed-hidelogo page-content-white page-md header-white dark-sidebar-color logo-blue header-blue";
if(app()->getLocale() != "en") {
    $body_class .= " sidemenu-container-reversed";
}
?>
<body
    class="<?= $body_class ?>">
<div class="page-wrapper">

@include('layouts.includes.header')

<!-- start page container -->
    <div class="page-container" style="overflow: hidden;">

    @include('layouts.includes.right')
    <!-- start page content -->
        <div class="page-content-wrapper">
            <div class="page-content">
            @yield('pageBreadcrumb')
            @include('layouts.includes.message')
            <!-- begin:: Content -->
            @yield('content')
            <!-- end:: Content -->
            </div>
        </div>
        <!-- end page content -->
    </div>
    <!-- end page container -->
    @include('layouts.includes.footer')

</div>
<!-- start js include path -->
<script src="{{ asset('assets/plugins/jquery/jquery.min.js') }}"></script>
<script src="{{ asset('assets/plugins/popper/popper.js') }}"></script>
<script src="{{ asset('assets/plugins/jquery-blockui/jquery.blockui.min.js') }}"></script>
<script src="{{ asset('assets/plugins/jquery-slimscroll/jquery.slimscroll.js') }}"></script>
<!-- bootstrap -->
<script src="{{ asset('assets/plugins/bootstrap/js/bootstrap.min.js') }}"></script>
<script src="{{ asset('assets/plugins/bootstrap-switch/js/bootstrap-switch.min.js') }}"></script>
<script src="{{ asset('assets/plugins/sparkline/jquery.sparkline.js') }}"></script>
<script src="{{ asset('assets/js/pages/sparkline/sparkline-data.js') }}"></script>
<!-- Common js-->
<script src="{{ asset('assets/js/app.js') }}"></script>
<script src="{{ asset('assets/js/layout.js') }}"></script>
<script src="{{ asset('assets/js/theme-color.js') }}"></script>
<!-- material -->
<script src="{{ asset('assets/plugins/material/material.min.js') }}"></script>
<!--apex chart-->
<script src="{{ asset('assets/plugins/apexcharts/apexcharts.min.js') }}"></script>
<script src="{{ asset('assets/js/pages/chart/chartjs/home-data.js') }}"></script>
<!-- summernote -->
<script src="{{ asset('assets/plugins/summernote/summernote.js') }}"></script>
<script src="{{ asset('assets/js/pages/summernote/summernote-data.js') }}"></script>

<script src="{{ asset('assets/plugins/select2/js/select2.js') }}"></script>
<script src="{{ asset('assets/js/pages/select2/select2-init.js') }}"></script>
<script src="{{ asset('assets/js/custom.js') }}"></script>
<!-- chart js -->
<script src="{{ asset('assets/plugins/chart-js/Chart.bundle.js') }}"></script>
<script src="{{ asset('assets/plugins/chart-js/utils.js') }}"></script>
<script src="{{ asset('assets/js/pages/chart/chartjs/home-data2.js') }}"></script>
<script src="{{ asset('assets/plugins/sparkline/jquery.sparkline.js') }}"></script>
<script src="{{ asset('assets/plugins/sparkline/sparkline-data.js') }}"></script>
<!-- end js include path -->

<script src="{{ asset('assets/plugins/flatpicker/js/flatpicker.min.js') }}"></script>

<!-- data tables -->
<script src="{{ asset('assets/plugins/datatables/jquery.dataTables.min.js') }}"></script>
<script src="{{ asset('assets/plugins/datatables/plugins/bootstrap/dataTables.bootstrap4.min.js') }}"></script>

<script src="{{ asset('assets/plugins/jquery-toast/dist/jquery.toast.min.js') }}"></script>
<script src="{{ asset('assets/plugins/jquery-toast/dist/toast.js') }}"></script>
<!--end::Page Scripts -->
@yield('scripts')
@stack('scripts-footer')

<script>
    let commonMessage = {
        '__destroy_confirmation_message': "Are you sure you want to delete this item?",
        '__no_revert_message': "You won't be able to revert this!",
        '__yes_delete': "Yes, delete it!",
        '__deleted': "Deleted!",
        '__deleted_message': "Your item has been deleted.",
        '__success': "success",
        '__slot_booked_teacher': "Time slot already allotted!",
        '__oops': "Oops...",
    }
</script>
</body>

</html>
