@extends('layouts.login')

@section('content')
    <div class="wrap-login100">
        <form class="login100-form validate-form" method="POST" action="{{ route('admin_auth.login') }}">
            @csrf
            <span class="login100-form-logo">
                <img alt="" src="{{ asset('assets/img/logo-2.png') }}">
            </span>
            <span class="login100-form-title p-b-34 p-t-27">{{__("Log in") }}</span>

            <div class="wrap-input100 validate-input" data-validate="Enter username">
                <input id="email" type="email" class="input100 @error('email') is-invalid @enderror" name="email"
                       value="{{ old('email') }}" placeholder="{{__("Username") }}" required autocomplete="email" autofocus>
                @error('email')
                <span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>
                @enderror
                <span class="focus-input100" data-placeholder="&#xf207;"></span>
            </div>

            <div class="wrap-input100 validate-input" data-validate="Enter password">
                <input id="password" type="password" class="input100 @error('password') is-invalid @enderror"
                       name="password" required autocomplete="current-password" placeholder="{{__("Password") }}">
                @error('password')
                <span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>
                @enderror
                <span class="focus-input100" data-placeholder="&#xf191;"></span>
            </div>

            <div class="checkbox contact100-form-checkbox rtl">
                <input class="input-checkbox100" type="checkbox" name="remember"
                       id="ckb1" {{ old('remember') ? 'checked' : '' }}>
                <label class="label-checkbox100" for="ckb1">{{ __('Remember Me') }}</label>
            </div>

            <div class="container-login100-form-btn">
                <button type="submit" class="login100-form-btn">
                    {{ __('Login') }}
                </button>
            </div>

            @if (Route::has('password.request'))
                <div class="text-center p-t-30">
                    <a class="txt1" href="{{ route('password.request') }}">
                        {{ __('Forgot Your Password?') }}
                    </a>
                </div>
            @endif
        </form>
    </div>
@endsection
