<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateStaffTable extends Migration
{

    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('staffs', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->unsignedBigInteger('account_id');
            $table->bigInteger('user_id')->unique();
            $table->string('staff_id');
            $table->string('role');
            $table->integer('designation_id');
            $table->integer('department_id');
            $table->string('father_name')->nullable();
            $table->string('mother_name')->nullable();
            $table->date('joining_date')->nullable();
            $table->enum('marital_status', ['Single', 'Married', 'Widowed', 'Separated', 'Not Specified'])->nullable();
            $table->longText('qualification')->nullable();
            $table->longText('work_exp')->nullable();
            $table->longText('note')->nullable();
            $table->string('epf_no')->nullable();
            $table->string('basic_salary')->nullable();
            $table->enum('contract_type', ['Permanent', 'Probation'])->nullable();
            $table->string('work_shift')->nullable();
            $table->string('location')->nullable();
            $table->integer('alloted_leave_1')->nullable();
            $table->integer('alloted_leave_2')->nullable();
            $table->integer('alloted_leave_3')->nullable();
            $table->string('account_title')->nullable();
            $table->string('bank_account_no')->nullable();
            $table->string('bank_name')->nullable();
            $table->string('ifsc_code')->nullable();
            $table->string('bank_branch')->nullable();
            $table->string('fb_url')->nullable();
            $table->string('twitter_url')->nullable();
            $table->string('linkedin_url')->nullable();
            $table->string('instagram_url')->nullable();
            $table->string('resume')->nullable();
            $table->string('document')->nullable();
            $table->string('joining_letter')->nullable();
            $table->tinyInteger('view_contact')->default(0);
            $table->tinyInteger('student_action')->default(0);
            $table->timestamps();
            $table->bigInteger('created_by');
            $table->bigInteger('updated_by')->nullable();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('staffs');
    }

}
