<?php

namespace App\Traits;

use App\TenantScope;

trait TenantableTrait
{

    public static function bootTenantableTrait()
    {
        // Add Global scope that will handle all operations except create()
        static::addGlobalScope(new TenantScope);
    }

    /**
     * @return mixed
     */
    public static function allTenants()
    {
        return with(new static())->newQueryWithoutScope(new TenantScope());
    }

    /**
     * @param $tenantColumn
     * @param $tenantId
     * @return string
     */
    public function getTenantWhereClause($tenantColumn, $tenantId)
    {
        return "{$this->getTable()}.{$tenantColumn} = '{$tenantId}'";
    }

}
