@extends('layouts.master')

@section('pageBreadcrumb') @include('layouts.includes.breadcrumb', ['moduleTitle' => __('Dashboard')]) @stop

@section('content')
<!-- end widget -->
<div class="row">
    <div class="col-lg-10 col-md-12 col-sm-12 col-12">
        <div class="card-box">
        <div class="card-head">
                <header>{{ __('locale.timetable')}}</header>
        </div>
        <div class="card-body ">
            <div id="timetableCalendar"></div>
        </div>
        </div>
    </div>
    <div class="state-overview col-lg-2 col-md-12 col-sm-12 col-12">
        <div class="overview-panel purple">
            <div class="symbol">
                <i class="fa fa-book usr-clr"></i>
            </div>
            <div class="value white">
                <p class="sbold addr-font-h1" data-counter="counterup" data-value="{{ $total_classes }}">{{ $total_classes }}</p>
                <p>{{ __('locale.total')}} {{ __('locale.lectures')}}</p>
            </div>
        </div>
        <div class="overview-panel bg-success">
            <div class="symbol">
                <i class="fa fa-desktop usr-clr"></i>
            </div>
            <div class="value white">
                <p class="sbold addr-font-h1" data-counter="counterup" data-value="{{ $total_online }}">{{ $total_online }}</p>
                <p>{{ __('locale.online')}} {{ __('locale.lectures')}}</p>
            </div>
        </div>
        <div class="overview-panel blue-bgcolor">
            <div class="symbol">
                <i class="fa fa-pencil usr-clr"></i>
            </div>
            <div class="value white">
                <p class="sbold addr-font-h1" data-counter="counterup" data-value="{{ $total_classes - $total_online }}">{{ $total_classes - $total_online }}</p>
                <p>{{ __('locale.offline')}} {{ __('locale.lectures')}}</p>
            </div>
        </div>
    </div>
</div>
<div class="row">
    <div class="col-lg-10 col-md-12 col-sm-12 col-12">
        <div class="card-box">
        <div class="card-head">
            <header>{{ __('locale.schedule')}}</header>
        </div>
        <div class="card-body ">
            <div class="filter row">
                <div class="col-lg-4">
                <select style="margin-left: 20px;" class="form-control col-lg-12" defaulttxt="Select" name="days" id="option_days">
                        <option value="">Filter Day</option>
                        @foreach($weekDays as $weekDay)
                            <option value="{{ $weekDay }}">{{ $weekDay }}</option>
                        @endforeach
                </select>
                </div>
                <div class="col-lg-4">
                    <input required="true" autocomplete="off" class="form-control setDatePicker flatpickr-input active" name="__calender_helper" type="text" id="__calender_helper">
                </div>
            </div>
            <br/>
        <div class="table-responsive">
            <table class="table">
                <tbody>
                    <tr>
                        <th>{{ __('locale.class')}}</th>
                        <th>{{ __('locale.subject')}}</th>
                        <th>{{ __('locale.week_day')}}</th>
                        <th>{{ __('locale.start_time')}}</th>
                        <th>{{ __('locale.end_time')}}</th>
                        <th>{{ __('locale.total_time')}}</th>
                        <th>{{ __('locale.class_type')}}</th>
                    </tr>
                    @foreach($classes as $key => $data)
                    <tr class="common-type {{ $data->week_day }}">
                        <td>{{ $data->studentClass->title }}</td>
                        <td>{{ $data->subject->title }}</td>
                        <td>{{ $data->week_day }}</td>
                        <td>{{ $data->start_time }}</td>
                        <td>{{ $data->end_time }}</td>
                        <td>{{ (strtotime($data->end_time) - strtotime($data->start_time)) / 60  }} Mins</td>
                        <td><span class="label {{ ($data->is_online) ? "label-success" : "label-danger" }}">{{ ($data->is_online) ? "Online" : "Offline" }}</span></td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
        </div>
        </div>
    </div>
    <div class="col-lg-2 col-md-12 col-sm-12 col-12">
        <div class="card-box">
            <div class="card-head">
                <header>{{ __('locale.co_worker_list')}}</header>
            </div>
            <div class="card-body ">
                <div class="row">
                    <ul class="docListWindow small-slimscroll-style">
                        @foreach($staffs as $key => $staff)
                        <li>
                            <div class="prog-avatar">
                                <img  width="40"
                                     height="40" src="{{ \Illuminate\Support\Facades\Storage::url( $staff->user->avatar ?? 'avatars/dp.png') }}" class="img-responsive" alt="">
                            </div>
                            <div class="details">
                                <div class="title">{{ $staff->user->name }}</div>
                                <div>
                                    <span class="clsAvailable">{{  \App\Facades\General::getRoleNameById($staff->user->role_id)  }}</span>
                                </div>
                            </div>
                        </li>
                        @endforeach
                    </ul>
                    <div class="full-width text-center p-t-10">
                        <a href="/teacher" class="btn purple btn-outline btn-circle margin-0">View All</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@stop
@section('scripts')
 <style>
        .fc-event, .fc-event-dot {
            background-color: #1880c9 !important;
        }
        .fc-event .fc-bg {
            opacity: 0 !important;
        }
    </style>
    <link href="{{ asset('assets/plugins/fullcalendar/fullcalendar.css') }}" rel="stylesheet" type="text/css"/>
    <script src="{{ asset('assets/plugins/moment/moment.min.js') }}"></script>
    <script src="{{ asset('assets/plugins/fullcalendar/fullcalendar.min.js') }}"></script>
    <script src="{{ asset('assets/js/pages/calendar/calendar.min.js') }}"></script>

    <link href="{{ asset('assets/plugins/sweet-alert/sweetalert2.min.css') }}" rel="stylesheet">
    <script src="{{ asset('assets/plugins/sweet-alert/sweetalert2.all.min.js') }}"></script>
    <script>

    let teacherAvailability;
    $(function () {
        $('#timetableCalendar').fullCalendar({
            header: {
                left: '',
                center: '',
                right: ''
            },
            plugins: ['momentPlugin', 'formatDate'],
            // height: 680, // Fix height
            columnFormat: 'dddd', // Display just full length of weekday, without dates
            defaultView: 'agendaWeek', // display week view
            // hiddenDays: [0,6], // hide Saturday and Sunday
            weekNumbers: false, // don't show week numbers
            minTime: '06:00:00', // display from 16 to
            maxTime: '20:00:00', // 23
            slotDuration: '00:15:00', // 15 minutes for each row
            allDaySlot: false, // don't show "all day" at the top
            aspectRatio: 1.5,
            editable: false,
            selectable: false,
            selectHelper: false,
            droppable: false, // this allows things to be dropped onto the calendar
            /*select: function (start, end, allDay) {
                // Code for creating new events.
            },*/
            eventResize: function (event, delta, revertFunc, jsEvent, ui, view) {
                // Code when you resize an event (for example make it two hours longer
                eventActions(event);
            },
            eventDrop: function (event, jsEvent, ui, view) {
                // Code when you drop an element somewhere else
                eventActions(event);
            },
            eventRender: function (event, element, view) {
                element.innerHTML = event.title;
            },
            eventClick: function(event, jsEvent, view) {
                getEventDetails(event.id);
            },
            timeZone: 'UTC',
            events: {
                url: '{{ route('teacher-timetable.events') }}',
                type: 'GET',
                error: function () {
                    alert('there was an error while fetching events!');
                }
            },
            backgroundColor: '#1880c9'
        });

    });



</script>
<script>
$(document).on('change', '#__calender_helper', function () {
    let days = ['Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday'];
    let calenderHelper = $(this).val();
    let dateObject = new Date(calenderHelper);
    let dayName = days[dateObject.getDay()];
    $("#option_days").val(dayName);
     showDays();
});

$(document).on('change', '#option_days', function () {
   showDays();
});
function showDays(){
    let optionDays = $.trim($("#option_days").val());
    $(".common-type").hide();
    var dviClass = "";
    if(optionDays != null && optionDays!= ''){
        dviClass = "."+optionDays;
    }
    if(dviClass){
        console.log(dviClass);
        $(dviClass).show();
    }
    else{
        $(".common-type").show();
    }
}
</script>
@stop

