@extends('layouts.master')

@section('pageTitle') @include('layouts.includes.title', ['moduleTitle' => __('Import'). __('Students')]) @stop

@section('pageBreadcrumb') @include('layouts.includes.breadcrumb', ['moduleTitle' => __('Import')." ".__('Students')]) @stop

@section('content')
<div class="row">
    <div class="col-sm-12">
        <div class="card-box">
            @include('layouts.modules.header', [ 'title' => __('Students Import')])
            <div class="p-t-20 p-r-20 pull-right">
                <a target="_blank" href="{{ asset('assets/sample_csv/student_sample.csv') }}">Click here</a> to download the sample file.
            </div>
            <div class="card-body row">
                <div class="col-lg-12 p-t-20 p-l-20">
                    <div class="alert alert-success upl-success" style="display:none;" role="alert">
                    </div>
                    <div class="alert alert-danger upl-fail" style="display:none;" role="alert">
                    </div>
                </div>
                <div class="col-lg-12 p-t-20">
                    <label class="control-label col-md-3">Upload Import File
                    </label>
                    <div class="col-md-12">
                        <div id="id_dropzone" class="dropzone dz-clickable"><div class="dz-default dz-message"><span>Drop files here to upload</span></div></div>
                    </div>
                </div>
            </div>
        </div>
        <div class="card-box">
            <div class="card-head">
                <header>{{__('locale.preview')}}</header>
            </div>
            <div class="card-body row">
                <div class="col-lg-12 p-t-20 p-l-20">
                    <button class="__save_preview_data btn btn-circle btn-primary m-b-10 hide"> {{ __('locale.import') }}</button>
                </div>
                <div class="col-lg-12 p-t-20 p-l-20" id="finalized_data_preview">

                </div>
            </div>
        </div>
    </div>
</div>
@stop
@section('scripts')
<link href="{{ asset('assets/plugins/dropzone/dropzone.css') }}" rel="stylesheet"
      type="text/css" />
<script src="../assets/plugins/dropzone/dropzone.js"></script>
<script>
Dropzone.autoDiscover = false;
$(document).ready(function () {
    $("#id_dropzone").dropzone({
        maxFiles: 1,
        maxFilesize: 10, // MB
        acceptedFiles: ".csv, text/csv, application/vnd.ms-excel,application/vnd.openxmlformats-officedocument.spreadsheetml.sheet, application/csv, text/x-csv, application/x-csv, text/comma-separated-values, text/x-comma-separated-values",
        url: "/import-students",
        sending: function (file, xhr, formData) {
            formData.append("_token", "{{ csrf_token() }}");
        },
        success: function (file, response) {
            var data = $.parseJSON(response);
            if (data.success == true) {
                console.log("if");
                /*$(".upl-success").html(data.message);
                $(".upl-fail").fadeOut();
                $(".upl-success").fadeIn(100);*/

                $("#finalized_data_preview").html(data.data);
                $(".__save_preview_data").removeClass('hide');

            } else {
                console.log("else");
                $(".upl-success").fadeOut();
                $(".upl-fail").html(data.message);
                $(".upl-fail").fadeIn(100);
            }
            this.removeAllFiles();
        }
    });
})

$(document).on('click', '.__save_preview_data', function () {
    $.ajax({
        url: '{{ route("import-students.save") }}',
        headers: {'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')},
        type: 'POST',
        success: function (data) {
            console.log(data['message'], data.message);
            $(".upl-success").html(data.message);
            $(".upl-fail").fadeOut();
            $(".upl-success").fadeIn(100);

            $("#finalized_data_preview").html('');
            $(".__save_preview_data").addClass('hide');
        },
        error: function () {
            alert("Something Went Wrong!");
        }
    });
});

</script>
@stop

