@extends('layouts.master')

@section('pageBreadcrumb') @include('layouts.includes.breadcrumb', ['moduleTitle' => __('Biology')]) @stop

@section('content')
<!-- end widget -->
<style>
.container {
  position: relative;
  width: 100%;
  overflow: hidden;
  padding-top: 56.25%; /* 16:9 Aspect Ratio */
}

.responsive-iframe {
  position: absolute;
  top: 0;
  left: 0;
  bottom: 0;
  right: 0;
  width: 100%;
  height: 100%;
  border: none;
}
</style>
<div class="row">
  <div class="col-lg-12 col-md-12 col-sm-12 col-12">
    <div class="card-box">
      <div class="card-head">
        <header>{{ __('Fish')}}</header>
      </div>
      <div class="card-body ">
        <div class="container">
          <iframe class="responsive-iframe" src="https://webgltests.s3.ap-south-1.amazonaws.com/Fish/index.html" scrolling="auto"></iframe>
        </div>
      </div>
    </div>
  </div>
  <div class="col-lg-12 col-md-12 col-sm-12 col-12">
    <div class="card-box">
      <div class="card-head">
        <header>{{ __('Stem in glass with coloured water')}}</header>
      </div>
      <div class="card-body ">
        <div class="container">
          <iframe  class="responsive-iframe" src="https://webgltests.s3.ap-south-1.amazonaws.com/Stem+in+glass+with+coloured+water/index.html" ></iframe>
        </div>
      </div>
    </div>
  </div>
</div>
@stop
@section('scripts')
<style>
        .fc-event, .fc-event-dot {
            background-color: #1880c9 !important;
        }
        .fc-event .fc-bg {
            opacity: 0 !important;
        }
    </style>
<link href="{{ asset('assets/plugins/fullcalendar/fullcalendar.css') }}" rel="stylesheet" type="text/css"/>
<script src="{{ asset('assets/plugins/moment/moment.min.js') }}"></script>
<script src="{{ asset('assets/plugins/fullcalendar/fullcalendar.min.js') }}"></script>
<script src="{{ asset('assets/js/pages/calendar/calendar.min.js') }}"></script>
<link href="{{ asset('assets/plugins/sweet-alert/sweetalert2.min.css') }}" rel="stylesheet">
<script src="{{ asset('assets/plugins/sweet-alert/sweetalert2.all.min.js') }}"></script>
<script>

    let teacherAvailability;
    $(function () {
        $('#timetableCalendar').fullCalendar({
            header: {
                left: '',
                center: '',
                right: ''
            },
            plugins: ['momentPlugin', 'formatDate'],
            // height: 680, // Fix height
            columnFormat: 'dddd', // Display just full length of weekday, without dates
            defaultView: 'agendaWeek', // display week view
            // hiddenDays: [0,6], // hide Saturday and Sunday
            weekNumbers: false, // don't show week numbers
            minTime: '06:00:00', // display from 16 to
            maxTime: '20:00:00', // 23
            slotDuration: '00:15:00', // 15 minutes for each row
            allDaySlot: false, // don't show "all day" at the top
            aspectRatio: 1.5,
            editable: false,
            selectable: false,
            selectHelper: false,
            droppable: false, // this allows things to be dropped onto the calendar
            /*select: function (start, end, allDay) {
                // Code for creating new events.
            },*/
            eventResize: function (event, delta, revertFunc, jsEvent, ui, view) {
                // Code when you resize an event (for example make it two hours longer
                eventActions(event);
            },
            eventDrop: function (event, jsEvent, ui, view) {
                // Code when you drop an element somewhere else
                eventActions(event);
            },
            eventRender: function (event, element, view) {
                element.innerHTML = event.title;
            },
            eventClick: function(event, jsEvent, view) {
                getEventDetails(event.id);
            },
            timeZone: 'UTC',
            events: {
                url: '{{ route('teacher-timetable.events') }}',
                type: 'GET',
                error: function () {
                    alert('there was an error while fetching events!');
                }
            },
            backgroundColor: '#1880c9'
        });

    });



</script>
<script>
$(document).on('change', '#__calender_helper', function () {
    let days = ['Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday'];
    let calenderHelper = $(this).val();
    let dateObject = new Date(calenderHelper);
    let dayName = days[dateObject.getDay()];
    $("#option_days").val(dayName);
     showDays();
});

$(document).on('change', '#option_days', function () {
   showDays();
});
function showDays(){
    let optionDays = $.trim($("#option_days").val());
    $(".common-type").hide();
    var dviClass = "";
    if(optionDays != null && optionDays!= ''){
        dviClass = "."+optionDays;
    }
    if(dviClass){
        console.log(dviClass);
        $(dviClass).show();
    }
    else{
        $(".common-type").show();
    }
}
</script>
@stop 