@extends('layouts.master')

@section('pageBreadcrumb') @include('layouts.includes.breadcrumb', ['moduleTitle' => __('View').' '.__('School') ]) @stop

@section('content')
    <div class="row __sms__show__details">
        <div class="col-lg-12">
            <div class="card card-topline-yellow">
                @include('layouts.modules.header', [ 'title' => __('View School'), 'actionEdit' => route($moduleName.'.edit', $saasSchool->id)])
                <div class="card-body no-padding height-9">
                    <div class="row">
                        <div class="col-lg-3 p-t-20">
                            <label class=" text-muted mb-0">{{ __('locale.name') }}</label>
                            <span class="form-text ">{{ $saasSchool->name }}</span>
                        </div>

                        <div class="col-lg-3 p-t-20">
                            <label class=" text-muted mb-0">{{ __('saasuser::locale.domain_alias') }}</label>
                            <span class="form-text ">{{ $saasSchool->domain_alias }}</span>
                        </div>
                        <div class="col-lg-3 p-t-20">
                            <label class=" text-muted mb-0">{{ __('saasuser::locale.account_code') }}</label>
                            <span class="form-text ">{{ $saasSchool->account_code }}</span>
                        </div>
                        <div class="col-lg-3 p-t-20">
                            <label class=" text-muted mb-0">{{ __('saasuser::locale.school_start_year') }}</label>
                            <span class="form-text ">{{ $saasSchool->school_start_year }}</span>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-lg-3 p-t-20">
                            <label class=" text-muted mb-0">{{ __('saasuser::locale.reg_no') }}</label>
                            <span class="form-text ">{{ $saasSchool->reg_no }}</span>
                        </div>

                        <div class="col-lg-3 p-t-20">
                            <label class=" text-muted mb-0">{{ __('saasuser::locale.reg_date') }}</label>
                            <span class="form-text ">{{ $saasSchool->reg_date }}</span>
                        </div>
                        <div class="col-lg-3 p-t-20">
                            <label class=" text-muted mb-0">{{ __('saasuser::locale.school_type') }}</label>
                            <span class="form-text ">{{ $saasSchool->school_type }}</span>
                        </div>
                        <div class="col-lg-3 p-t-20">
                            <label class=" text-muted mb-0">{{ __('saasuser::locale.school_category') }}</label>
                            <span class="form-text ">{{ $saasSchool->school_category }}</span>
                        </div>
                    </div>
                    
                     <div class="row">
                        <div class="col-lg-3 p-t-20">
                            <label class=" text-muted mb-0">{{ __('saasuser::locale.pincode') }}</label>
                            <span class="form-text ">{{ $saasSchool->pincode }}</span>
                        </div>

                        <div class="col-lg-3 p-t-20">
                            <label class=" text-muted mb-0">{{ __('locale.email') }}</label>
                            <span class="form-text ">{{ $saasSchool->adminUser->email }}</span>
                        </div>
                        <div class="col-lg-3 p-t-20">
                            <label class=" text-muted mb-0">{{ __('saasuser::locale.contact_number') }}</label>
                            <span class="form-text ">{{ $saasSchool->contact_number }}</span>
                        </div>
                        <div class="col-lg-3 p-t-20">
                            <label class=" text-muted mb-0">{{ __('locale.website') }}</label>
                            <span class="form-text ">{{ $saasSchool->website }}</span>
                        </div>
                    </div>
                     <div class="row">
                        <div class="col-lg-3 p-t-20">
                            <label class=" text-muted mb-0">{{ __('locale.logo') }}</label>
                            <span class="form-text "><img src='{{ url("storage/".$saasSchool->logo) }}' /></span>
                        </div>

                        <div class="col-lg-3 p-t-20">
                            <label class=" text-muted mb-0">{{ __('locale.address') }}</label>
                            <span class="form-text ">{{ $saasSchool->address }}</span>
                        </div>
                        <div class="col-lg-3 p-t-20">
                            <label class=" text-muted mb-0">{{ __('locale.about_us') }}</label>
                            <span class="form-text ">{{ $saasSchool->about_us }}</span>
                        </div>
                        <div class="col-lg-3 p-t-20">
                            <label class=" text-muted mb-0">{{ __('locale.is_active') }}</label>
                            <span class="form-text ">{{ ($saasSchool->is_activated) ? "Yes" : "No" }}</span>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>
@stop
@section('scripts')

@stop

