@extends('layouts.master')

@section('pageBreadcrumb') @include('layouts.includes.breadcrumb', ['moduleTitle' => (!isset($saasUser) ? __('locale.add') : __('locale.edit')).' '.__('Users') ]) @stop

@section('content')
<div class="row">
    <div class="col-sm-12">
        <div class="card-box">
            @include('layouts.modules.header', [ 'title' => (!isset($saasUser) ? __('locale.add') : __('locale.edit')).' '. __('locale.user')])
            <div class="card-body row">
                @if(isset($saasUser))
                {!! Form::model($saasUser, ['route' => [$moduleName.'.update', $saasUser->id] ,'files' => true, "type" => "card" ]) !!}
                @else
                {!! Form::open([ 'route' => $moduleName.'.store' ,'files' => true, "type" => "card"]) !!}
                @endif

                <div class="row">
                    {!!  Form::openGroup('name', __('locale.name'),array("lbl_class" => "required", "class" => "col-lg-6")) !!}
                    {!!  Form::text('name', $saasUser->name ?? old('name') ) !!}
                    {!!  Form::closeGroup() !!}

                    {!!  Form::openGroup('email', __('locale.email'),array("lbl_class" => "required", "class" => "col-lg-6")) !!}
                    {!!  Form::text('email', $saasUser->email ?? old('email') ) !!}
                    {!!  Form::closeGroup() !!}


                    {!!  Form::openGroup('password', __('locale.password'),array("lbl_class" => "required", "class" => "col-lg-6")) !!}
                    {!!  Form::password('password') !!}
                    {!!  Form::closeGroup() !!}

                    {!!  Form::openGroup('password_confirmation', __('locale.password_confirmation'),array("lbl_class" => "required", "class" => "col-lg-6")) !!}
                    {!!  Form::password('password_confirmation') !!}
                    {!!  Form::closeGroup() !!}

                    {!!  Form::openGroup('avatar',  Lang::get('student::locale.avatar')) !!}
                    {!!  Form::file('avatar') !!}
                    @push("scripts-footer")
                    @php
                    $options = [];
                    if (isset($saasUser->avatar)) {
                    $options["initialPreview"][] = $saasUser->avatar;
                    } @endphp
                    {!!  Form::filejs() !!}
                    @endpush
                    {!!  Form::closeGroup() !!}
                </div>

            </div>
        </div>
    </div>
</div>
<div class="row"> @include('layouts.forms.actions')</div>
{!! Form::close() !!}
@stop
@section('scripts')
@stop

