<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\SoftDeletes;
use Yajra\DataTables\Facades\DataTables;

class UserSetting extends Model
{
    use SoftDeletes;

    protected $fillable = ['user_id', 'option_name', 'option_value', 'created_by'];

    /**
     * @return BelongsTo
     */
    public function user()
    {
        return $this->belongsTo('App\User', 'user_id')->withDefault();
    }

    /**
     * Return option value by option name
     *
     * @param $optionName
     * @return mixed
     */
    public static function getOptionValueByName($optionName)
    {
        return self::where('option_name', $optionName)->get()->first();
    }

    /**
     * Update user setting by option name
     *
     * @param $options
     * @return mixed
     */
    public static function updateSettingByName($options)
    {
        return self::updateOrCreate(['option_name' => $options['option_name']], $options);
    }


}
