<?php

namespace App\Models;

use App\Facades\General;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Yajra\DataTables\Facades\DataTables;

class User extends Tenant
{

    use SoftDeletes;

    const ROLE_SUPER_ADMIN = 1;

    /**
     * Fillable fields
     *
     * @var array
     */
    protected $fillable = [
        'account_id',
        'name',
        'email',
        'gender',
        'dob',
        'mobile_number',
        'blood_group',
        'join_date',
        'permanent_address',
        'current_address',
        'email_verified_at',
        'password',
        'role_id',
        'avatar',
        'created_by',
        'updated_by',
    ];

    /**
     * @return BelongsTo
     */
    public function account()
    {
        return $this->belongsTo('App\Models\Account', 'account_id');
    }

    /**
     * @return BelongsTo
     */
    public function role()
    {
        return $this->belongsTo('App\Models\Role', 'role_id')->withDefault();
    }

    /**
     * @return mixed
     */
    public function userSetting()
    {
        return $this->hasMany('App\Models\UserSetting', 'user_id')->withDefault();
    }

    /**
     * @return mixed
     */
    public function student()
    {
        return $this->hasOne('App\Modules\Student\Model\Student', 'user_id')->withDefault();
    }

    /**
     * Return user details by user id
     *
     * @param $userId
     * @return mixed
     */
    public static function getUserDetails($userId)
    {
        if (isset($userId) && !empty($userId) && !is_null($userId)) {
            return self::where('id', $userId)->get()->first();
        } else {
            return null;
        }
    }


    /**
     * Return section lists
     *
     * @return void
     */
    public static function getUserEmails()
    {
        try {
            $sectionResults = (new User())->find();
            $sectionValues  = [];

            foreach ($sectionResults as $sectionResult) {
                $sectionValues[$sectionResult->email] = $sectionResult->email;
            }

            return $sectionValues;

        } catch (Exception $e) {
            return '';
        }
    }

}
