<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Yajra\DataTables\Facades\DataTables;

class Role extends Model
{
    use SoftDeletes;
    const ROLE_ADMIN = 1;
    const ROLE_TEACHER = 2;
    const ROLE_ACCOUNTANT = 3;
    const ROLE_LIBRARIAN = 4;
    const ROLE_STUDENT = 5;
    protected $fillable = ['name', 'description', 'created_by'];

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function createdBy(){
        return $this->belongsTo('App\User', 'created_by')->withDefault();
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsToMany
     */
    public function permissions(){
        return $this->belongsToMany( Permission::class,'role_permission','role_id', 'permission_id');
    }

    public static function getRoles(){

        $roleModel = self::query();

        return DataTables::eloquent($roleModel)
            ->addColumn('action', function ($user) {
                $action = '';
                $action .= View('layouts.actions.view')->with('model', $user)->with('route', 'role.show');
                $action .= View('layouts.actions.edit')->with('model', $user)->with('route', 'role.edit');
                $action .= View('layouts.actions.delete')->with('model', $user)->with('route', 'role.destroy');
                return $action .= '';
            })
            ->rawColumns(['action'])
            ->make(true);
    }

    public static function getStaffRoles(){
        return [self::ROLE_ADMIN => "Admin",self::ROLE_TEACHER => "Teacher", self::ROLE_ACCOUNTANT => "Accountant",self::ROLE_LIBRARIAN => "Librarian"];
    }

}
