<?php
class ResetAuthModel {
    private $conn;
    private $table = 'users'; // Admin login table

    public function __construct($conn) {
        $this->conn = $conn;
    }

    // Login by email or phone
    public function findUserByEmail($email) {
    $stmt = $this->conn->prepare("SELECT * FROM users WHERE email = ?");
    $stmt->bind_param("s", $email);
    $stmt->execute();
    $result = $stmt->get_result();
    return $result->fetch_assoc();
}
	


public function updateResetToken($userId, $token) {
    $stmt = $this->conn->prepare("UPDATE users SET reset_token = ?, reset_token_expiry = DATE_ADD(NOW(), INTERVAL 1 HOUR) WHERE id = ?");
    $stmt->bind_param("si", $token, $userId);
    return $stmt->execute();
}
	
public function verifyResetToken($token) {
    $stmt = $this->conn->prepare("SELECT * FROM users WHERE reset_token = ? AND reset_token_expiry > NOW()");
    $stmt->bind_param('s', $token);
    $stmt->execute();
    $result = $stmt->get_result();
    return $result->fetch_assoc();
}


public function resetPassword($token, $newPassword) {
    $stmt = $this->conn->prepare("SELECT id FROM users WHERE reset_token = ? AND reset_token_expiry > NOW()");
    $stmt->bind_param("s", $token);
    $stmt->execute();
    $result = $stmt->get_result();
    $user = $result->fetch_assoc();

    if ($user) {
        $hashedPassword = password_hash($newPassword, PASSWORD_BCRYPT);
        $stmt = $this->conn->prepare("UPDATE users SET password = ?, reset_token = NULL, reset_token_expiry = NULL WHERE id = ?");
        $stmt->bind_param("si", $hashedPassword, $user['id']);
        return $stmt->execute();
    }
    return false;
}

}
