<?php
class NewspaperModel {
    private $conn;

    public function __construct($db) {
        $this->conn = $db;
    }

    // Get all
    public function getAll() {
        $sql = "SELECT * FROM newspapers ORDER BY id DESC";
        $result = mysqli_query($this->conn, $sql);
        $data = [];
        while ($row = mysqli_fetch_assoc($result)) {
            $data[] = $row;
        }
        return $data;
    }
    
    public function dropdownnewpepars() {
        $stmt = $this->conn->prepare("SELECT id, name, price FROM newspapers WHERE status = 'active' ORDER BY name ASC");
        $stmt->execute();
        return $stmt->get_result();
    }

    // Get by ID
    public function getById($id) {
        $id = (int)$id;
        $sql = "SELECT id, name, price, status FROM newspapers WHERE id = $id";
        $result = mysqli_query($this->conn, $sql);
        return mysqli_fetch_assoc($result);
    }

    // Check duplicate name
    public function checkNameExists($name, $id = 0) {
        $name = mysqli_real_escape_string($this->conn, $name);
        $id   = (int)$id;
        $sql = "SELECT id FROM newspapers WHERE name = '$name' AND id != $id";
        $result = mysqli_query($this->conn, $sql);
        return mysqli_num_rows($result) > 0;
    }

    // Create
    public function create($name, $price, $status) {
        $name   = mysqli_real_escape_string($this->conn, $name);
        $price  = (float)$price;
        $status = mysqli_real_escape_string($this->conn, $status);
        $sql = "INSERT INTO newspapers (name, price, status) VALUES ('$name', '$price', '$status')";
        return mysqli_query($this->conn, $sql);
    }

    // Update
    public function update($id, $name, $price, $status) {
        $id     = (int)$id;
        $name   = mysqli_real_escape_string($this->conn, $name);
        $price  = (float)$price;
        $status = mysqli_real_escape_string($this->conn, $status);

        $sql = "UPDATE newspapers SET name='$name', price='$price', status='$status' WHERE id = $id";
        return mysqli_query($this->conn, $sql);
    }

    // Delete
    public function delete($id) {
        $id = (int)$id;
        $sql = "DELETE FROM newspapers WHERE id = $id";
        return mysqli_query($this->conn, $sql);
    }

    // Toggle Status
    public function toggleStatus($id) {
        $id = (int)$id;
        $sql = "UPDATE newspapers 
                   SET status = IF(status='active','inactive','active') 
                 WHERE id = $id";
        return mysqli_query($this->conn, $sql);
    }
}
