<?php
require_once '../inc/db.php'; 
require_once '../models/NewspaperModel.php';

$model = new NewspaperModel($conn);

if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    $action = $_GET['action'] ?? '';

    // List newspapers
    if ($action === 'Newspeparlist') {
        $rows = $model->getAll();
        $n = 1;
        foreach ($rows as $row) {
            $checked = ($row['status'] === 'active') ? 'checked' : '';

            $statusSwitch = "<label class='switch switch-success'>
                <input type='checkbox' class='switch-input toggleStatus' data-id='{$row['id']}' $checked />
                <span class='switch-toggle-slider'>
                  <span class='switch-on'><i class='icon-base ti tabler-check'></i></span>
                  <span class='switch-off'><i class='icon-base ti tabler-x'></i></span>
                </span>
              </label>";

            echo '<tr>
                <td>' . $n++ . '</td>
                <td>' . htmlspecialchars(ucwords($row['name'])) . '</td>
                <td>' . number_format($row['price'], 2) . '</td>
                <td>' . $statusSwitch . '</td>
                <td>
                  <button type="button" class="btn btn-xs btn-warning rounded-pill editBtn" 
                          data-id="' . $row['id'] . '">
                    <i class="tf-icons ti ti-edit"></i>
                  </button>
                  <button type="button" class="btn btn-xs btn-danger rounded-pill deleteBtn" 
                          data-id="' . $row['id'] . '">
                    <i class="tf-icons ti ti-trash"></i>
                  </button>
                </td>
            </tr>';
        }
        exit;
    }
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $action = $_POST['action'] ?? '';

    if ($action === 'getNewspepar') {
        $data = $model->getById($_POST['id']);
        echo json_encode($data);
        exit;
    }

    if ($action === 'deleteNewspepar') {
        $model->delete($_POST['id']);
        echo json_encode(['status' => 'success', 'message' => 'Deleted successfully.']);
        exit;
    }

    if ($action === 'toggleStatus') {
        $model->toggleStatus($_POST['id']);
        echo json_encode(['status' => 'success', 'message' => 'Status updated successfully.']);
        exit;
    }

    // Save (Create or Update)
    $id     = $_POST['id'] ?? '';
    $name   = trim($_POST['name'] ?? '');
    $price  = trim($_POST['price'] ?? '');
    $status = $_POST['status'] ?? 'active';

    $errors = [];
    if ($name === '') {
        $errors[] = "Name is required.";
    }
    if ($price === '' || !is_numeric($price)) {
        $errors[] = "Valid price is required.";
    }

    if ($model->checkNameExists($name, $id ?: 0)) {
        $errors[] = "Newspaper name already exists.";
    }

    if (!empty($errors)) {
        echo json_encode(['status' => 'error', 'errors' => $errors]);
        exit;
    }

    if ($id === '') {
        $model->create($name, $price, $status);
        echo json_encode(['status' => 'success', 'message' => 'Newspaper created successfully.']);
    } else {
        $model->update($id, $name, $price, $status);
        echo json_encode(['status' => 'success', 'message' => 'Newspaper updated successfully.']);
    }
    exit;
}
