<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
include("inc/template.php");

function main() {
    $hotel_id = 1; // or $_SESSION['hotel_id'] ?? 0
    ?>
    <div class="container-xxl flex-grow-1 container-p-y">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb breadcrumb-custom-icon">
                <li class="breadcrumb-item"><a href="dashboard.php">Home</a></li>
                <li class="breadcrumb-item"><a href="agency_add.php">Agency Add</a></li>
                <li class="breadcrumb-item active">Agency List</li>
            </ol>
        </nav>

        <div id="alert-box" class="alert d-none" style="z-index:1080;"></div>

        <div class="card">
            <div class="card-datatable table-responsive">
               <table class="datatables-ajax table table-bordered" id="agencyTable">
				<thead>
					<tr>
						<th>Reg. No.</th>
						<th>Agency Name</th>
						<th>Owner Name</th>
						<th>Phone</th>
						<th>City</th>
						<th>Reg Date</th>
						<th>Status</th>
						<th>Action</th>
					</tr>
				</thead>
				<tbody></tbody>
			</table>

            </div>
        </div>
		<div class="modal fade" id="agencyModal" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">Agency Details</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
      </div>
      <div class="modal-body" id="agencyDetails"></div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
      </div>
    </div>
  </div>
</div>
    </div>
<script>
let agencyTable;

function showToast(message, type='success'){
    const alertBox = $('#alert-box');
    alertBox.removeClass('d-none alert-success alert-danger')
            .addClass('alert alert-' + (type==='success' ? 'success' : 'danger'))
            .text(message);
    setTimeout(() => alertBox.addClass('d-none').removeClass('alert-success alert-danger').text(''), 3000);
}
function capitalizeWords(str) {
    if (!str) return '';
    return str.toLowerCase().replace(/\b\w/g, function(txt){ return txt.toUpperCase(); });
}
function initializeAgencyTable() {
    if ($.fn.DataTable.isDataTable('#agencyTable')) {
        agencyTable.ajax.reload(null, false);
        return;
    }

    agencyTable = $('#agencyTable').DataTable({
        processing: true,
        serverSide: true,
        ajax: {
            url: 'controllers/AgencyController.php',
            type: 'POST',
            data: { action: 'listAgency' }
        },
        columns: [
            { data: 'registration_no' },
            { data: 'agencyname', render: d => capitalizeWords(d) },
    { data: 'ownername', render: d => capitalizeWords(d) },
            { data: 'phone' },
            { data: 'city', render: d => capitalizeWords(d) },
            { data: 'created_at' },
            { 
                data: 'status',
                render: function(data, type, row){
        const checked = data === 'active' ? 'checked' : '';
        return `
            <label class='switch switch-success'>
                <input type='checkbox' class='switch-input toggleStatus' data-id='${row.id}' ${checked} />
                <span class='switch-toggle-slider'>
                    <span class='switch-on'><i class='icon-base ti tabler-check'></i></span>
                    <span class='switch-off'><i class='icon-base ti tabler-x'></i></span>
                </span>
            </label>
        `;
                }
            },
            { data: 'actions', orderable:false, searchable:false }
        ],
        order: [[5,'desc']]
    });
}

$(document).ready(function(){

    initializeAgencyTable();

    // Toggle Status
    $(document).on('change','.toggleStatus',function(){
        const id = $(this).data('id');
        $.post('controllers/AgencyController.php',{action:'toggleStatus',id:id}, function(res){
            const r = JSON.parse(res);
            showToast(r.message, r.status==='success'?'success':'danger');
            agencyTable.ajax.reload(null,false);
        });
    });

    // Delete Agency
    // Delete Agency
$(document).on('click', '.deleteAgency', function() {
    const id = $(this).data('id');
    Swal.fire({
        title: 'Are you sure?',
        text: "Do you really want to delete this Agency?",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#d33',
        cancelButtonColor: '#6c757d',
        confirmButtonText: 'Yes, delete it!'
    }).then((swalResult) => {  // ✅ renamed to avoid conflict
        if (swalResult.isConfirmed) {
            $.post('controllers/AgencyController.php', { action: 'deleteAgency', id: id }, function(res) {
                const response = JSON.parse(res); // ✅ renamed to avoid overwrite
                if (response.status === 'success') {
                    agencyTable.ajax.reload(null,false);
                    Swal.fire('Deleted!', response.message, 'success');
                } else {
                    Swal.fire('Error!', response.message, 'error');
                }
            });
        }
    });
});

    
	
    // View More Details in Modal
   $(document).on('click','.viewAgency',function(){
    const id = $(this).data('id');
    $.getJSON('controllers/AgencyController.php',{action:'viewAgency',id:id},function(r){
        let html = `
        <div class="table-responsive">
            <table class="table table-sm table-bordered">
                <tr><th>Reg. No.</th><td>${r.registration_no}</td></tr>
                <tr><th>Agency Name</th><td>${capitalizeWords(r.agencyname)}</td></tr>
                <tr><th>Owner Name</th><td>${capitalizeWords(r.ownername)}</td></tr>
                <tr><th>Email</th><td>${r.email}</td></tr>
                <tr><th>Phone</th><td>${r.phone}</td></tr>
                <tr><th>City</th><td>${capitalizeWords(r.city)}</td></tr>
                <tr><th>State</th><td>${capitalizeWords(r.state)}</td></tr>
                <tr><th>Country</th><td>${capitalizeWords(r.country)}</td></tr>
                <tr><th>Address</th><td>${r.address}</td></tr>
                <tr><th>Updated At</th><td>${
                    new Date(r.updated_at).toLocaleString('en-GB', { 
                        day: '2-digit', month: '2-digit', year: 'numeric', 
                        hour: '2-digit', minute: '2-digit', hour12: true 
                    })
                }</td></tr>
            </table>
        </div>`;

        if(r.logo) {
            html += `<div class="text-center mt-2">
                        <img src="uploads/agency/${r.logo}" 
                             class="img-fluid rounded shadow-sm" 
                             style="max-height:180px;object-fit:contain"/>
                     </div>`;
        }

        $('#agencyDetails').html(html);
        $('#agencyModal').modal('show');
    });
});

});

</script>

<?php } ?>
