<?php include( 'inc/template.php' );?>
	<div class="container-fluid flex-grow-1 container-p-y">
		<nav aria-label="breadcrumb">
	<ol class="breadcrumb">
    <li class="breadcrumb-item"><a href="index.php">Home</a></li>
	<li class="breadcrumb-item"><a href="inquiry_list.php">Inquiry List</a></li>
    <li class="breadcrumb-item active"><?php echo isset($_GET['id']) ? 'Update Inquiry' : 'Inquiry Add'; ?></li>
    </ol>
</nav>
		<div class="card mb-4">

			<form class="card-body" method="post" enctype="multipart/form-data">
    <div class="row g-3">
        <!-- Basic Customer Info -->
        <div class="col-md-6">
            <label class="form-label" for="name">Customer Name</label>
            <input type="text" id="name" name="name" class="form-control" required />
        </div>
        <div class="col-md-6">
            <label class="form-label" for="phone">Mobile</label>
            <input type="tel" id="phone" name="phone" class="form-control" pattern="\d{10}" maxlength="10" required />
        </div>
        <div class="col-md-6">
            <label class="form-label" for="email">Email</label>
            <input type="email" id="email" name="email" class="form-control" />
        </div>
        <div class="col-md-6">
            <label class="form-label" for="address">Address</label>
            <input type="text" id="address" name="address" class="form-control" />
        </div>

        <!-- Inquiry Travel Details -->
        <div class="col-md-3">
            <label class="form-label" for="source">Source</label>
            <input type="text" id="source" name="source" class="form-control" />
        </div>
        <div class="col-md-3">
            <label class="form-label" for="destination">Travel Destination</label>
            <input type="text" id="destination" name="destination" class="form-control" />
        </div>
        <div class="col-md-3">
            <label class="form-label" for="travel_date">Travel Date</label>
            <input type="date" id="travel_date" name="travel_date" class="form-control" />
        </div>
        <div class="col-md-3">
            <label class="form-label" for="nights">No. of Nights</label>
            <input type="number" id="nights" name="nights" min="1" max="100" value="1" class="form-control" />
        </div>
        <div class="col-md-2">
            <label class="form-label" for="adults">Adults</label>
            <input type="number" id="adults" name="adults" min="1" max="100" value="1" class="form-control" />
        </div>
        <div class="col-md-2">
            <label class="form-label" for="child">Child</label>
            <input type="number" id="child" name="child" min="0" max="100" value="0" class="form-control" />
        </div>
<!--
		<div class="col-md-2">
      <label for="extrabed" class="form-label">Extra Bed</label>
      <input type="number" id="extrabed" name="extrabed" min="0" max="100" value="0" class="form-control" />
    </div>
-->
<!--
        <div class="col-md-2">
            <label class="form-label" for="infants">Infants</label>
            <input type="number" id="infants" name="infants" min="0" max="100" value="0" class="form-control" />
        </div>
-->
        <div class="col-md-2">
            <label class="form-label" for="rooms">No. of Rooms</label>
            <input type="number" id="rooms" name="rooms" min="1" max="100" value="1" class="form-control" />
        </div>

        <!-- Preferences -->
        <div class="col-md-2">
            <label class="form-label" for="hotel_type">Hotel Type</label>
            <select id="hotel_type" name="hotel_type" class="form-select">
                <option value="">Select</option>
                <option value="3-star">3-star</option>
                <option value="4-star">4-star</option>
                <option value="5-star">5-star</option>
            </select>
        </div>
<!--
        <div class="col-md-2">
            <label class="form-label" for="transport_type">Transport Type</label>
            <select id="transport_type" name="transport_type" class="form-select">
                <option value="">Select</option>
                <option value="Private Cab">Private Cab</option>
        <option value="Shared Cab">Shared Cab</option>
        <option value="Bus">Bus</option>
        <option value="Train">Train</option>
        <option value="Flight">Flight</option>
        <option value="Self Drive">Self Drive</option>
            </select>
        </div>
-->
<!--
        <div class="col-md-2">
            <label class="form-label" for="with_flight">With Flight</label>
            <select id="with_flight" name="with_flight" class="form-select">
                <option value="">Select</option>
                <option value="yes">Yes</option>
                <option value="no">No</option>
            </select>
        </div>
-->

        <!-- Inquiry Info -->
        <div class="col-md-2">
            <label class="form-label" for="inquiry_type">Inquiry Type</label>
            <select class="form-select" id="inquiry_type" name="inquiry_type">
                <option value="">Select...</option>
                <option value="package">Package</option>
                <option value="hotel">Hotel</option>
            </select>
        </div>

        <!-- Assignment -->
        <div class="col-md-4">
            <label class="form-label" for="assigned_to">Assigned to</label>
            <select class="form-select" id="assigned_to" name="assigned_to" required>
                <option value="">Select...</option>
                <?php
                $result = $conn->query("SELECT id, name FROM users WHERE status = 'active' ORDER BY name ASC");
                while ($row = $result->fetch_assoc()) {
                    echo '<option value="' . $row['id'] . '">' . htmlspecialchars(ucwords(strtolower($row['name']))) . '</option>';
                }
                ?>
            </select>
        </div>

        <!-- Remarks -->
        <div class="col-md-8">
            <label class="form-label" for="remarks">Note</label>
            <textarea name="remarks" id="remarks" class="form-control" rows="4"></textarea>
        </div>
    </div>

    <!-- Hidden fields and buttons -->
    <div class="pt-4">
        <input type="hidden" id="upd" value="<?php echo isset($_GET['id']) ? $_GET['id'] : ''; ?>">
        <input type="hidden" name="id" id="id">
        <input type="hidden" name="action" id="action" value="<?php echo isset($_GET['id']) ? 'Update' : 'Create'; ?>">
        <button type="submit" class="btn btn-primary me-2"><?php echo isset($_GET['id']) ? 'Update' : 'Save'; ?></button>
        <button type="reset" class="btn btn-label-secondary">Cancel</button>
    </div>
</form>



		</div>
	</div>


<script>
$(document).ready(function () {
    // Submit form
    $('form.card-body').on('submit', function (event) {
        event.preventDefault();

        let formData = new FormData(this); // Automatically picks all fields

        // Basic validation
        if (!formData.get("name") || !formData.get("phone") || !formData.get("assigned_to")) {
            toastr.error("Customer Name, Mobile, and Assigned To are required.");
            return;
        }

        $.ajax({
            url: 'controller/InquiryController.php', // Change to your actual PHP processing file
            method: 'POST',
            data: formData,
            contentType: false,
            processData: false,
            success: function (response) {
                if (response.status === 'success') {
                    toastr.success(response.message);
                    setTimeout(() => window.location.href = 'inquiry_list.php', 1500);
                } else {
                    toastr.error(response.message || 'An error occurred. Please try again.');
                }
            },
            error: function (xhr, status, error) {
                toastr.error('An error occurred while submitting the form. Please try again.');
                console.error('AJAX error:', status, error, xhr.responseText);
            }
        });
    });

    // Load existing data if updating
    const upd = $('#upd').val();
    if (upd) {
        $.ajax({
            url: 'controller/InquiryController.php', // Adjust endpoint for fetching data
            method: 'POST',
            data: { id: upd, action: 'Select' },
            dataType: 'json',
            success: function (data) {
                if (data) {
                    $('#name').val(data.name);
                    $('#phone').val(data.phone);
                    $('#email').val(data.email);
                    $('#address').val(data.address);
                    $('#source').val(data.source);
                    $('#destination').val(data.destination);
                    $('#travel_date').val(data.travel_date);
                    $('#nights').val(data.nights);
                    $('#adults').val(data.adults);
                    $('#child').val(data.child);
                    $('#extrabed').val(data.extrabed);
                    $('#rooms').val(data.rooms);
                    $('#hotel_type').val(data.hotel_type);
                    $('#transport_type').val(data.transport_type);
                    $('#with_flight').val(data.with_flight);
                    $('#inquiry_type').val(data.inquiry_type);
                    $('#assigned_to').val(data.assigned_to);
                    $('#remarks').val(data.remarks);

                    $('#id').val(upd);
                    $('#action').val('Update');
                } else {
                    toastr.error('Failed to load inquiry data.');
                }
            },
            error: function (xhr, status, error) {
                toastr.error('Failed to load inquiry data.');
                console.error('AJAX error:', status, error, xhr.responseText);
            }
        });
    }
});
</script>

<?php include('inc/footer.php');?>