<?php include('inc/template.php');?>

<div class="container-fluid flex-grow-1 container-p-y">
<nav aria-label="breadcrumb">
	<ol class="breadcrumb">
    <li class="breadcrumb-item"><a href="index.php">Home</a></li>
    <li class="breadcrumb-item active">State Master</li>
    </ol>
</nav>
    <button type="button" class="btn btn-sm btn-primary" data-bs-toggle="modal" data-bs-target="#basicModal">
        <span class="ti-xs ti ti-plus me-1"></span> Add New State
    </button>
    <div class="row mb-4">
                <!--  Modal -->
        <div class="modal fade" id="basicModal" tabindex="-1" aria-labelledby="basicModalLabel" aria-hidden="true">
            <div class="modal-dialog modal-lg">
                <div class="modal-content">
                    <form id="salesForm">
                        <div class="modal-header">
                            <h5 class="modal-title" id="basicModalLabel">Add/Edit State </h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>
                        <div class="modal-body">
                            <input type="hidden" id="role" name="role" value="sales" />

                            <!-- Name -->
                            <div class="row">
                                <div class="col mb-3">
                                    <label for="state_name" class="form-label">State Name</label>
                                    <input type="text" id="state_name" name="state_name" class="form-control"  required />
                                </div>
                            </div>
							<div class="row">
                                <div class="col mb-3">
                                    <label for="country" class="form-label">Country</label>
									<input type="text" id="country" name="country" class="form-control" value="India"  required />
                                   
                                </div>
                            </div>
                            

                            <!-- Password -->
                            
                        </div>
                        <div class="modal-footer">
                            <input type="hidden" name="id" id="id" />
                            <input type="hidden" name="action" id="action" value="CreateState" />
                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                            <button type="submit" class="btn btn-primary">Save Changes</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <!-- Users Table -->
        <div class="col-xl-12 col-lg-6 col-md-6">
            <div class="card">
                <div class="card-datatable table-responsive pt-0">
                    <table class="datatables-ajax table table-bordered table-responsive">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>State</th>
                                <th>Country</th>
                               	<th>Status</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
							$n=0;
                            $result = mysqli_query($conn, "SELECT * FROM states ORDER BY country ASC");
                            while ($row = mysqli_fetch_array($result)) { $n++;
                            ?>
                            <tr class="showtr">
                                <td><?php echo htmlspecialchars($n); ?></td>
								<td><?php echo htmlspecialchars($row['state_name']); ?></td>
                                <td><?php echo htmlspecialchars($row['country']); ?></td>
                                								
                                <td>
                                    <label class="switch">
                                        <input type="checkbox" class="switch-input" value="<?php echo $row[0]; ?>"
                                               <?php if ($row['status'] == '1') echo "checked"; ?>
                                               onClick="statusChange(this.value);" />
                                        <span class="switch-toggle-slider">
                                            <span class="switch-on"></span>
                                            <span class="switch-off"></span>
                                        </span>
                                    </label>
                                </td>
                                <td>
									
									<button type="button" id="<?php echo $row[0]; ?>" class="btn btn-xs btn-warning update"><i class="far fa-edit"></i></button>
                   				 <button type="button" id="<?php echo $row[0]; ?>" class="btn btn-xs btn-danger delete"><i class="far fa-trash-alt"></i></button>
                                   
                                </td>
                            </tr>
                            <?php } ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
$(document).ready(function () {

    // Show modal for Create
    $('#basicModal').on('show.bs.modal', function () {
        if ($('#action').val() === 'CreateState') {
            $('#salesForm')[0].reset();
            $('.modal-title').text("Add New State");
        }
    });

    // Show modal for Update
    $(document).on('click', '.update', function () {
        const id = $(this).attr("id");
        $.ajax({
            url: "controller/StateCityController.php",
            method: "POST",
            data: { id: id, action: 'SelectState' },
            dataType: "json",
            success: function (data) {
                $('#state_name').val(data.state_name);
                $('#country').val(data.country);
                $('#id').val(id);
                $('#action').val('Update');
                $('.modal-title').text("Update State");
                $('#basicModal').modal('show');
            },
            error: function () {
                toastr.error('Error fetching data.');
            }
        });
    });

    // Submit form for Create or Update
    $('#salesForm').on('submit', function (e) {
        e.preventDefault();

        const formData = {
            state_name: $('#state_name').val(),
            country: $('#country').val(),
            action: $('#action').val(),
            id: $('#id').val()
        };

        if (formData.state_name && formData.country) {
            $.ajax({
                url: "controller/StateCityController.php",
                method: "POST",
                data: formData,
                dataType: "json",
                success: function (response) {
                    $('#basicModal').modal('hide');
                    if (response.status === 'success') {
                        toastr.success(response.message);
                        setTimeout(() => location.reload(), 1000); // reload table
                    } else {
                        toastr.error(response.message);
                    }
                },
                error: function () {
                    toastr.error('Error processing request.');
                }
            });
        } else {
            toastr.error("Please fill all required fields.");
        }
    });

    // Status change
    window.statusChange = function (id) {
        $.ajax({
            url: 'controller/StateCityController.php',
            method: 'POST',
            data: { id: id, action: 'StateToggleStatus' },
            dataType: "json",
            success: function (response) {
                if (response.status === 'success') {
                    const newStatus = response.new_status === "active" ? "Active" : "Inactive";
                    toastr.success(`Status changed to ${newStatus}`);
                } else {
                    toastr.error(response.message);
                }
            },
            error: function () {
                toastr.error('Failed to update status.');
            }
        });
    };

    // Delete state
    $(document).on('click', '.delete', function () {
        const id = $(this).attr("id");
        const row = $(this).closest('tr');

        if (confirm('Are you sure you want to delete this state?')) {
            $.ajax({
                url: 'controller/StateCityController.php',
                method: 'POST',
                data: { id: id, action: 'DeleteState' },
                dataType: "json",
                success: function (response) {
                    if (response.status === 'success') {
                        toastr.success(response.message);
                        row.css('background-color', '#f8d7da').fadeOut(800, function () {
                            $(this).remove();
                        });
                    } else {
                        toastr.error(response.message);
                    }
                },
                error: function () {
                    toastr.error('Error deleting state.');
                }
            });
        }
    });

});
</script>


<?php include('inc/footer.php');?>