<?php
error_reporting(E_ALL); // Report all PHP errors
ini_set('display_errors', 1); // Display errors in the browser
ini_set('display_startup_errors', 1); // Display startup errors

?>
<!DOCTYPE html>

<html lang="en" class="light-style layout-wide customizer-hide" dir="ltr" data-theme="theme-default" data-assets-path="assets/" data-template="horizontal-menu-template">
<head>
	<meta charset="utf-8"/>
	<meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0"/>

	<title>Reset Password </title>


	<link rel="apple-touch-icon" sizes="180x180" href="assets/img/favicon/apple-touch-icon.png">
	<link rel="icon" type="image/png" sizes="32x32" href="assets/img/favicon/favicon-32x32.png">
	<link rel="icon" type="image/png" sizes="16x16" href="assets/img/favicon/favicon-16x16.png">
	<link rel="manifest" href="assets/img/favicon/site.webmanifest">


	<!-- Icons -->
	<link rel="stylesheet" href="assets/vendor/fonts/fontawesome.css"/>
	<link rel="stylesheet" href="assets/vendor/fonts/tabler-icons.css"/>
	<link rel="stylesheet" href="assets/vendor/fonts/flag-icons.css"/>

	<!-- Core CSS -->
	<link rel="stylesheet" href="assets/vendor/css/rtl/core.css" class="template-customizer-core-css"/>
	<link rel="stylesheet" href="assets/vendor/css/rtl/theme-default.css" class="template-customizer-theme-css"/>
	<link rel="stylesheet" href="assets/css/demo.css"/>

	<!-- Vendors CSS -->
	<link rel="stylesheet" href="assets/vendor/libs/node-waves/node-waves.css"/>
	<link rel="stylesheet" href="assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.css"/>
	<link rel="stylesheet" href="assets/vendor/libs/typeahead-js/typeahead.css"/>
	
	<link rel="stylesheet" href="assets/vendor/css/pages/page-auth.css"/>

	<!-- Helpers -->
	<script src="assets/vendor/js/helpers.js"></script>
	
	<script src="assets/js/config.js"></script>
	<script src="assets/js/jquery.min.js"></script>
	<link rel="stylesheet" href="assets/toastr.min.css">
	<script src="assets/toastr.min.js"></script>
</head>

<body>
<?php
// Start session for handling messages
session_start();
include( 'inc/config.php' );
// Check if form is submitted
if (isset($_POST["reset_password"])) {
    // Get form inputs
    $username = mysqli_real_escape_string($conn, $_POST["username"]);
    $new_password = $_POST["new_password"];
    $confirm_password = $_POST["confirm_password"];

    // Validate if the username exists in either Doctors or Employees table
    $user_found = false;
    $tables = ["Users"];

    foreach ($tables as $table) {
        $sql = "SELECT * FROM `$table` WHERE username = ?";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("s", $username);
        $stmt->execute();
        $result = $stmt->get_result();

        if ($result->num_rows > 0) {
            $user_found = true;
            $current_table = $table;
            break;
        }
    }

    if (!$user_found) {
        echo "<script>
            $(document).ready(function() {
                toastr.error('Username does not exist in our records.');
            });
        </script>";
    } else {
        // Check if passwords match
        if ($new_password === $confirm_password) {
            // Hash the new password
            $hashed_password = password_hash($new_password, PASSWORD_DEFAULT);
           // $hashed_password = $new_password;

            // Update the password in the respective table
            $update_sql = "UPDATE `$current_table` SET PasswordHash = ? WHERE Username = ?";
            $update_stmt = $conn->prepare($update_sql);
            $update_stmt->bind_param("ss", $hashed_password, $username);

            if ($update_stmt->execute()) {
                echo "<script>
                    $(document).ready(function() {
                        toastr.success('Password reset successfully. You can now log in.');
                    });
                </script>";
            } else {
                echo "<script>
                    $(document).ready(function() {
                        toastr.error('An error occurred while resetting your password.');
                    });
                </script>";
            }
        } else {
            echo "<script>
                $(document).ready(function() {
                    toastr.error('Passwords do not match.');
                });
            </script>";
        }
    }
}
?>


	<div class="authentication-wrapper authentication-basic container-p-y">
        <div class="authentication-inner py-4">
		
            <div class="card">
            <div class="card-body">
              <!-- Logo -->
              <div class="app-brand justify-content-center mb-4 mt-2">
               <a href="#" class="app-brand-link gap-2">
                <span class="app-brand-logo demo">
                  <img src="assets/img/hyena_logo.png" width="300" alt="" />
                </span>
              </a>
              </div>
              	<h4 class="mb-1">Reset Password </h4>
            	<form class="mb-3" action="#" method="POST">
						<div class="mb-3">
							<label for="username" class="form-label">Username</label>
							<input type="text" name="username" class="form-control" required>
						</div>
						<div class="mb-3 form-password-toggle">
							<label class="form-label" for="password">New Password</label>
							<div class="input-group input-group-merge">
								<input type="password" id="new_password" class="form-control" name="new_password" placeholder="&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;" aria-describedby="password"/>
								<span class="input-group-text cursor-pointer"><i class="ti ti-eye-off"></i></span>
							</div>
						</div>
						<div class="mb-3 form-password-toggle">
							<label class="form-label" for="confirm-password">Confirm Password</label>
							<div class="input-group input-group-merge">
								<input type="password" id="confirm_password" class="form-control" name="confirm_password" placeholder="&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;" aria-describedby="password"/>
								<span class="input-group-text cursor-pointer"><i class="ti ti-eye-off"></i></span>
							</div>
						</div>
						<button class="btn btn-primary d-grid w-100 mb-3" type="submit" name="reset_password">Set new password</button>
						<div class="text-center">
							<a href="login.php">
                  <i class="ti ti-chevron-left scaleX-n1-rtl"></i>
                  Back to login
                </a>
						
						</div>
					</form>

            </div>
          </div>
		
	
		</div>
	</div>


	<!-- / Content -->

	<!-- Core JS -->
	<!-- build:js assets/vendor/js/core.js -->

	<script src="assets/vendor/libs/jquery/jquery.js"></script>
	<script src="assets/vendor/libs/popper/popper.js"></script>
	<script src="assets/vendor/js/bootstrap.js"></script>
	<script src="assets/vendor/libs/node-waves/node-waves.js"></script>
	<script src="assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.js"></script>
	<script src="assets/vendor/libs/hammer/hammer.js"></script>
	<script src="assets/vendor/libs/i18n/i18n.js"></script>
	<script src="assets/vendor/libs/typeahead-js/typeahead.js"></script>
	<script src="assets/vendor/js/menu.js"></script>

	<script src="assets/js/main.js"></script>

	<!-- Page JS -->
	<script src="assets/js/pages-auth.js"></script>
</body>
</html>