<?php include( 'inc/template.php' );?>
<div class="container-fluid flex-grow-1 container-p-y">
	<nav aria-label="breadcrumb">
	<ol class="breadcrumb">
    <li class="breadcrumb-item"><a href="index.php">Home</a></li>
	<li class="breadcrumb-item"><a href="quotation_list.php">Quotation List</a></li>
    <li class="breadcrumb-item active"><?php echo isset($_GET['id']) ? 'Update Quotation' : 'Quotation Add'; ?></li>
    </ol>
</nav>
	<link rel="stylesheet" href="assets/vendor/libs/quill/editor.css" />
<button type="button" class="btn btn-sm btn-primary" data-bs-toggle="modal" data-bs-target="#basicModal">
        <span class="ti-xs ti ti-plus me-1"></span> Add New Customer
    </button>
<div class="modal fade" id="basicModal" tabindex="-1" aria-labelledby="basicModalLabel" aria-hidden="true">
            <div class="modal-dialog modal-lg">
                <div class="modal-content">
                    <form id="CustomerForm">
                        <div class="modal-header">
                            <h5 class="modal-title" id="basicModalLabel">Customer Form</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>
                        <div class="modal-body">
                            
                            <div class="row">
                                <div class="col mb-3">
                                    <label for="name" class="form-label">Customer Name</label>
                                    <input type="text" id="name" name="name" class="form-control" placeholder="Enter Name" required />
                                </div>
                            </div>

                            <!-- Phone -->
                            <div class="row">
                                <div class="col mb-3">
                                    <label for="mobile" class="form-label">Mobile</label>
                                    <input type="tel" id="phone" name="phone" class="form-control" placeholder="Enter Mobile Number" pattern="\d{10}" maxlength="10" required />
                                </div>
                            </div>

                            <!-- Email -->
                            <div class="row">
                                <div class="col mb-3">
                                    <label for="email" class="form-label">Email</label>
                                    <input type="email" id="email" name="email" class="form-control" required />
                                </div>
                            </div>
							
							
                            <!-- Username -->
                            <div class="row">
                                <div class="col mb-3">
                                    <label for="username" class="form-label">Address</label>
                                    <input type="text" id="address" name="address" class="form-control" />
                                </div>
                            </div>

                        </div>
                        <div class="modal-footer">
                            <input type="hidden" name="id" id="id" />
                            <input type="hidden" name="action" id="action" value="Create" />
                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                            <button type="submit" class="btn btn-primary">Save Changes</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
<script>
$(document).ready(function () {

    // Show modal for Create
    $('#modal_button').click(function () {
        $('#CustomerForm')[0].reset();
        $('.modal-title').text("Create New Customer");
        $('#action').val('Create');
        $('#id').val('');
        $('#basicModal').modal('show');
    });

    // Submit form for Create or Update
    $('#CustomerForm').on('submit', function (e) {
        e.preventDefault();

        const formData = {
            name: $('#name').val().trim(),
            phone: $('#phone').val().trim(),
            email: $('#email').val().trim(),
            address: $('#address').val().trim(),
            action: $('#action').val(),
            id: $('#id').val()
        };

        if (formData.name && formData.phone && formData.email) {
            $.ajax({
                url: "controller/CustomerController.php",
                method: "POST",
                data: formData,
                dataType: "json",
                success: function (response) {
                    $('#basicModal').modal('hide');
                    if (response.status === 'success') {
                        toastr.success(response.message);
                        // Dynamically add the new customer to the dropdown
                        const newCustomer = response.customer;
                        const newOption = `<option value="${newCustomer.id}">${newCustomer.name} ${newCustomer.phone}</option>`;
                        $('#customer_id').append(newOption); // Add the new customer option to the dropdown

                        // Optionally, set the dropdown to select the newly added customer
                        $('#customer_id').val(newCustomer.id);

                        setTimeout(function() {
                            $('#basicModal').modal('hide'); // Hide modal
                        }, 3000);  // Wait 3 seconds before closing modal and refreshing dropdown

                    } else {
                        toastr.error(response.message);
                    }
                },
                error: function () {
                    toastr.error('Request failed. Please try again.');
                }
            });
        } else {
            toastr.error("Please fill all required fields.");
        }
    });
    
    // Function to reload the customer dropdown
    function loadCustomerDropdown() {
        $.ajax({
            url: "controller/CustomerController.php",
            method: "GET",
            data: { action: 'getCustomers' },
            success: function (response) {
                if (response.status === 'success') {
                    const customerSelect = $('#customer_id');
                    customerSelect.empty();  // Clear the current options
                    customerSelect.append('<option value="">Select Customer</option>');  // Add default option
                    response.customers.forEach(function (customer) {
                        customerSelect.append('<option value="' + customer.id + '">' + customer.name + ' ' + customer.phone + '</option>');
                    });

                    // If no customers exist, show a "No results found" message (using Select2 or custom message)
                    if (response.customers.length === 0) {
                        customerSelect.append('<option value="" disabled>No customers found</option>');
                    }
                } else {
                    toastr.error('Failed to load customers.');
                }
            },
            error: function () {
                toastr.error('Error loading customers.');
            }
        });
    }

});
</script>
<div class="card shadow p-4">
<form method="post" id="reference_quotation" enctype="multipart/form-data">
  <!-- Customer & Destination Row -->
  <div class="row g-3">
    <div class="col-md-6">
      <label for="customer_id" class="form-label">Customer Name</label>
      <select name="customer_id" id="customer_id" required class="select2 form-select form-select-lg">
        <option value="">Select Customer</option>
        <?php
          $result = $conn->query("SELECT id, name, phone FROM customers WHERE status = 'active' ORDER BY name ASC");
          while ($row = $result->fetch_assoc()) {
            echo '<option value="' . $row['id'] . '">' . htmlspecialchars(ucwords(strtolower($row['name']))) . ' ' . htmlspecialchars($row['phone']) . '</option>';
          }
        ?>
      </select>
    </div>

    <div class="col-md-6">
      <label for="state_id" class="form-label">Destination Name</label>
      <select id="state_id" name="state_id" class="form-select select2" required>
        <option value="">Select Destination</option>
        <?php
          $destinations = mysqli_query($conn, "SELECT id, state_name FROM states WHERE status='1' ORDER BY state_name ASC");
          while ($d = mysqli_fetch_assoc($destinations)) {
            echo "<option value='{$d['id']}'>{$d['state_name']}</option>";
          }
        ?>
      </select>
    </div>

    <div class="col-md-6">
      <label for="package_id" class="form-label">Package Name</label>
      <select id="package_id" name="package_id" class="form-select" required>
        <option value="">Select Package</option>
      </select>
    </div>

    <div class="col-md-6">
      <label for="category_id" class="form-label">Category Name</label>
      <select name="category_id" id="category_id" required class="form-select">
        <option value="">Select Category</option>
        
      </select>
    </div>

    <div class="col-md-2">
      <label for="travel_date" class="form-label">Travel Date</label>
      <input type="date" id="travel_date" name="travel_date" class="form-control" />
      <input type="hidden" id="quotation_type" name="quotation_type" value="package" />
		 <input type="hidden" id="inquiry_id" name="inquiry_id" value="0" />
    </div>

    <div class="col-md-2">
      <label for="rooms" class="form-label">No. of Rooms</label>
      <input type="number" id="rooms" name="rooms" min="1" max="100" value="1" class="form-control" />
    </div>
	  <div class="col-md-2">
      <label for="nights" class="form-label">No. of Night</label>
      <input type="number" id="nights" name="nights" min="1" max="100" value="1" class="form-control" />
    </div>
  </div>

  <!-- Pricing -->
  <div class="row g-3 mt-2">
    <h5>Package Pricing (Per Person)</h5>
    <div class="col-md-4">
      <label for="adults" class="form-label">Adults</label>
      <input type="number" id="adults" name="adults" min="1" max="100" value="1" class="form-control" />
    </div>
    <div class="col-md-4">
      <label for="child" class="form-label">Child</label>
      <input type="number" id="child" name="child" min="0" max="100" value="0" class="form-control" />
    </div>
    <div class="col-md-4">
      <label for="extrabed" class="form-label">Extra Bed</label>
      <input type="number" id="extrabed" name="extrabed" min="0" max="100" value="0" class="form-control" />
    </div>

    <div class="col-md-4">
      <label>Adult Price (INR)</label>
      <input type="number" name="adult_price" id="adult_price" value="0" class="form-control" required>
    </div>
    <div class="col-md-4">
      <label>Child Price (INR)</label>
      <input type="number" name="child_price" id="child_price" value="0" class="form-control" required>
    </div>
    <div class="col-md-4">
      <label>Extra Bed Price (INR)</label>
      <input type="number" name="extra_bed_price" id="extra_bed_price" value="0" class="form-control" required>
    </div>
  </div>


  <!-- Other Charges -->
  <div class="row g-3 mt-2">
    <h5>Other Charges</h5>
    <div class="col-md-3">
      <label>Transport Type</label>
      <select name="transport_type" id="transport_type" class="form-select">
        <option value="">Select Vehicle</option>
        <?php
          $query = "SELECT id, vehicle_type FROM vehicles WHERE status='active' ORDER BY id ASC";
          $result = mysqli_query($conn, $query);
          while ($r = mysqli_fetch_assoc($result)) {
            echo "<option value='{$r['vehicle_type']}'>{$r['vehicle_type']}</option>";
          }
        ?>
      </select>
    </div>

    <div class="col-md-3">
      <label>Transport Charges (INR)</label>
      <input type="number" name="transport_charges" id="transport_charges" class="form-control" value="0">
    </div>

    <div class="col-md-3">
      <label for="gst_included" class="form-label">With GST?</label>
      <select id="gst_included" name="gst_included" class="form-select" required>
        <option value="no">No</option>
        <option value="yes">Yes</option>
      </select>
    </div>

    <input type="hidden" name="gst" id="gst" class="form-control" value="5">

    <div class="col-md-3">
      <label>Discount %</label>
      <input type="number" name="discount" id="discount" class="form-control" value="0">
    </div>

    <div class="col-md-6">
      <label>Grand Total (INR)</label>
      <input type="text" name="grand_total" id="grand_total" class="form-control" readonly>
    </div>
  </div>

  <!-- Hotel Stay Repeater -->
  <div class="row g-3 mt-2">
    <h5>Hotel Stay Details</h5>
    
    <div id="hotelContainer">
      <!-- hotel rows will be appended here -->
    </div>
  </div>

  <!-- Description/Inclusions/Exclusions -->
  <div class="row g-3 mt-2">
    <div class="col-md-12">
      <label class="form-label">Description</label>
      <div id="editor_description" class="quill-editor"></div>
      <input type="hidden" name="description" id="desc_input">
    </div>

    <?php
      $res = mysqli_query($conn, "SELECT inclusions FROM packages_inclusions WHERE status = 'active' LIMIT 1");
      $row = mysqli_fetch_array($res);
    ?>

    <div class="col-md-12">
      <label class="form-label">Inclusions</label>
      <div id="editor_inclusions" class="quill-editor"></div>
      <input type="hidden" name="inclusions" value="<?php echo htmlspecialchars($row['inclusions']); ?>" id="incl_input">
    </div>

    <div class="col-md-12">
      <label class="form-label">Exclusions</label>
      <div id="editor_exclusions" class="quill-editor"></div>
      <input type="hidden" name="exclusions" id="excl_input">
    </div>
  </div>

  <!-- Hidden Fields & submit -->
  <input type="hidden" name="useridnew" id="useridnew" value="<?php echo $userId; ?>" />
  <input type="hidden" name="id" id="id" value="<?php echo isset($_GET['id']) ? $_GET['id'] : ''; ?>" />
  <input type="hidden" name="action" value="<?php echo isset($_GET['id']) ? 'Update' : 'Create'; ?>" />

  <div class="mt-4">
    <button type="submit" class="btn btn-primary me-2">Save</button>
    <button type="button" id="download-pdf" class="btn btn-primary me-2">Download PDF</button>
    <button type="reset" class="btn btn-secondary">Reset</button>
  </div>
</form>

<script src="assets/vendor/libs/quill/quill.js"></script>

<script src="iadmin/assets/js/form-wizard-numbered.js"></script>
<script src="iadmin/assets/js/form-wizard-validation.js"></script>
<script>
$(document).ready(function() {
  const num = (v) => parseFloat(v || 0);

  // ============================
  // ðŸ–‹ï¸ Quill Editors Initialize
  // ============================
  const fullToolbar = [
    [{ font: [] }, { size: [] }],
    ['bold', 'italic', 'underline', 'strike'],
    [{ color: [] }, { background: [] }],
    [{ script: 'super' }, { script: 'sub' }],
    [{ header: '1' }, { header: '2' }, 'blockquote', 'code-block'],
    [{ list: 'ordered' }, { list: 'bullet' }, { indent: '-1' }, { indent: '+1' }],
    [{ direction: 'rtl' }],
    ['link', 'image', 'video', 'formula'],
    ['clean']
  ];

  // âœ… Use same variable names used later in submit/update
  const descriptionEditor = new Quill('#editor_description', {
    bounds: '#editor_description',
    placeholder: 'Type Description...',
    modules: { toolbar: fullToolbar },
    theme: 'snow'
  });

  const inclusionsEditor = new Quill('#editor_inclusions', {
    bounds: '#editor_inclusions',
    placeholder: 'Type Inclusions...',
    modules: { toolbar: fullToolbar },
    theme: 'snow'
  });

  const exclusionsEditor = new Quill('#editor_exclusions', {
    bounds: '#editor_exclusions',
    placeholder: 'Type Exclusions...',
    modules: { toolbar: fullToolbar },
    theme: 'snow'
  });

  // Set initial inclusions content
  const inclInput = document.getElementById('incl_input');
  if (inclInput && inclInput.value) {
    inclusionsEditor.root.innerHTML = inclInput.value;
  }

  // ============================
  // ðŸ“¦ Package & Category AJAX
  // ============================
  $('#state_id').on('change', function() {
    const state_id = $(this).val();
    $('#package_id').html('<option value="">Loading...</option>');
    $('#category_id').html('<option value="">Select Category</option>');

    if (!state_id) {
      $('#package_id').html('<option value="">Select Package</option>');
      return;
    }

    $.ajax({
      url: 'controller/PackageCategoryPriceController.php',
      type: 'POST',
      dataType: 'json',
      data: { action: 'GetPackages', destination_id: state_id },
      success: function(res) {
        if (res.status === 'success') {
          let options = '<option value="">Select Package</option>';
          $.each(res.data, function(i, pkg) {
            options += `
              <option value="${pkg.id}">
                ${pkg.package_code} - ${pkg.package_name} (${pkg.days}D / ${pkg.nights}N)
              </option>`;
          });
          $('#package_id').html(options);
        } else {
          $('#package_id').html('<option value="">No packages found</option>');
        }
      },
      error: function() {
        $('#package_id').html('<option value="">Error loading packages</option>');
      }
    });
  });

    $('#package_id').on('change', function() {
  const package_id = $(this).val();
  $('#category_id').html('<option value="">Loading...</option>');

  if (!package_id) {
    $('#category_id').html('<option value="">Select Category</option>');
    $('#nights').val(''); // clear nights if no package
    return;
  }

  // Fetch categories first
  $.ajax({
    url: 'controller/PackageCategoryPriceController.php',
    type: 'POST',
    dataType: 'json',
    data: { action: 'GetPackagesCategories', package_id },
    success: function(res) {
      if (res.status === 'success') {
        let options = '<option value="">Select Category</option>';
        $.each(res.data, function(i, cat) {
          options += `<option value="${cat.category_id}">${cat.category_name}</option>`;
        });
        $('#category_id').html(options);
      } else {
        $('#category_id').html('<option value="">No categories found</option>');
      }
    },
    error: function() {
      $('#category_id').html('<option value="">Error loading categories</option>');
    }
  });

  // Fetch package nights
  $.ajax({
    url: 'controller/PackageCategoryPriceController.php',
    type: 'POST',
    dataType: 'json',
    data: { action: 'GetPackageNights', package_id },
    success: function(res) {
      if (res.status === 'success' && res.data.nights) {
        $('#nights').val(res.data.nights);
      } else {
        $('#nights').val('');
      }
    }
  });
});

  // =====================================
  // ðŸ¨ Fetch Category Details + Hotels
  // =====================================
  $('#category_id').on('change', function() {
    const package_id = $('#package_id').val();
    const category_id = $(this).val();

    if (!package_id || !category_id) return;

    $('#hotelContainer').html('<div class="text-center p-3 text-muted">Loading hotels...</div>');

    $.ajax({
      url: 'controller/PackageCategoryPriceController.php',
      type: 'POST',
      dataType: 'json',
      data: { action: 'fetchCategoryDetails', package_id, category_id },
      success: function(data) {
        if (data.status === 'success') {
          $('#adult_price').val(data.adult_price);
//          $('#child_price').val(data.child_price);
//          $('#extra_bed_price').val(data.extra_bed_price);

          const hotels = data.hotels || [];
          let html = '';

          if (hotels.length > 0) {
            hotels.forEach((h, i) => {
              html += `
                <div class="card border rounded-3 p-3 mb-3 shadow-sm">
                  <h6>${h.hotel_name} 
                    <small class="text-muted">(${h.city || 'N/A'})</small>
                    ${h.stars ? `<span class="badge bg-warning text-dark ms-2">${h.stars}*</span>` : ''}
                  </h6>
                  <input type="hidden" name="hotels[${i}][hotel_id]" value="${h.hotel_id}">
                  <input type="hidden" name="hotels[${i}][city]" value="${h.city}">
                  <input type="hidden" name="hotels[${i}][stars]" value="${h.stars}">
                  <div class="row g-2 mt-2">
                    <div class="col-md-3">
                      <label class="form-label mb-1">Nights</label>
                      <input type="number" class="form-control" name="hotels[${i}][nights]" value="1" min="1" required>
                    </div>
                    <div class="col-md-3">
                      <label class="form-label mb-1">Meal Plan</label>
                      <select class="form-select" name="hotels[${i}][meal_plan]" required>
                        <option value="">Select</option>
                        <option value="CP">CP (Room + Breakfast)</option>
                        <option value="MAP">MAP (Room + Breakfast + Dinner)</option>
                        <option value="AP">AP (Room + All Meals)</option>
                      </select>
                    </div>
                    <div class="col-md-3">
                      <label class="form-label mb-1">Rooms</label>
                      <input type="number" class="form-control" name="hotels[${i}][rooms]" value="1" min="1" required>
                    </div>
                  </div>
                </div>`;
            });
          } else {
            html = '<div class="alert alert-warning">No hotels found for this category.</div>';
          }

          $('#hotelContainer').html(html);
          calculateTotal();
        } else {
          $('#hotelContainer').html('<div class="alert alert-danger">No data found.</div>');
        }
      },
      error: function(xhr) {
        console.error('AJAX error:', xhr.responseText);
        $('#hotelContainer').html('<div class="alert alert-danger">Error fetching data.</div>');
      }
    });
  });

  // =====================================
  // ðŸ’° Total Calculation
  // =====================================
  function calculateTotal() {
    const adults = num($('#adults').val());
    const child = num($('#child').val());
    const extrabed = num($('#extrabed').val());
    const adult_price = num($('#adult_price').val());
    const child_price = num($('#child_price').val());
    const extra_bed_price = num($('#extra_bed_price').val());
    const transport = num($('#transport_charges').val());
    const discount = num($('#discount').val());
    const gstRate = num($('#gst').val());
    const gstIncluded = $('#gst_included').val();

    let total = (adults * adult_price) + (child * child_price) + (extrabed * extra_bed_price);
    total += transport;
    total -= (total * discount / 100);

    if (gstIncluded === 'yes') total += total * (gstRate / 100);

    $('#grand_total').val(total.toFixed(2));
  }

  $(document).on('input change', '#adults,#child,#extrabed,#adult_price,#child_price,#extra_bed_price,#transport_charges,#discount,#gst_included,#gst', calculateTotal);
  $(document).on('input change', '#hotelContainer input', calculateTotal);

  // =====================================
  // ðŸ’¾ Save / Update Form
  // =====================================
  const $form = $("#reference_quotation");
  const $saveBtn = $form.find("button[type='submit']");
  const quotationId = $("#id").val();
  const action = quotationId ? "Update" : "Create";

  $form.on("submit", function(e) {
    e.preventDefault();

    $("#desc_input").val(descriptionEditor.root.innerHTML);
    $("#incl_input").val(inclusionsEditor.root.innerHTML);
    $("#excl_input").val(exclusionsEditor.root.innerHTML);

    const formData = new FormData(this);
    formData.append("action", action);

    $.ajax({
      url: "controller/QuotationController.php",
      type: "POST",
      data: formData,
      processData: false,
      contentType: false,
      dataType: "json",
      beforeSend: function() {
        $saveBtn.prop("disabled", true).text("Saving...");
      },
      success: function(res) {
        $saveBtn.prop("disabled", false).text("Save");
        if (res.status === "success") {
          toastr.success(res.message);
          $("#id").val(res.id);
        } else {
          toastr.error(res.message);
        }
      },
      error: function(xhr) {
        $saveBtn.prop("disabled", false).text("Save");
        console.error(xhr.responseText);
        toastr.error("Server error while saving.");
      }
    });
  });

  // =====================================
  // ðŸ“„ Download PDF
  // =====================================
  $("#download-pdf").on("click", function() {
    const id = $("#id").val();
    if (!id) {
      toastr.warning("Please save quotation before downloading PDF.");
      return;
    }
    const $btn = $(this);
    $btn.prop("disabled", true).text("Generating...");
    window.open(`controller/QuotationPDFController.php?id=${id}`, "_blank");
    setTimeout(() => $btn.prop("disabled", false).text("Download PDF"), 2000);
  });
});
</script>



<?php include('inc/footer.php');?>