<?php include( 'inc/template.php' ); 
// Get Quotation ID
$quotation_id = isset($_GET['quotationid']) ? intval($_GET['quotationid']) : 0;

// Fetch Quotation Details
$sql = "
SELECT 
    q.*, 
    c.name AS customer_name, 
    c.phone AS customer_phone, 
    c.email AS customer_email, 
    c.address AS customer_address,
	p.package_name,
	pc.category_name,
    uq.name AS quotation_assigned_to_name,
    i.id AS inquiry_id,
    i.created_at, 
    i.source AS inquiry_source, 
    i.destination AS inquiry_destination, 
    i.package_start_date AS inquiry_travel_date, 
    i.package_adults AS inquiry_adults, 
    i.package_children AS inquiry_child, 
    i.inquiry_type, 
    i.remarks AS inquiry_remarks,
    i.status AS inquiry_status,
    i.last_followup_date AS inquiry_last_followup_date,
    ui.name AS inquiry_assigned_to_name
FROM quotations q
LEFT JOIN customers c ON q.customer_id = c.id
LEFT JOIN users uq ON q.assigned_to = uq.id
LEFT JOIN inquiries i ON q.inquiry_id = i.id
LEFT JOIN packages p ON q.package_id = p.id
LEFT JOIN package_categories pc ON q.category_id = pc.id
LEFT JOIN users ui ON i.assigned_to = ui.id
WHERE q.id = ?
";

$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $quotation_id);
$stmt->execute();
$result = $stmt->get_result();
$row = $result->fetch_assoc();

if (!$row) {
    echo "<div class='alert alert-danger'>Quotation not found.</div>";
    include('inc/footer.php');
    exit;
}
?>

<div class="container-fluid flex-grow-1 container-p-y">
    <nav aria-label="breadcrumb">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="index.php">Home</a></li>
            <li class="breadcrumb-item"><a href="quotation_list.php">Quotation List</a></li>
            <li class="breadcrumb-item active">Quotation Details</li>
        </ol>
    </nav>

    <div class="row">
        <div class="col-xl-12 col-lg-5 col-md-5">
            <div class="accordion mt-3" id="accordionExample">

                <!-- ===================== Quotation Details ===================== -->
                <div class="card accordion-item active">
                    <h2 class="accordion-header" id="headingOne">
                        <button type="button" class="accordion-button" data-bs-toggle="collapse" data-bs-target="#accordionOne" aria-expanded="true" aria-controls="accordionOne">
                            Quotation Details
                        </button>
                    </h2>

                    <div id="accordionOne" class="accordion-collapse collapse show" data-bs-parent="#accordionExample">
                        <div class="accordion-body">

                            <?php
                            $statusclass = match (strtolower($row['status'])) {
                                'pending' => 'bg-warning',
                                'accepted' => 'bg-success',
                                'rejected' => 'bg-danger',
                                'closed' => 'bg-secondary',
                                default => 'bg-info'
                            };
                            ?>

                            <div class="d-flex flex-wrap">
                                <div class="me-5">
                                    <p><i class="ti ti-calendar ti-sm me-2"></i>
                                        Quotation Date: <?= htmlspecialchars(date('d-m-Y', strtotime($row['quotation_date']))) ?>
                                    </p>
                                    <p><i class="ti ti-users ti-sm me-2"></i>
                                        Name: <?= htmlspecialchars(ucwords(strtolower($row['customer_name']))) ?>
                                    </p>
                                    <p><i class="ti ti-map-pin ti-sm me-2"></i>
                                        Address: <?= htmlspecialchars(ucwords(strtolower($row['customer_address']))) ?>
                                    </p>
                                    <p><i class="ti ti-phone-call ti-sm me-2"></i>
                                        Contact: +91 <?= htmlspecialchars($row['customer_phone']) ?>
                                    </p>
                                    <p><i class="ti ti-mail ti-sm me-2"></i>
                                        Email: <?= htmlspecialchars($row['customer_email']) ?>
                                    </p>
                                </div>

                                <div>
                                    <p><i class="ti ti-search ti-sm me-2"></i>
                                        Quotation No.: <?= htmlspecialchars($row['quotation_no']) ?>
                                    </p>
                                    <p><i class="ti ti-clock ti-sm me-2"></i>
                                        Status:
                                        <span class="badge <?= $statusclass ?> bg-glow">
                                            <?= htmlspecialchars(ucwords(strtolower($row['status'] ?? ''))) ?>
                                        </span>
                                    </p>
                                    <p><i class="ti ti-calendar ti-sm me-2"></i>
                                        Last Followup Date:
                                        <?= !empty($row['last_followup_date']) ? date('d-m-Y', strtotime($row['last_followup_date'])) : 'Not Followed Up'; ?>
                                    </p>
                                    <p><i class="ti ti-user ti-sm me-2"></i>
                                        Assigned To: <?= htmlspecialchars(ucwords(strtolower($row['quotation_assigned_to_name']))) ?>
                                    </p>
                                </div>
                            </div>

                            <h5 class="mt-4">Package Details</h5>
                            <div class="table-responsive text-nowrap">
                                <table class="table table-bordered table-sm">
                                    <tbody>
										 <tr>
                                            <td>Package Name</td>
                                            <td><?= htmlspecialchars(ucwords($row['package_name'])) ?>(<small><?= htmlspecialchars(ucwords($row['category_name'])) ?></small>)</td>
                                            <td>Category</td>
                                            <td><?= htmlspecialchars(ucwords($row['category_name'])) ?></td>
                                        </tr>
                                        
                                        <tr>
                                            <td>Travel Date</td>
                                            <td><?= htmlspecialchars(date('d-m-Y', strtotime($row['travel_date']))) ?></td>
                                            <td>No. of Nights</td>
                                            <td><?= htmlspecialchars($row['nights']) ?></td>
                                        </tr>
                                        <tr>
                                            <td>Total Rooms</td>
                                            <td><?= htmlspecialchars($row['rooms']) ?></td>
                                            <td>Guests (Adult/Child)</td>
                                            <td><?= htmlspecialchars($row['adults']) ?> Adults / <?= htmlspecialchars($row['child']) ?> Child</td>
                                        </tr>
                                        <tr>
                                            <td>Extra Bed</td>
                                            <td><?= htmlspecialchars($row['extrabed']) ?></td>
                                            <td></td>
                                            <td></td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>

                            <!-- ===================== Hotel Details ===================== -->
                            <h5 class="mt-4">Hotel Details</h5>
                            <div class="table-responsive text-nowrap">
                                <?php
                                $sqlHotels = "SELECT qh.*, h.hotel_name
              FROM quotation_hotels qh
              LEFT JOIN hotels h ON qh.hotel_id = h.id
              WHERE qh.quotation_id = ?";
                                $stmtHotels = $conn->prepare($sqlHotels);
                                $stmtHotels->bind_param("i", $quotation_id);
                                $stmtHotels->execute();
                                $resultHotels = $stmtHotels->get_result();
                                ?>
                                <table class="table table-bordered table-sm">
                                    <thead>
                                        <tr>
                                            <th>Hotel Name</th>
                                            <th>City</th>
                                            <th>Rooms</th>
                                            <th>Stars</th>
                                            <th>Meal Plan</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php while ($hotelrow = $resultHotels->fetch_assoc()): ?>
                                            <tr>
                                                <td><?= htmlspecialchars(ucwords($hotelrow['hotel_name'])) ?></td>
                                                <td><?= htmlspecialchars(ucwords($hotelrow['city'])) ?></td>
                                                <td><?= htmlspecialchars($hotelrow['rooms']) ?></td>
                                                <td><?= htmlspecialchars($hotelrow['stars']) ?></td>
                                                <td><?= htmlspecialchars($hotelrow['meal_plan']) ?></td>
                                            </tr>
                                        <?php endwhile; ?>
                                    </tbody>
                                </table>
                            </div>

                            <!-- ===================== Pricing Details ===================== -->
                            <h5 class="mt-4">Pricing Details</h5>
                            <div class="table-responsive text-nowrap">
                                <table class="table table-bordered table-sm">
                                    <tbody>
                                        <tr>
                                            <td>Adult Price (<?= $row['adults'] ?> × <?= $row['adult_price'] ?>)</td>
                                            <td><?= number_format((float)$row['adult_price'] * (int)$row['adults'], 2) ?></td>
                                        </tr>

                                        <?php if ($row['child'] > 0): ?>
                                        <tr>
                                            <td>Child Price (<?= $row['child'] ?> × <?= $row['child_price'] ?>)</td>
                                            <td><?= number_format((float)$row['child_price'] * (int)$row['child'], 2) ?></td>
                                        </tr>
                                        <?php endif; ?>

                                        <?php if ($row['extrabed'] > 0): ?>
                                        <tr>
                                            <td>Extra Bed (<?= $row['extrabed'] ?> × <?= $row['extra_bed_price'] ?>)</td>
                                            <td><?= number_format((float)$row['extra_bed_price'] * (int)$row['extrabed'], 2) ?></td>
                                        </tr>
                                        <?php endif; ?>

                                        <tr>
                                            <td><b>Sub Total</b></td>
                                            <td><b><?= number_format((float)$row['total_amount'], 2) ?></b></td>
                                        </tr>

                                        <?php if ($row['discount'] > 0): ?>
                                        <tr>
                                            <td>Discount (<?= $row['discount'] ?>%)</td>
                                            <td><?= number_format((float)$row['discount_amount'], 2) ?></td>
                                        </tr>
                                        <?php endif; ?>

                                        <?php if ($row['gst_included'] === 'yes'): ?>
                                        <tr>
                                            <td>GST (<?= $row['gst_rate'] ?>%)</td>
                                            <td><?= number_format((float)$row['gst_amount'], 2) ?></td>
                                        </tr>
                                        <?php endif; ?>

                                        <tr>
                                            <td><b>Grand Total</b></td>
                                            <td><b><?= number_format((float)$row['grand_total'], 2) ?></b></td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>

                            <h6>Description</h6>
<div><?= nl2br($row['remarks'] ?? '') ?></div>

<h6>Inclusions</h6>
<div><?= $row['inclusions'] ?? '' ?></div>

<h6>Exclusions</h6>
<div><?= $row['exclusions'] ?? '' ?></div>
                        </div>
                    </div>
                </div>

                <!-- ===================== Inquiry Details ===================== -->
                <div class="card accordion-item"> 
    <h2 class="accordion-header" id="headingTwo">
        <button type="button" class="accordion-button collapsed" data-bs-toggle="collapse" data-bs-target="#accordionTwo" aria-expanded="false" aria-controls="accordionTwo">
            Inquiry Details
        </button>
    </h2>

    <div id="accordionTwo" class="accordion-collapse collapse" data-bs-parent="#accordionExample">
        <div class="accordion-body">
            <?php
            $statusclass = match (strtolower($row['inquiry_status'] ?? '')) {
                'pending' => 'bg-warning',
                'in-progress' => 'bg-primary',
                'closed' => 'bg-secondary',
                default => 'bg-info'
            };
            ?>

            <div class="d-flex flex-wrap">
                <div class="me-5">
                    <p>
  <i class="ti ti-calendar ti-sm me-2"></i>
  Inquiry Date: 
  <?= !empty($row['created_at']) ? date('d-m-Y', strtotime($row['created_at'])) : 'N/A'; ?>
</p>

                    <p><i class="ti ti-map-pin ti-sm me-2"></i>Destination: <?= htmlspecialchars($row['inquiry_destination'] ?? '-') ?></p>
                    <p><i class="ti ti-calendar-check ti-sm me-2"></i>Travel Date: <?= !empty($row['inquiry_travel_date']) ? date('d-m-Y', strtotime($row['inquiry_travel_date'])) : '-' ?></p>
                    <p><i class="ti ti-users ti-sm me-2"></i>Adults: <?= htmlspecialchars($row['inquiry_adults'] ?? '-') ?></p>
                    <p><i class="ti ti-mood-boy ti-sm me-2"></i>Child: <?= htmlspecialchars($row['inquiry_child'] ?? '-') ?></p>
                </div>

                <div>
                    <p><i class="ti ti-building ti-sm me-2"></i>Hotel Type: <?= htmlspecialchars($row['hotel_type'] ?? '-') ?></p>
                    <p><i class="ti ti-search ti-sm me-2"></i>Source: <?= htmlspecialchars($row['inquiry_source'] ?? '-') ?></p>
                    <p><i class="ti ti-briefcase ti-sm me-2"></i>Inquiry Type: <?= htmlspecialchars($row['inquiry_type'] ?? '-') ?></p>
                    <p><i class="ti ti-clock ti-sm me-2"></i>Status: 
                        <span class="badge <?= $statusclass ?> bg-glow"><?= ucwords($row['inquiry_status'] ?? 'Unknown') ?></span>
                    </p>
                    <p><i class="ti ti-calendar ti-sm me-2"></i>Last Followup: 
                        <?= !empty($row['inquiry_last_followup_date']) ? date('d-m-Y', strtotime($row['inquiry_last_followup_date'])) : 'Not Followed Up'; ?>
                    </p>
                    <p><i class="ti ti-user ti-sm me-2"></i>Assigned To: <?= htmlspecialchars($row['inquiry_assigned_to_name'] ?? '-') ?></p>
                </div>
            </div>

            <h6>Remarks</h6>
            <p><?= nl2br(htmlspecialchars($row['inquiry_remarks'] ?? 'No remarks')) ?></p>
        </div>
    </div>
</div>


            </div> <!-- Accordion -->
        </div>
    </div>
</div>

<?php include('inc/footer.php'); ?>