<?php include('inc/template.php');?>

<div class="container-fluid flex-grow-1 container-p-y">
<nav aria-label="breadcrumb">
	<ol class="breadcrumb">
    <li class="breadcrumb-item"><a href="index.php">Home</a></li>
    <li class="breadcrumb-item active">Package Categories</li>
    </ol>
</nav>
    <button type="button" class="btn btn-sm btn-primary" data-bs-toggle="modal" data-bs-target="#basicModal">
        <span class="ti-xs ti ti-plus me-1"></span> Add Packag Category
    </button>
    <div class="row mb-4">
                <!--  Modal -->
        <div class="modal fade" id="basicModal" tabindex="-1" aria-labelledby="basicModalLabel" aria-hidden="true">
            <div class="modal-dialog modal-lg">
                <div class="modal-content">
                    <form id="categoryForm">
    <div class="modal-header">
        <h5 class="modal-title" id="basicModalLabel">Add/Edit Package Category</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
    </div>
    <div class="modal-body">
        <div class="mb-3">
            <label for="category_name" class="form-label">Package Category</label>
            <input type="text" id="category_name" name="category_name" class="form-control" placeholder="Enter Category Name" required />
        </div>
    </div>
    <div class="modal-footer">
        <input type="hidden" id="id" name="id" />
        <input type="hidden" id="action" name="action" value="Create" />
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
        <button type="submit" class="btn btn-primary">Save</button>
    </div>
</form>

                </div>
            </div>
        </div>

        <!-- Users Table -->
        <div class="col-xl-12 col-lg-6 col-md-6">
            <div class="card">
                <div class="card-datatable table-responsive pt-0">
                    <table class="datatables-ajax table table-bordered table-responsive">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Packag Category</th>
                                 <th>Status</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
							$n = 0;
                            $result = mysqli_query($conn, "SELECT * FROM package_categories ORDER BY id ASC");
                            while ($row = mysqli_fetch_array($result)) {
							$n++;
                            ?>
                            <tr class="showtr">
                                <td><?php echo htmlspecialchars($n); ?></td>
                                <td><?php echo htmlspecialchars($row['category_name']); ?></td>
                               							
                                <td>
                                    <label class="switch">
                                        <input type="checkbox" class="switch-input" value="<?php echo $row[0]; ?>"
                                               <?php if ($row['status'] == 'active') echo "checked"; ?>
                                               onClick="statusChange(this.value);" />
                                        <span class="switch-toggle-slider">
                                            <span class="switch-on"></span>
                                            <span class="switch-off"></span>
                                        </span>
                                    </label>
                                </td>
                                <td>
									
									<button type="button" id="<?php echo $row[0]; ?>" class="btn btn-xs btn-warning update"><i class="far fa-edit"></i></button>
                   				 <button type="button" id="<?php echo $row[0]; ?>" class="btn btn-xs btn-danger delete"><i class="far fa-trash-alt"></i></button>
                                   
                                </td>
                            </tr>
                            <?php } ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
$(document).ready(function () {

    // Show modal for Create
    $('#basicModal').on('show.bs.modal', function () {
        $('#categoryForm')[0].reset();
        $('#action').val('Create');
        $('#id').val('');
        $('.modal-title').text('Add Package Category');
    });

    // Submit form for Create/Update
    $('#categoryForm').on('submit', function (e) {
        e.preventDefault();
        $.ajax({
            url: 'controller/PackageCategoryController.php',
            type: 'POST',
            data: $(this).serialize(),
            dataType: 'json',
            success: function (res) {
                if (res.status === 'success') {
                    toastr.success(res.message);
                    $('#basicModal').modal('hide');
                    setTimeout(() => location.reload(), 500);
                } else {
                    toastr.error(res.message);
                }
            },
            error: function () {
                toastr.error('Error processing request.');
            }
        });
    });

   $(document).on('click', '.update', function () {
    const id = $(this).attr('id');

    $.post('controller/PackageCategoryController.php', { id: id, action: 'Select' }, function (res) {
        if (res.status === 'success') {
            // Set hidden inputs immediately
            $('#id').val(res.data.id);
            $('#action').val('Update');

            // Show modal first
            $('#basicModal').modal('show');

            // Populate visible input AFTER modal is fully shown
            $('#basicModal').off('shown.bs.modal').on('shown.bs.modal', function () {
                $('#category_name').val(res.data.category_name);
                $('.modal-title').text('Edit Package Category');
            });
        } else {
            toastr.error(res.message);
        }
    }, 'json');
});





    // Toggle Status
    window.statusChange = function (id) {
        $.post('controller/PackageCategoryController.php', { id: id, action: 'ToggleStatus' }, function (res) {
            if (res.status === 'success') {
                toastr.success(`Status changed to ${res.new_status}`);
            } else {
                toastr.error(res.message);
            }
        }, 'json');
    };

    // Delete
    $(document).on('click', '.delete', function () {
        const id = $(this).attr('id');
        if (confirm('Are you sure to delete this category?')) {
            $.post('controller/PackageCategoryController.php', { id: id, action: 'Delete' }, function (res) {
                if (res.status === 'success') location.reload();
                else toastr.error(res.message);
            }, 'json');
        }
    });

});

</script>


<?php include('inc/footer.php');?>