<?php include( 'inc/template.php' );?>
<div class="container-fluid flex-grow-1 container-p-y">
	<nav aria-label="breadcrumb">
	<ol class="breadcrumb">
    <li class="breadcrumb-item"><a href="index.php">Home</a></li>
	<li class="breadcrumb-item"><a href="packages_add.php">Package Add</a></li>
    <li class="breadcrumb-item">Package List</li>
    </ol>
</nav>
<div class="card">
<div class="card-datatable table-responsive pt-0">
<table class="datatables-ajax table table-bordered table-responsive">
    <thead>
        <tr>
           
            
			<th>Package Code</th>
            <th>Package Name</th>
            <th>Day/Night</th>
            <th>Destination</th>
            <th>Status</th>
            <th>Action</th>
        </tr>
    </thead>
    <tbody>
        <?php
        $result = mysqli_query($conn, "SELECT * FROM packages ORDER BY destination ASC");
        while ($row = mysqli_fetch_assoc($result)) {
        ?>
            <tr class="showtr">
                <td><?php echo htmlspecialchars($row['package_code']); ?></td>	
                <td><?php echo ucwords(htmlspecialchars($row['package_name'])); ?></td>
				<td><?php echo (int)$row['days']; ?>D / <?php echo (int)$row['nights']; ?>N</td>
				<td><?php echo ucwords(htmlspecialchars($row['destination'])); ?></td>
                <td class="text-center">
                    <label class="switch">
                        <input type="checkbox" class="switch-input" value="<?php echo (int)$row['id']; ?>"
                            <?php if ($row['status'] === 'active') echo 'checked'; ?>
                            onclick="statusChange(this.value);">
                        <span class="switch-toggle-slider">
                            <span class="switch-on"></span>
                            <span class="switch-off"></span>
                        </span>
                    </label>
                </td>
                <td class="text-center">
                   <button 
    type="button" 
    class="btn btn-sm btn-warning" 
    onclick="location.href='packages_add.php?id=<?php echo (int)$row['id']; ?>'">
    <i class="far fa-edit"></i>
</button>

                    <button type="button" class="btn btn-sm btn-danger delete" id="<?php echo (int)$row['id']; ?>">
                        <i class="far fa-trash-alt"></i>
                    </button>
                </td>
            </tr>
        <?php } ?>
    </tbody>
</table>

</div>
</div>
</div>
<script>
$(document).ready(function () {
     // Status change
    window.statusChange = function (id) {
        $.ajax({
            url: 'controller/PackagesController.php',
            method: 'POST',
            data: { id: id, action: 'ToggleStatus' },
            dataType: "json",
            success: function (response) {
                if (response.status === 'success') {
                    const newStatus = response.new_status === "active" ? "Active" : "Inactive";
                    toastr.success(`Status changed to ${newStatus}`);
                } else {
                    toastr.error(response.message);
                }
            },
            error: function () {
                toastr.error('Failed to update status.');
            }
        });
    };
	
	// Delete user
    $(document).on('click', '.delete', function () {
        const id = $(this).attr("id");
        const row = $(this).closest('tr');

        if (confirm('Are you sure you want to delete this admin?')) {
            $.ajax({
                url: 'controller/PackagesController.php',
                method: 'POST',
                data: { id: id, action: 'Delete' },
                dataType: "json",
                success: function (response) {
                    if (response.status === 'success') {
                        toastr.success(response.message);
                        row.css('background-color', '#f8d7da').fadeOut(800, function () {
                            $(this).remove();
                        });
                    } else {
                        toastr.error(response.message);
                    }
                },
                error: function () {
                    toastr.error('Error deleting user.');
                }
            });
        }
    });
   

});

</script>
<?php include('inc/footer.php');?>