<?php include( 'inc/template.php' );?>
<div class="container-fluid flex-grow-1 container-p-y">
	<?php include('package_categorywise_header.php');?>
	
	

<div class="accordion shadow-sm rounded-3" id="accordionBooking">

        <!-- BOOKING SUMMARY -->
        <div class="card accordion-item border-0 mb-3 shadow-sm">
          <h2 class="accordion-header" id="headingBooking">
            <button class="accordion-button fw-semibold" type="button" data-bs-toggle="collapse" data-bs-target="#collapseBooking" aria-expanded="true">
              <i class="ti ti-briefcase me-2 text-primary"></i> Package Summary
            </button>
          </h2>
          <div id="collapseBooking" class="accordion-collapse collapse show" data-bs-parent="#accordionBooking">
            <div class="accordion-body">
              <div class="row">
                <!-- PACKAGE & CATEGORY DETAILS TABLE -->
    
	<?php if ($package): ?>
    <div class="table-responsive">
      <table class="table table-bordered table-striped align-middle">
        <thead class="table-light">
          <tr>
            <th>Field</th>
            <th>Value</th>
          </tr>
        </thead>
        <tbody>
		  <tr>
            <td>Package Code</td>
            <td><?= htmlspecialchars($package['package_code']) ?></td>
          </tr>
          <tr>
            <td>Package Name</td>
            <td><?= htmlspecialchars($package['package_name']) ?></td>
          </tr>
          <tr>
            <td>Destination</td>
            <td><?= htmlspecialchars($package['destination']) ?></td>
          </tr>
          <tr>
            <td>Days / Nights</td>
            <td><?= $package['days'] ?> / <?= $package['nights'] ?></td>
          </tr>
          
          <tr>
            <td>Category Name</td>
            <td><?= htmlspecialchars($package['category_name']) ?></td>
          </tr>
          <tr>
            <td>Purchase Price</td>
            <td>₹<?= number_format($package['category_purchase_price'],2) ?></td>
          </tr>
          <tr>
            <td>Sale Price</td>
            <td>₹<?= number_format($package['category_sale_price'],2) ?></td>
          </tr>
          <tr>
            <td>Status</td>
            <td><?= ucfirst($package['category_status']) ?></td>
          </tr>
          <tr>
            <td>Created At</td>
            <td><?= !empty($package['category_created_at']) ? date('d-m-Y h:i A', strtotime($package['category_created_at'])) : '-' ?></td>
          </tr>
          
        </tbody>
      </table>
    </div>
				 <?php else: ?>
<p>No package found.</p>
<?php endif; ?>

              
              </div>
            </div>

            
            
          </div>
        </div>

        <!-- POLICIES -->
        <div class="card accordion-item border-0 shadow-sm">
          <h2 class="accordion-header" id="headingDescription">
            <button class="accordion-button collapsed fw-semibold" type="button" data-bs-toggle="collapse" data-bs-target="#collapseDescription">
              Description
            </button>
          </h2>
          <div id="collapseDescription" class="accordion-collapse collapse" data-bs-parent="#accordionBooking">
            <div class="accordion-body">
              <p><?= nl2br(htmlspecialchars($hotel['description'] ?? '')) ?></p>
              
            </div>
          </div>
        </div>
	<div class="card accordion-item border-0 shadow-sm">
          <h2 class="accordion-header" id="headingInclusions">
            <button class="accordion-button collapsed fw-semibold" type="button" data-bs-toggle="collapse" data-bs-target="#collapseInclusions">
               Inclusions
            </button>
          </h2>
          <div id="collapseInclusions" class="accordion-collapse collapse" data-bs-parent="#accordionBooking">
            <div class="accordion-body">
              <p><?= nl2br(htmlspecialchars($hotel['inclusions'] ?? '')) ?></p>
              
            </div>
          </div>
        </div>
	<div class="card accordion-item border-0 shadow-sm">
          <h2 class="accordion-header" id="headingExclusions">
            <button class="accordion-button collapsed fw-semibold" type="button" data-bs-toggle="collapse" data-bs-target="#collapseExclusions">
              Exclusions
            </button>
          </h2>
          <div id="collapseExclusions" class="accordion-collapse collapse" data-bs-parent="#accordionBooking">
            <div class="accordion-body">
              <p><?= nl2br(htmlspecialchars($hotel['exclusions'] ?? '')) ?></p>
              
            </div>
          </div>
        </div>

      </div>
<?php include('inc/footer.php');?>