<?php 
ini_set('display_errors', '1');
ini_set('display_startup_errors', '1');
error_reporting(E_ALL);
include('inc/template.php');?>
	<div class="container-xxl flex-grow-1 container-p-y">
		<?php include('package_categorywise_header.php');?>
		<button type="button" class="btn btn-sm rounded-pill btn-primary" data-bs-toggle="modal" data-bs-target="#hotelModal"><i class="ti ti-plus me-sm-1"></i>Add Hotel</button>
		<div class="card mb-6">
			
                    <div class="table-responsive mb-4">
						
                      <table class="datatables-ajax table table-bordered">
  <thead>
    <tr>
      <th>Hotel Name</th>
      <th>City</th>
      <th>Status</th>
      <th>Action</th>
    </tr>
  </thead>
  <tbody></tbody>
</table>

                    </div>
                  </div>
		
		<div class="modal fade" id="hotelModal" tabindex="-1" aria-hidden="true">
			<div class="modal-dialog modal-lg">
				<form id="hotelForm" method="post" enctype="multipart/form-data">
					<div class="modal-content">
						<div class="modal-header">
							<h5 class="modal-title">Add/Edit Package Hotel</h5>
							<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
						</div>
						<div class="modal-body">
							
							<div class="row mb-3">
								<!-- User ID (hidden) -->
        <input type="hidden" name="package_id" id="package_id" value="<?php echo $package_id ?>">
		<input type="hidden" name="category_id" id="category_id" value="<?php echo $category_id ?>">
		<input type="hidden" name="state_id" id="state_id" value="<?php echo $destination_id ?>">
		
		<div class="col-md-12 mb-3">
            <label class="form-label">Category</label>
            <input type="text" class="form-control" value="<?= htmlspecialchars($package['category_name']) ?>" readonly/>

        </div>
        <!-- Document Type -->
        <div class="col-md-12 mb-3">
            <label class="form-label">Hotel City</label>
            <select id="city_id" name="city_id" class="form-select select2" required>
				<option value="">Select city</option>
				<?php
				// Make sure $conn is your active MySQLi connection

				$query = "SELECT id, city_name FROM cities WHERE state_id = '$destination_id' AND status='1' ORDER BY city_name ASC";
				$destinations = mysqli_query($conn, $query);

				if($destinations && mysqli_num_rows($destinations) > 0){
					while ($d = mysqli_fetch_assoc($destinations)) {
						echo "<option value='{$d['id']}'>{$d['city_name']}</option>";
					}
				} else {
					echo "<option value=''>No cities found</option>";
				}
				?>
			</select>

        </div>

<div class="col-md-12 mb-3">
    <label class="form-label">Hotel Name</label>
    <select id="hotel_id" name="hotel_id" class="form-select select2" required>
        <option value="">Select hotel</option>
        <!-- Options will be populated by AJAX -->
    </select>
</div>
							</div>


						</div>
						<div class="modal-footer">
							<button type="submit" class="btn btn-primary">Save</button>
							<button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
						</div>
					</div>
				</form>
			</div>
		</div>

	</div>
<script>
$(document).ready(function () {

    // ✅ Destroy existing DataTable to prevent reinit errors
    if ($.fn.DataTable.isDataTable('.datatables-ajax')) {
        $('.datatables-ajax').DataTable().destroy();
    }

    // ✅ Initialize DataTable
    const hotelTable = $('.datatables-ajax').DataTable({
        processing: true,
        serverSide: false,
        ajax: {
            url: 'controller/HotelController.php',
            type: 'POST',
            data: { action: 'listPackageHotel' },
            dataSrc: function (json) {
                if (json && json.data) return json.data;
                console.error("Invalid DataTable JSON:", json);
                toastr.error("Invalid data received from server.");
                return [];
            },
            error: function (xhr) {
                console.error("DataTable Load Error:", xhr.responseText);
                toastr.error("Failed to load hotels. Check console for details.");
            }
        },
        columns: [
            { data: 'hotel_name', title: 'Hotel Name' },
            { data: 'city_name', title: 'City' },
            { data: 'status', title: 'Status', orderable: false, searchable: false },
            { data: 'actions', title: 'Action', orderable: false, searchable: false }
        ],
        order: [[0, 'asc']]
    }); // 🧩 <-- You were missing this closing brace

    // ✅ Initialize Select2 inside Modal
    $('#city_id, #hotel_id').select2({ dropdownParent: $('#hotelModal') });

    // ✅ Load Hotels When City Changes
    $('#city_id').on('change', function () {
        const city_id = $(this).val();
        if (city_id) {
            $.post('ajax/fetch_hotels.php', { city_id }, function (data) {
                $('#hotel_id').html(data).trigger('change');
            }).fail(() => {
                $('#hotel_id').html('<option value="">Error loading hotels</option>');
            });
        } else {
            $('#hotel_id').html('<option value="">Select hotel</option>');
        }
    });

    // ✅ Save / Update Package Hotel
    $('#hotelForm').on('submit', function (e) {
        e.preventDefault();
        const formData = new FormData(this);
        formData.append('action', 'savePackageHotel');

        $.ajax({
            url: 'controller/HotelController.php',
            type: 'POST',
            data: formData,
            processData: false,
            contentType: false,
            dataType: 'json', // ✅ Expect JSON
            beforeSend: function () {
                $('#hotelForm button[type="submit"]').prop('disabled', true)
                    .html('<i class="fas fa-spinner fa-spin me-1"></i> Saving...');
            },
            success: function (result) {
                if (result.status === 'success') {
                    toastr.success(result.message);
                    $('#hotelModal').modal('hide');
                    $('#hotelForm')[0].reset();
                    $('#city_id, #hotel_id').val('').trigger('change');
                    hotelTable.ajax.reload(null, false);
                } else {
                    toastr.error(result.message);
                }
            },
            error: function (xhr) {
                console.error("AJAX Error:", xhr.responseText);
                toastr.error("Server error. Try again later.");
            },
            complete: function () {
                $('#hotelForm button[type="submit"]').prop('disabled', false).html('Save');
            }
        });
    });

    // ✅ Edit Hotel
    $(document).on('click', '.editHotel', function () {
        const id = $(this).data('id');

        $.ajax({
            url: 'controller/HotelController.php',
            type: 'POST',
            data: { action: 'getPackageHotel', id },
            dataType: 'json',
            success: function (json) {
                if (json.status !== 'success' || !json.data) {
                    toastr.error(json.message || 'Error fetching record');
                    return;
                }

                const data = json.data;
                $('#package_id').val(data.package_id);
                $('#category_id').val(data.category_id);
                $('#state_id').val(data.state_id);
                $('#city_id').val(data.city_id).trigger('change');

                setTimeout(() => {
                    $('#hotel_id').val(data.hotel_id).trigger('change');
                }, 500);

                $('#hotelModal').modal('show');
            },
            error: function (xhr) {
                console.error("AJAX Error:", xhr.responseText);
                toastr.error("Error fetching record.");
            }
        });
    });

    // ✅ Toggle Status
    window.statusChange = function (id) {
        $.post('controller/HotelController.php', { id, action: 'ToggleStatusPackageHotel' }, function (res) {
            if (res.status === 'success') {
                toastr.success("Status changed successfully");
                hotelTable.ajax.reload(null, false);
            } else {
                toastr.error(res.message);
            }
        }, 'json').fail(() => toastr.error("Failed to update status."));
    };

    // ✅ Delete Record
$(document).on('click', '.deleteHotel', function () {
    const id = $(this).data('id');

    if (!id) {
        toastr.error("Invalid hotel ID.");
        return;
    }

    if (confirm("Are you sure you want to delete this hotel?")) {
        $.ajax({
            url: 'controller/HotelController.php',
            type: 'POST',
            data: { id: id, action: 'deletePackageHotel' },
            dataType: 'json', // ✅ automatically parses JSON
            success: function (res) {
                if (res.status === 'success') {
                    toastr.success(res.message);
                    hotelTable.ajax.reload(null, false);
                } else {
                    toastr.error(res.message || "Failed to delete hotel.");
                }
            },
            error: function (xhr) {
                console.error("AJAX Error:", xhr.responseText);
                toastr.error("Server error. Please try again.");
            }
        });
    }
});


    // ✅ Reset modal on close
    $('#hotelModal').on('hidden.bs.modal', function () {
        $('#hotelForm')[0].reset();
        $('#city_id, #hotel_id').val('').trigger('change');
    });

});
</script>

<?php include('inc/footer.php');?>