<?php include( 'inc/template.php' );?>
<div class="container-fluid flex-grow-1 container-p-y">
	<nav aria-label="breadcrumb">
	<ol class="breadcrumb">
    <li class="breadcrumb-item"><a href="index.php">Home</a></li>
	<li class="breadcrumb-item"><a href="package_booking_list.php">Package Booking List</a></li>
    <li class="breadcrumb-item active"><?php echo isset($_GET['id']) ? 'Update Package Booking' : 'Package Booking Add'; ?></li>
    </ol>
</nav>
	<ul class="nav nav-tabs mb-3" role="tablist">
  <li class="nav-item" role="presentation">
    <button 
      class="nav-link <?php echo (basename($_SERVER['PHP_SELF']) == 'package_booking_add.php') ? 'active' : ''; ?>" 
      type="button" 
      role="tab" 
      onclick="window.location.href='package_booking_add.php'">
      Package Booking
    </button>
  </li>
  
  <li class="nav-item" role="presentation">
    <button 
      class="nav-link <?php echo (basename($_SERVER['PHP_SELF']) == 'custome_booking_add.php') ? 'active' : ''; ?>" 
      type="button" 
      role="tab" 
      onclick="window.location.href='custome_booking_add.php'">
      Custom Booking
    </button>
  </li>
</ul>

<div class="row">
<div class="col-9">
<div class="card shadow p-4">
<form method="post" enctype="multipart/form-data">
  <!-- Customer & Destination Row -->
  <div class="row g-3">
    <div class="col-md-6">
  <label for="customer_id" class="form-label">Customer Name</label>
  <input type="hidden" id="inquiry_id" name="inquiry_id" />

  <select name="customer_id" id="customer_id" required class="select2 form-select form-select-lg">
    <option value="">Select Customer</option>

    <!-- In-Progress Inquiry Customers -->
    <optgroup label="In-Progress Inquiries">
      <?php
      $inProgress = $conn->query("
        SELECT 
          c.id AS customer_id,
          c.name,
          c.phone,
          i.id AS inquiry_id
        FROM customers c
        INNER JOIN inquiries i 
          ON c.id = i.customer_id 
          AND i.inquiry_type = 'package'
          AND i.status = 'in-progress'
        WHERE c.status = 'active'
        ORDER BY c.name ASC
      ");
      if ($inProgress->num_rows > 0) {
        while ($row = $inProgress->fetch_assoc()) {
          echo '<option value="' . $row['customer_id'] . '" data-inquiry="' . $row['inquiry_id'] . '">'
             . htmlspecialchars(ucwords(strtolower($row['name']))) . ' (' . $row['phone'] . ')'
             . '</option>';
        }
      } else {
        echo '<option disabled>No in-progress inquiries</option>';
      }
      ?>
    </optgroup>

    <!-- Other Customers (no in-progress inquiry) -->
    <optgroup label="Other Customers">
      <?php
      $others = $conn->query("
        SELECT 
          c.id AS customer_id,
          c.name,
          c.phone
        FROM customers c
        WHERE c.status = 'active'
          AND c.id NOT IN (
            SELECT customer_id 
            FROM inquiries 
            WHERE status = 'in-progress' 
              AND inquiry_type = 'package'
          )
        ORDER BY c.name ASC
      ");
      if ($others->num_rows > 0) {
        while ($row = $others->fetch_assoc()) {
          echo '<option value="' . $row['customer_id'] . '" data-inquiry="">'
             . htmlspecialchars(ucwords(strtolower($row['name']))) . ' (' . $row['phone'] . ')'
             . '</option>';
        }
      } else {
        echo '<option disabled>All customers have in-progress inquiries</option>';
      }
      ?>
    </optgroup>
  </select>
</div>

<script>
$(document).ready(function(){
  $('#customer_id').on('change', function(){
    let inquiryId = $(this).find(':selected').data('inquiry') || '';
    $('#inquiry_id').val(inquiryId);
  });
});
</script>

	

    <div class="col-md-6">
      <label for="state_id" class="form-label">Destination Name</label>
      <select id="state_id" name="state_id" class="form-select select2" required>
        <option value="">Select Destination</option>
        <?php
          $destinations = mysqli_query($conn, "SELECT id, state_name FROM states WHERE status='1' ORDER BY state_name ASC");
          while ($d = mysqli_fetch_assoc($destinations)) {
            echo "<option value='{$d['id']}'>{$d['state_name']}</option>";
          }
        ?>
      </select>
    </div>

    <div class="col-md-6">
      <label for="package_id" class="form-label">Package Name</label>
      <select id="package_id" name="package_id" class="form-select" required>
        <option value="">Select Package</option>
      </select>
    </div>

    <div class="col-md-6">
      <label for="category_id" class="form-label">Category Name</label>
      <select name="category_id" id="category_id" required class="form-select">
        <option value="">Select Category</option>
        
      </select>
    </div>

    <div class="col-md-3">
      <label for="package_start_date" class="form-label">Start Travel Date</label>
      <input type="date" id="package_start_date" name="package_start_date" class="form-control" required min="<?= date('Y-m-d'); ?>"/>
      <input type="hidden" id="booking_type" name="booking_type" value="package" />
		
    </div>
	  
	<div class="col-md-3">
      <label for="package_start_date" class="form-label">End Travel Date</label>
      <input type="date" id="package_end_date" name="package_end_date" class="form-control" required min="<?= date('Y-m-d'); ?>"/>
      
		
    </div>
	<div class="col-md-3">
							<label for="rooms" class="form-label">Meal Type</label>
							<select name="meal_plan[]" data-name="meal_plan" class="form-select" required>
								<option value="">Select</option>
								<option value="CP">CP (Room + Breakfast)</option>
								<option value="MAP">MAP (Room + Breakfast + Dinner)</option>
								<option value="AP">AP (Room + All Meals)</option>
							</select>
						</div>
	  <div class="col-md-3">
  <label for="accommodation_type" class="form-label">Preferred Accommodation</label>
  <select name="accommodation_type" id="accommodation_type" class="form-select" required>
    <option value="">Select Accommodation</option>
    <option value="hotel">Hotel</option>
    <option value="villa">Villa</option>
    <option value="apartment">Apartment</option>
    <option value="resort">Resort</option>
    <option value="homestay">Homestay</option>
    <option value="hostel">Hostel</option>
  </select>
</div>

<div class="col-md-6">
  <label for="room_type" class="form-label">Room Type</label>
  <select name="room_type" id="room_type" class="form-select" required>
    <option value="">Select Room Type</option>
    <option value="single">Single</option>
    <option value="double">Double</option>
    <option value="twin">Twin</option>
    <option value="family">Family</option>
    <option value="suite">Suite</option>
    <option value="deluxe">Deluxe</option>
  </select>
</div>


   <!-- <div class="col-md-2">
      <label for="rooms" class="form-label">No. of Rooms</label>
      <input type="number" id="rooms" name="rooms" min="1" max="100" value="1" class="form-control" />
    </div>
	<div class="col-md-2">
      <label for="nights" class="form-label">No. of Night</label>
      <input type="number" id="nights" name="nights" min="1" max="100" value="1" class="form-control" />
    </div>-->
	  <div class="col-md-6">
      <label for="nights" class="form-label">Special Request</label>
      <textarea class="form-control" id="special_request" name="special_request"></textarea>
    </div>
  </div>

  <!-- Pricing -->
  <div class="row g-3 mt-2">
    <h5>Package Pricing (Per Person)</h5>
    <div class="col-md-4">
      <label for="adults" class="form-label">Adults</label>
      <input type="number" id="adults" name="adults" min="1" max="100" value="1" class="form-control" />
    </div>
    <div class="col-md-4">
      <label for="child" class="form-label">Child</label>
      <input type="number" id="child" name="child" min="0" max="100" value="0" class="form-control" />
    </div>
    <div class="col-md-4">
      <label for="extrabed" class="form-label">Extra Bed</label>
      <input type="number" id="extrabed" name="extrabed" min="0" max="100" value="0" class="form-control" />
    </div>

    <div class="col-md-4">
      <label>Adult Price (INR)</label>
      <input type="number" name="adult_price" id="adult_price" value="0" class="form-control" required>
    </div>
    <div class="col-md-4">
      <label>Child Price (INR)</label>
      <input type="number" name="child_price" id="child_price" value="0" class="form-control" required>
    </div>
    <div class="col-md-4">
      <label>Extra Bed Price (INR)</label>
      <input type="number" name="extra_bed_price" id="extra_bed_price" value="0" class="form-control" required>
    </div>
  </div>


  <!-- Other Charges -->
  <div class="row g-3 mt-2">
    <h5>Other Charges</h5>
    <div class="col-md-3">
      <label>Transport Type</label>
      <select name="transport_type" id="transport_type" class="form-select">
        <option value="">Select Vehicle</option>
        <?php
          $query = "SELECT id, vehicle_type FROM vehicles WHERE status='active' ORDER BY id ASC";
          $result = mysqli_query($conn, $query);
          while ($r = mysqli_fetch_assoc($result)) {
            echo "<option value='{$r['vehicle_type']}'>{$r['vehicle_type']}</option>";
          }
        ?>
      </select>
    </div>

    <div class="col-md-3">
      <label>Transport Charges (INR)</label>
      <input type="number" name="transport_charges" id="transport_charges" class="form-control" value="0">
    </div>

    <div class="col-md-3">
      <label for="gst_included" class="form-label">With GST?</label>
      <select id="gst_included" name="gst_included" class="form-select" required>
       <!-- <option value="no">No</option>-->
        <option value="yes">Yes</option>
      </select>
    </div>

    <input type="hidden" name="gst" id="gst" class="form-control" value="5">

    <div class="col-md-3">
      <label>Discount %</label>
      <input type="number" name="discount" id="discount" class="form-control" value="0">
    </div>

    <div class="col-md-6">
      <label>Grand Total (INR)</label>
      <input type="text" name="grand_total" id="grand_total" class="form-control" readonly>
    </div>
	 
  </div>
	<div class="row g-3 mt-2">
						<!-- Payment Mode -->
						<div class="col-md-4">
							<label for="payment_mode" class="form-label">Payment Mode</label>
							<select name="payment_mode" id="payment_mode" class="form-select" required>
								<option value="">Select Mode</option>
								<option value="cash">Cash</option>
								<option value="upi">UPI</option>
								<option value="bank">Bank Transfer</option>
								<option value="card">Card</option>
								<option value="online">Online</option>
							</select>
						</div>

						<!-- UPI Details -->
						<div class="col-md-4" id="upi_details_group" style="display:none;">
							<label for="upi_id" class="form-label">UPI ID</label>
							<input type="text" name="upi_id" id="upi_id" class="form-control" placeholder="e.g. username@upi">
						</div>

						<!-- Bank Details -->
						<div class="col-md-4" id="bank_details_group" style="display:none;">
							<label for="bank_name" class="form-label">Bank Name</label>
							<input type="text" name="bank_name" id="bank_name" class="form-control" placeholder="Bank Name">
						</div>

						<div class="col-md-4" id="account_no_group" style="display:none;">
							<label for="account_no" class="form-label">Account / Cheque No</label>
							<input type="text" name="account_no" id="account_no" class="form-control" placeholder="Account or Cheque Number">
						</div>

						<div class="col-md-4" id="transaction_id_group" style="display:none;">
							<label for="transaction_id" class="form-label">Transaction / Reference ID</label>
							<input type="text" name="transaction_id" id="transaction_id" class="form-control" placeholder="Transaction ID">
						</div>

						<!-- Advance Payment -->
						<div class="col-md-4" id="advance_payment_group" style="display:none;">
							<label for="advance_payment" class="form-label">Advance Payment (INR)</label>
							<input type="number" name="advance_payment" id="advance_payment" class="form-control" min="1" placeholder="Enter amount">
						</div>
					</div>

  <!-- Description/Inclusions/Exclusions -->
  

  <!-- Hidden Fields & submit -->
  <input type="hidden" name="useridnew" id="useridnew" value="<?php echo $userId; ?>" />
  <input type="hidden" name="id" id="id" value="<?php echo isset($_GET['id']) ? $_GET['id'] : ''; ?>" />
  <input type="hidden" name="action" value="<?php echo isset($_GET['id']) ? 'Update' : 'Create'; ?>" />

  <div class="mt-4">
    <button type="submit" class="btn btn-primary me-2">Save</button>
    <button type="button" id="download-pdf" class="btn btn-primary me-2">Download PDF</button>
    <button type="reset" class="btn btn-secondary">Reset</button>
  </div>
</form>
</div>
</div>
<div class="col-3">
  <div class="card shadow p-4 sticky-card">
    <h5>Inquiry Detail</h5>
    <div class="row g-3">
      <div class="col-md-12">
        <label class="form-label">Package Name</label>
        <input type="text" id="package_name" name="package_name" class="form-control" readonly>
      </div>

      <div class="col-md-12">
        <label class="form-label">Start Date</label>
        <input type="text" id="start_date" name="start_date" class="form-control" readonly>
      </div>

      <div class="col-md-12">
        <label class="form-label">End Date</label>
        <input type="text" id="end_date" name="end_date" class="form-control" readonly>
      </div>

      <div class="col-md-12">
        <label class="form-label">Adult</label>
        <input type="text" id="padults" name="adults" class="form-control" readonly>
      </div>

      <div class="col-md-12">
        <label class="form-label">Children</label>
        <input type="text" id="pchildren" name="children" class="form-control" readonly>
      </div>

      <div class="col-md-12">
        <label class="form-label">Special Requests</label>
        <textarea id="package_requests" name="package_requests" class="form-control" rows="4" readonly></textarea>
      </div>
    </div>
  </div>
</div>

</div>
</div>
<script>
						$( document ).ready( function () {
							$( '#payment_mode' ).on( 'change', function () {
								const mode = $( this ).val();

								// Hide all optional sections first
								$( '#upi_details_group, #bank_details_group, #account_no_group, #transaction_id_group, #advance_payment_group' ).hide();

								// Remove required from all
								$( '#upi_id, #bank_name, #account_no, #transaction_id, #advance_payment' ).prop( 'required', false );

								// Clear old values
								$( '#upi_id, #bank_name, #account_no, #transaction_id, #advance_payment' ).val( '' );

								// Show based on mode
								if ( mode === 'upi' ) {
									$( '#upi_details_group, #transaction_id_group, #advance_payment_group' ).show();
									$( '#upi_id, #transaction_id, #advance_payment' ).prop( 'required', true );
								} else if ( mode === 'bank' || mode === 'card' || mode === 'online' ) {
									$( '#bank_details_group, #account_no_group, #transaction_id_group, #advance_payment_group' ).show();
									$( '#bank_name, #account_no, #transaction_id, #advance_payment' ).prop( 'required', true );
								} else if ( mode === 'cash' ) {
									$( '#advance_payment_group' ).show();
									$( '#advance_payment' ).prop( 'required', true );
								}
							} );

							// Prevent submission if payment = 0 or mode not selected
							$( 'form' ).on( 'submit', function ( e ) {
								const mode = $( '#payment_mode' ).val();
								const payment = parseFloat( $( '#advance_payment' ).val() || 0 );

								if ( !mode ) {
									alert( 'Please select a payment mode.' );
									e.preventDefault();
									return false;
								}

								if ( payment <= 0 ) {
									alert( 'Advance payment must be greater than 0.' );
									e.preventDefault();
									return false;
								}
							} );
						} );
					</script>
<script>
$(document).ready(function () {
  $('#customer_id').on('change', function () {
    const customerId = $(this).val();

    if (customerId) {
      $.ajax({
        url: 'ajax/fetchInquiryDetails.php',
        type: 'POST',
        data: { customer_id: customerId },
        dataType: 'json',
        beforeSend: function () {
          $('#inquiry_id,#package_name, #start_date, #end_date, #padults, #pchildren, #package_requests').val('');
        },
        success: function (res) {
          if (res.status === 'success') {
            let d = res.package || res.hotel || {}; // ✅ Pick available data

            function formatDate(dateStr) {
              if (!dateStr) return '';
              const parts = dateStr.split('-');
              if (parts.length !== 3) return '';
              return `${parts[2]}-${parts[1]}-${parts[0]}`;
            }
			$('#inquiry_id').val(d.inquiry_id || 0);
            $('#package_name').val(d.package_name || d.hotel_name || '');
            $('#start_date').val(formatDate(d.start_date || d.hotel_checkin_date));
            $('#end_date').val(formatDate(d.end_date || d.hotel_checkout_date));
            $('#padults').val(d.package_adults || 1);
            $('#pchildren').val(d.package_children || 0);
            $('#package_requests').val(d.package_special_requests || d.remarks || '');
          } else {
           // toastr.warning(res.message || 'No inquiry details found.');
          }
        },
        error: function (xhr, status, error) {
          console.error(error);
         // toastr.error('Error fetching inquiry details.');
        }
      });
    } else {
      $('#inquiry_id,#package_name, #start_date, #end_date, #padults, #pchildren, #package_requests').val('');
    }
  });
});



$(document).ready(function() {
	

 const num = (v) => parseFloat(v || 0);
  // ============================
  // ðŸ“¦ Package & Category AJAX
  // ============================
  $('#state_id').on('change', function() {
    const state_id = $(this).val();
    $('#package_id').html('<option value="">Loading...</option>');
    $('#category_id').html('<option value="">Select Category</option>');

    if (!state_id) {
      $('#package_id').html('<option value="">Select Package</option>');
      return;
    }

    $.ajax({
      url: 'controller/PackageCategoryPriceController.php',
      type: 'POST',
      dataType: 'json',
      data: { action: 'GetPackages', destination_id: state_id },
      success: function(res) {
        if (res.status === 'success') {
          let options = '<option value="">Select Package</option>';
          $.each(res.data, function(i, pkg) {
            options += `
              <option value="${pkg.id}">
                ${pkg.package_code} - ${pkg.package_name} (${pkg.days}D / ${pkg.nights}N)
              </option>`;
          });
          $('#package_id').html(options);
        } else {
          $('#package_id').html('<option value="">No packages found</option>');
        }
      },
      error: function() {
        $('#package_id').html('<option value="">Error loading packages</option>');
      }
    });
  });

  $('#package_id').on('change', function() {
  const package_id = $(this).val();
  $('#category_id').html('<option value="">Loading...</option>');

  if (!package_id) {
    $('#category_id').html('<option value="">Select Category</option>');
    $('#nights').val(''); // clear nights if no package
    return;
  }

  // Fetch categories first
  $.ajax({
    url: 'controller/PackageCategoryPriceController.php',
    type: 'POST',
    dataType: 'json',
    data: { action: 'GetPackagesCategories', package_id },
    success: function(res) {
      if (res.status === 'success') {
        let options = '<option value="">Select Category</option>';
        $.each(res.data, function(i, cat) {
          options += `<option value="${cat.category_id}">${cat.category_name}</option>`;
        });
        $('#category_id').html(options);
      } else {
        $('#category_id').html('<option value="">No categories found</option>');
      }
    },
    error: function() {
      $('#category_id').html('<option value="">Error loading categories</option>');
    }
  });

  // Fetch package nights
  $.ajax({
    url: 'controller/PackageCategoryPriceController.php',
    type: 'POST',
    dataType: 'json',
    data: { action: 'GetPackageNights', package_id },
    success: function(res) {
      if (res.status === 'success' && res.data.nights) {
        $('#nights').val(res.data.nights);
      } else {
        $('#nights').val('');
      }
    }
  });
});


  // =====================================
  // ðŸ¨ Fetch Category Details + Hotels
  // =====================================
  $('#category_id').on('change', function() {
    const package_id = $('#package_id').val();
    const category_id = $(this).val();

    if (!package_id || !category_id) return;

    $('#hotelContainer').html('<div class="text-center p-3 text-muted">Loading hotels...</div>');

    $.ajax({
      url: 'controller/PackageCategoryPriceController.php',
      type: 'POST',
      dataType: 'json',
      data: { action: 'fetchCategoryDetails', package_id, category_id },
      success: function(data) {
        if (data.status === 'success') {
          $('#adult_price').val(data.adult_price);
//          $('#child_price').val(data.child_price);
//          $('#extra_bed_price').val(data.extra_bed_price);

          const hotels = data.hotels || [];
          let html = '';

          if (hotels.length > 0) {
            hotels.forEach((h, i) => {
              html += `
                <div class="card border rounded-3 p-3 mb-3 shadow-sm">
                  <h6>${h.hotel_name} 
                    <small class="text-muted">(${h.city || 'N/A'})</small>
                    ${h.stars ? `<span class="badge bg-warning text-dark ms-2">${h.stars}*</span>` : ''}
                  </h6>
                  <input type="hidden" name="hotels[${i}][hotel_id]" value="${h.hotel_id}">
                  <input type="hidden" name="hotels[${i}][city]" value="${h.city}">
                  <input type="hidden" name="hotels[${i}][stars]" value="${h.stars}">
                  <div class="row g-2 mt-2">
                    <div class="col-md-3">
                      <label class="form-label mb-1">Nights</label>
                      <input type="number" class="form-control" name="hotels[${i}][nights]" value="1" min="1" required>
                    </div>
                    <div class="col-md-3">
                      <label class="form-label mb-1">Meal Plan</label>
                      <select class="form-select" name="hotels[${i}][meal_plan]" required>
                        <option value="">Select</option>
                        <option value="CP">CP (Room + Breakfast)</option>
                        <option value="MAP">MAP (Room + Breakfast + Dinner)</option>
                        <option value="AP">AP (Room + All Meals)</option>
                      </select>
                    </div>
                    <div class="col-md-3">
                      <label class="form-label mb-1">Rooms</label>
                      <input type="number" class="form-control" name="hotels[${i}][rooms]" value="1" min="1" required>
                    </div>
                  </div>
                </div>`;
            });
          } else {
            html = '<div class="alert alert-warning">No hotels found for this category.</div>';
          }

          $('#hotelContainer').html(html);
          calculateTotal();
        } else {
          $('#hotelContainer').html('<div class="alert alert-danger">No data found.</div>');
        }
      },
      error: function(xhr) {
        console.error('AJAX error:', xhr.responseText);
        $('#hotelContainer').html('<div class="alert alert-danger">Error fetching data.</div>');
      }
    });
  });

  // =====================================
  // ðŸ’° Total Calculation
  // =====================================
  function calculateTotal() {
    const adults = num($('#adults').val());
    const child = num($('#child').val());
    const extrabed = num($('#extrabed').val());
    const adult_price = num($('#adult_price').val());
    const child_price = num($('#child_price').val());
    const extra_bed_price = num($('#extra_bed_price').val());
    const transport = num($('#transport_charges').val());
    const discount = num($('#discount').val());
    const gstRate = num($('#gst').val());
    const gstIncluded = $('#gst_included').val();

    let total = (adults * adult_price) + (child * child_price) + (extrabed * extra_bed_price);
    total += transport;
    total -= (total * discount / 100);

    if (gstIncluded === 'yes') total += total * (gstRate / 100);

    $('#grand_total').val(total.toFixed(2));
  }

  $(document).on('input change', '#adults,#child,#extrabed,#adult_price,#child_price,#extra_bed_price,#transport_charges,#discount,#gst_included,#gst', calculateTotal);
  $(document).on('input change', '#hotelContainer input', calculateTotal);

  // ================================
  // ðŸ”¹ Form Submission + PDF Handling
  // ================================
  let downloadPdfAfterSubmit = false;

  $('#download-pdf').click(function (e) {
    e.preventDefault();
    downloadPdfAfterSubmit = true;
    $('form').submit();
  });

  $('form').submit(function (e) {
    e.preventDefault();
    let formData = new FormData(this);

    // Basic validation
    if (!formData.get("customer_id") || !formData.get("package_id")) {
      toastr.error("Please select Customer and Hotel.");
      return;
    }

    $.ajax({
      url: 'controller/PackageBookingController.php',
      method: 'POST',
      data: formData,
      contentType: false,
      processData: false,
      dataType: 'json',
      success: function (response) {
        if (response.status === 'success') {
          toastr.success(response.message);

          if (downloadPdfAfterSubmit && response.id) {
            window.open('controller/DownloadPDFBookingController.php?id=' + response.id, '_blank');
            downloadPdfAfterSubmit = false;
          }

          let redirectUrl = response.gst_included === 'yes' ? 
              'package_booking_list.php' : 
              'package_booking_list.php';

          setTimeout(() => window.location.href = redirectUrl, 1500);
        } else {
          toastr.error(response.message || 'Failed to save booking.');
        }
      },
      error: function (xhr, status, error) {
        toastr.error('An error occurred while submitting the form.');
        console.error('AJAX Error:', status, error, xhr.responseText);
      }
    });
  });

});
</script>

</script>
<?php include('inc/footer.php');?>