<?php include('inc/template.php'); ?>
<div class="container-fluid flex-grow-1 container-p-y">
	<nav aria-label="breadcrumb">
		<ol class="breadcrumb">
			<li class="breadcrumb-item"><a href="index.php">Home</a>
			</li>
			<li class="breadcrumb-item"><a href="insurance_booking_list.php">Travel Insurance List</a>
			</li>
			<li class="breadcrumb-item active">
				<?php echo isset($_GET['id']) ? 'Update Travel Insurance' : 'Add Travel Insurance'; ?>
			</li>
		</ol>
	</nav>
	<div class="row">
		<div class="col-9">
			<div class="card shadow p-4">
				<form id="insuranceBookingForm" method="post" enctype="multipart/form-data">
					<div class="row g-3 mb-4">


						<div class="col-md-4">
							<label class="form-label">Booking Date</label>
							<input type="date" name="booking_date" class="form-control" required value="<?php echo date('Y-m-d'); ?>">
						</div>

						<div class="col-md-8">
							<label for="customer_id" class="form-label">Customer Name</label>
							<input type="hidden" id="inquiry_id" name="inquiry_id"/>
							<select name="customer_id" id="customer_id" required class="select2 form-select form-select-lg">
								<option value="">Select Customer</option>

								<!-- In-Progress Inquiry Customers -->
								<optgroup label="In-Progress Inquiries">
									<?php
									$inProgress = $conn->query( "SELECT c.id AS customer_id,c.name,c.phone, i.id AS inquiry_id FROM customers c INNER JOIN inquiries i ON c.id = i.customer_id AND i.inquiry_type = 'insurance' AND i.status = 'in-progress' WHERE c.status = 'active' ORDER BY c.name ASC" );
									if ( $inProgress->num_rows > 0 ) {
										while ( $row = $inProgress->fetch_assoc() ) {
											echo '<option value="' . $row[ 'customer_id' ] . '" data-inquiry="' . $row[ 'inquiry_id' ] . '">'
											. htmlspecialchars( ucwords( strtolower( $row[ 'name' ] ) ) ) . ' (' . $row[ 'phone' ] . ')'
											. '</option>';
										}
									} else {
										echo '<option disabled>No in-progress inquiries</option>';
									}
									?>
								</optgroup>

								<!-- Other Customers (no in-progress inquiry) -->
								<optgroup label="Other Customers">
									<?php
									$others = $conn->query( "SELECT c.id AS customer_id, c.name, c.phone FROM customers c WHERE c.status = 'active' AND c.id NOT IN ( SELECT customer_id FROM inquiries WHERE status = 'in-progress' AND inquiry_type = 'package' ) ORDER BY c.name ASC" );
									if ( $others->num_rows > 0 ) {
										while ( $row = $others->fetch_assoc() ) {
											echo '<option value="' . $row[ 'customer_id' ] . '" data-inquiry="">'
											. htmlspecialchars( ucwords( strtolower( $row[ 'name' ] ) ) ) . ' (' . $row[ 'phone' ] . ')'
											. '</option>';
										}
									} else {
										echo '<option disabled>All customers have in-progress inquiries</option>';
									}
									?>
								</optgroup>
							</select>

						</div>

						<div class="col-md-4">
							<label class="form-label">Policy No</label>
							<input type="text" name="policy_no" id="policy_no" class="form-control">
						</div>

						<div class="col-md-4">
							<label class="form-label">Insurance Type</label>
							<select name="insurance_type" id="insurance_type" class="form-select" required>
								<option value="">Select Type</option>
								<option value="travel">Travel Insurance</option>
								<option value="medical">Medical Insurance</option>
								<option value="baggage">Baggage Insurance</option>
								<option value="cancellation">Trip Cancellation / Delay</option>
								<option value="accidental">Accidental Coverage</option>
								<option value="student">Student Travel Insurance</option>
								<option value="corporate">Corporate Travel Insurance</option>
								<option value="family">Family Travel Insurance</option>
								<option value="senior">Senior Citizen Insurance</option>
								<option value="annual">Annual Multi-trip Insurance</option>
							</select>
						</div>

						<div class="col-md-4">
							<label class="form-label">Insurance Company</label>
							<input type="text" name="insurance_company" id="destination" class="form-control" placeholder="e.g., Tata AIG, ICICI Lombard" required>
						</div>

						<div class="col-md-4">
							<label class="form-label">Destination</label>
							<input type="text" name="destination" id="destination" class="form-control" placeholder="e.g., Europe, USA, Dubai" required>
						</div>

						<div class="col-md-4">
							<label class="form-label">Travel Type</label>
							<select name="insurance_travel_type" id="insurance_travel_type" class="form-select" required>
								<option value="">Select</option>
								<option value="domestic">Domestic</option>
								<option value="international">International</option>
							</select>
						</div>

						<div class="col-md-4">
							<label class="form-label">No. of Travellers</label>
							<input type="number" name="no_of_travelers" id="no_of_travelers" class="form-control" min="1" value="1">
						</div>

						<div class="col-md-4">
							<label class="form-label">Start Date</label>
							<input type="date" name="insurance_start_date" id="insurance_start_date" class="form-control" required>
						</div>

						<div class="col-md-4">
							<label class="form-label">End Date</label>
							<input type="date" name="insurance_end_date" id="insurance_end_date" class="form-control" required>
						</div>

						<div class="col-md-4">
							<label class="form-label">Sum Insured (â‚¹)</label>
							<input type="number" name="insurance_sum_insured" id="insurance_sum_insured" class="form-control" required>
						</div>

						<div class="col-md-4">
							<label class="form-label">Premium Rate (%)</label>
							<input type="number" name="premium_rate" id="premium_rate" class="form-control" min="0" value="2">
						</div>

						<div class="col-md-4">
							<label class="form-label">Premium Amount (â‚¹)</label>
							<input type="text" name="premium_amount" id="premium_amount" class="form-control fw-bold text-success" readonly>
						</div>

						<div class="col-md-4">
							<label class="form-label">GST Included?</label>
							<select name="gst_included" id="gst_included" class="form-select">
								<option value="no">No</option>
								<option value="yes">Yes</option>
							</select>
							<input type="hidden" name="gst_rate" id="gst_rate" value="18">
						</div>

						<div class="col-md-4">
							<label class="form-label">Grand Total (â‚¹)</label>
							<input type="text" name="grand_total" id="grand_total" class="form-control fw-bold text-success" readonly>
						</div>

						<div class="col-md-4">
							<label for="payment_mode" class="form-label">Payment Mode</label>
							<select name="payment_mode" id="payment_mode" class="form-select" required>
								<option value="">Select Mode</option>
								<option value="cash">Cash</option>
								<option value="upi">UPI</option>
								<option value="bank">Bank Transfer</option>
								<option value="card">Card</option>
								<option value="online">Online</option>
							</select>
						</div>

						<!-- UPI Details -->
						<div class="col-md-4" id="upi_details_group" style="display:none;">
							<label for="upi_id" class="form-label">UPI ID</label>
							<input type="text" name="upi_id" id="upi_id" class="form-control" placeholder="e.g. username@upi">
						</div>

						<!-- Bank Details -->
						<div class="col-md-4" id="bank_details_group" style="display:none;">
							<label for="bank_name" class="form-label">Bank Name</label>
							<input type="text" name="bank_name" id="bank_name" class="form-control" placeholder="Bank Name">
						</div>

						<div class="col-md-4" id="account_no_group" style="display:none;">
							<label for="account_no" class="form-label">Account / Cheque No</label>
							<input type="text" name="account_no" id="account_no" class="form-control" placeholder="Account or Cheque Number">
						</div>

						<div class="col-md-4" id="transaction_id_group" style="display:none;">
							<label for="transaction_id" class="form-label">Transaction / Reference ID</label>
							<input type="text" name="transaction_id" id="transaction_id" class="form-control" placeholder="Transaction ID">
						</div>

						<!-- Advance Payment -->
						<div class="col-md-4" id="advance_payment_group" style="display:none;">
							<label for="advance_payment" class="form-label">Advance Payment (INR)</label>
							<input type="number" name="advance_payment" id="advance_payment" class="form-control" min="1" placeholder="Enter amount">
						</div>
						<input type="hidden" name="action" value="<?php echo isset($_GET['id']) ? 'Update' : 'Create'; ?>">
						<input type="hidden" name="id" value="<?php echo $_GET['id'] ?? ''; ?>">
						<input type="hidden" name="created_by" value="<?php echo $userId; ?>">


						<div class="mt-4">
							<button type="submit" class="btn btn-primary me-2">Save</button>
							<button type="button" id="download-pdf" class="btn btn-success me-2">Download PDF</button>
							<button type="reset" class="btn btn-secondary">Reset</button>
						</div>
					</div>
				</form>
			</div>
		</div>
		<div class="col-3">
			<div class="card shadow p-4 sticky-card">
				<div class="row g-3">
					<h5>Insurance Inquiry Detail</h5>

					<div class="col-md-12">
						<label class="form-label">Destination</label>
						<input type="text" id="idestination" class="form-control" readonly>
					</div>

					<div class="col-md-12">
						<label class="form-label">Travel Type</label>
						<input type="text" id="trveltype" class="form-control" readonly>
					</div>

					<div class="col-md-12">
						<label class="form-label">Number of Travelers</label>
						<input type="text" id="travelers" class="form-control" readonly>
					</div>
					<div class="col-md-12">
						<label class="form-label">Insurance Type</label>
						<input type="text" id="insurancetype" class="form-control" readonly>
					</div>

					<div class="col-md-12">
						<label class="form-label">Start Date</label>
						<input type="text" id="start_date" class="form-control" readonly>
					</div>


					<div class="col-md-12">
						<label class="form-label">End Date</label>
						<input type="text" id="end_date" class="form-control" readonly>
					</div>
					<div class="col-md-12">
						<label class="form-label">Sum Insured </label>
						<input type="text" id="sum_insured" class="form-control" readonly>
					</div>
					<div class="col-md-12">
						<label class="form-label">Remarks</label>
						<textarea id="remarks" class="form-control" rows="4" readonly></textarea>
					</div>
				</div>
			</div>
		</div>

	</div>
	<script>
		$( document ).ready( function () {

			// =====================================
			// PAYMENT MODE TOGGLE HANDLER
			// =====================================
			$( '#payment_mode' ).on( 'change', function () {
				const mode = $( this ).val();

				// Hide all optional fields first
				$( '#upi_details_group, #bank_details_group, #account_no_group, #transaction_id_group, #advance_payment_group' ).hide();
				$( '#upi_id, #bank_name, #account_no, #transaction_id, #advance_payment' )
					.prop( 'required', false ).val( '' );

				if ( mode === 'upi' ) {
					$( '#upi_details_group, #transaction_id_group, #advance_payment_group' ).show();
					$( '#upi_id, #transaction_id, #advance_payment' ).prop( 'required', true );
				} else if ( mode === 'bank' || mode === 'card' || mode === 'online' ) {
					$( '#bank_details_group, #account_no_group, #transaction_id_group, #advance_payment_group' ).show();
					$( '#bank_name, #account_no, #transaction_id, #advance_payment' ).prop( 'required', true );
				} else if ( mode === 'cash' ) {
					$( '#advance_payment_group' ).show();
					$( '#advance_payment' ).prop( 'required', true );
				}
			} );


			// =====================================
			// PREMIUM + GST TOTAL CALCULATION
			// =====================================
			function calculateInsuranceTotal() {
    const sumInsured = parseFloat($('#insurance_sum_insured').val()) || 0;
    const premiumRate = parseFloat($('#premium_rate').val()) || 0;
    const gstRate = parseFloat($('#gst_rate').val()) || 18;
    const gstIncluded = $('#gst_included').val();
    const travellers = parseInt($('#no_of_travelers').val()) || 1;

    // --- Get Dates ---
    const startDate = new Date($('#insurance_start_date').val());
    const endDate = new Date($('#insurance_end_date').val());

    // --- Duration Calculation ---
    let duration = 1;
    if (!isNaN(startDate) && !isNaN(endDate) && endDate >= startDate) {
        duration = Math.ceil((endDate - startDate) / (1000 * 60 * 60 * 24)) + 1;
    }

    // --- Base Premium (Include Duration) ---
    const basePremium = (sumInsured * (premiumRate / 100)) * travellers * duration;

    // --- GST Calculation ---
    let gstAmount = 0;
    let grandTotal = basePremium;

    if (gstIncluded === 'yes') {
        gstAmount = (basePremium * gstRate) / 100;
        grandTotal = basePremium + gstAmount;
    }

    // --- Update Fields ---
    $('#premium_amount').val(basePremium.toFixed(2));
    $('#grand_total').val(grandTotal.toFixed(2));

    // --- Show Duration ---
    $('#duration_days').remove();
    $('#insurance_end_date').after(
        `<div id="duration_days" class="text-muted mt-1">
            Duration: ${duration} day(s)
        </div>`
    );
}

// --- Trigger recalculation ---
$('#insurance_sum_insured, #premium_rate, #gst_included, #no_of_travelers, #insurance_start_date, #insurance_end_date')
    .on('input change', calculateInsuranceTotal);

// --- Initial Calculation ---
calculateInsuranceTotal();



			// =====================================
			// CUSTOMER FETCH INSURANCE INQUIRY
			// =====================================
			$( '#customer_id' ).on( 'change', function () {
				const customerId = $( this ).val();

				if ( customerId ) {
					$.ajax( {
						url: 'ajax/fetchInquiryDetails.php',
						type: 'POST',
						data: {
							customer_id: customerId,
							type: 'insurance'
						},
						dataType: 'json',
						beforeSend: function () {
							$( '#inquiry_id,#idestination, #trveltype, #insurancetype, #travelers, #start_date, #end_date, #sum_insured, #remarks' ).val( '' );
						},
						success: function ( res ) {
							if ( res.status === 'success' ) {
								const d = res.insurance || {};

								function formatDate( dateStr ) {
									if ( !dateStr ) return '';
									const parts = dateStr.split( '-' );
									return parts.length === 3 ? `${parts[2]}-${parts[1]}-${parts[0]}` : '';
								}

								$( '#inquiry_id' ).val( d.inquiry_id || 0 );
								$( '#idestination' ).val( d.insurance_destination || '' );
								$( '#trveltype' ).val( d.travel_type || '' );
								$( '#insurancetype' ).val( d.insurance_type || '' );
								$( '#travelers' ).val( d.no_of_travelers || 1 );
								$( '#start_date' ).val( formatDate( d.insurance_start_date ) );
								$( '#end_date' ).val( formatDate( d.insurance_end_date ) );

								$( '#sum_insured' ).val( d.insurance_sum_insured || '' );
								$( '#remarks' ).val( d.remarks || '' );
							}
						},
						error: function () {
							toastr.error( 'Error fetching insurance inquiry details.' );
						}
					} );
				} else {
					$( '#inquiry_id,#idestination, #trveltype, #insurancetype, #travelers, #start_date, #end_date, #sum_insured, #remarks' ).val( '' );
				}
			} );


			// =====================================
			// ðŸ§¾ PDF DOWNLOAD + FORM SUBMISSION
			// =====================================
			let downloadPdfAfterSubmit = false;

			$( '#download-pdf' ).click( function ( e ) {
				e.preventDefault();
				downloadPdfAfterSubmit = true;
				$( '#insuranceBookingForm' ).submit();
			} );

			$( '#insuranceBookingForm' ).submit( function ( e ) {
				e.preventDefault();

				const payment = parseFloat( $( '#advance_payment' ).val() || 0 );
				if ( $( '#payment_mode' ).val() !== 'cash' && payment <= 0 ) {
					toastr.error( 'Advance payment must be greater than 0.' );
					return false;
				}

				const formData = new FormData( this );

				$.ajax( {
					url: 'controller/InsuranceBookingController.php',
					method: 'POST',
					data: formData,
					processData: false,
					contentType: false,
					dataType: 'json',
					success: function ( response ) {
						if ( response.status === 'success' ) {
							toastr.success( response.message );

							if ( downloadPdfAfterSubmit && response.id ) {
								window.open( 'controller/DownloadPDFInsuranceBookingController.php?id=' + response.id, '_blank' );
								downloadPdfAfterSubmit = false;
							}

							setTimeout( () => window.location.href = 'insurance_booking_list.php', 1500 );
						} else {
							toastr.error( response.message || 'Failed to save booking.' );
						}
					},
					error: function ( xhr, status, error ) {
						toastr.error( 'An error occurred while submitting the form.' );
						console.error( 'AJAX Error:', status, error, xhr.responseText );
					}
				} );
			} );
		} );
	</script>
	<?php include('inc/footer.php'); ?>