<?php include('inc/template.php'); ?>

<div class="container-fluid flex-grow-1 container-p-y">
  <nav aria-label="breadcrumb">
    <ol class="breadcrumb">
      <li class="breadcrumb-item"><a href="index.php">Home</a></li>
      <li class="breadcrumb-item"><a href="inquiry_add.php">Add Inquiry</a></li>
      <li class="breadcrumb-item active">Inquiry List</li>
    </ol>
  </nav>
<!-- ✅ Import Button -->
        <button type="button" class="btn btn-sm btn-primary" data-bs-toggle="modal" data-bs-target="#importModal">
          <i class="ti ti-upload me-1"></i> Import Inquiries
        </button>

        <!-- ✅ Export Button -->
        <button type="button" id="exportBtn" class="btn btn-sm btn-success">
          <i class="ti ti-download me-1"></i> Export Inquiries
        </button>
  <div class="card">
    <div class="card-header">
      <ul class="nav nav-tabs card-header-tabs" id="inquiryTabs" role="tablist">
        <?php
        $tabs = ['package', 'hotel', 'flight', 'insurance', 'vehicle'];
        foreach ($tabs as $i => $tab) {
          $active = $i === 0 ? 'active' : '';
          echo "<li class='nav-item'>
                  <button class='nav-link $active' id='{$tab}-tab' data-bs-toggle='tab'
                    data-bs-target='#{$tab}' type='button' role='tab'>{$tab}</button>
                </li>";
        }
        ?>
      </ul>
	
    </div>
	
    <div class="card-body tab-content" id="inquiryTabsContent">
      <?php foreach ($tabs as $i => $tab): ?>
        <div class="tab-pane fade <?php echo $i === 0 ? 'show active' : ''; ?>" id="<?php echo $tab; ?>" role="tabpanel">
          <table class="table table-bordered table-responsive" id="table-<?php echo $tab; ?>">
            <thead>
              <tr>
                <th>Date</th>
                <th>Name</th>
                <th>Mobile</th>
                <th>Inquiry Type</th>
                <th>Follow-Up Status</th>
                <th>Remarks</th>
                <th>Action</th>
              </tr>
            </thead>
          </table>
        </div>
      <?php endforeach; ?>
    </div>
	<!-- Import Modal -->
<div class="modal fade" id="importModal" tabindex="-1" aria-labelledby="importModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <form id="importForm" enctype="multipart/form-data">
        <div class="modal-header">
          <h5 class="modal-title" id="importModalLabel">Import Inquiries (CSV)</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
        </div>
		  
        <div class="modal-body">
          <div class="mb-3">
            <label class="form-label">Select CSV File</label>
            <input type="file" name="file" accept=".csv" class="form-control" required>
            <small class="text-muted">Upload file with columns: Name, Mobile, Email, Address, Source, Type, Remarks</small>
          </div>
        </div>
        <div class="modal-footer">
		<input type="hidden" name="assigned_to" id="assigned_to" value="<?php echo $_SESSION['userid'] ?? ''; ?>">
          <button type="submit" class="btn btn-primary">Upload</button>
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
        </div>
      </form>
    </div>
  </div>
</div>

  </div>
</div>
<script>
$(document).ready(function () {
  const tabs = ['package', 'hotel', 'flight', 'insurance', 'vehicle'];
  const dataTables = {};

  // ✅ Initialize DataTable for each tab
  function initTable(tab) {
    dataTables[tab] = $('#table-' + tab).DataTable({
      processing: true,
      serverSide: true,
      responsive: true, // ✅ optional - mobile friendly
      ajax: {
        url: 'controller/InquiryController.php',
        type: 'POST',
        data: { inquiry_type: tab, action: 'InquiryList' },
        error: function (xhr) {
          console.error('DataTable Load Error:', xhr.responseText);
        }
      },
      columns: [
        { data: 'created_at' },
        { data: 'customer_name' },
        { data: 'phone' },
        { data: 'inquiry_type' },
        { data: 'status' },
        { data: 'remarks' },
        { data: 'action', orderable: false, searchable: false }
      ],
      order: [[0, 'desc']],
      pageLength: 25
    });
  }

  // ✅ Initialize the first tab by default
  initTable('package');

  // ✅ Lazy-load DataTables when tab is opened
  $('button[data-bs-toggle="tab"]').on('shown.bs.tab', function (e) {
    const tab = $(e.target).attr('data-bs-target').replace('#', '');
    if (!dataTables[tab]) initTable(tab);
  });

  // ✅ Delete Inquiry
  $(document).on('click', '.delete', function () {
    const id = $(this).data('id');
    const activeTab = $('.nav-link.active').attr('data-bs-target').replace('#', '');
    if (!id) return;

    const table = dataTables[activeTab];
    Swal.fire({
      title: 'Are you sure?',
      text: 'You will not be able to recover this inquiry!',
      icon: 'warning',
      showCancelButton: true,
      confirmButtonText: 'Yes, delete it!',
      cancelButtonText: 'Cancel',
      confirmButtonColor: '#d33',
      cancelButtonColor: '#3085d6'
    }).then((result) => {
      if (result.isConfirmed) {
        $.ajax({
          url: 'controller/InquiryController.php',
          type: 'POST',
          data: { id: id, action: 'Delete' },
          dataType: 'json',
          success: function (res) {
            if (res.status === 'success') {
              Swal.fire({
                icon: 'success',
                title: 'Deleted!',
                text: res.message,
                timer: 1200,
                showConfirmButton: false
              });
              table.ajax.reload(null, false);
            } else {
              Swal.fire('Error', res.message || 'Delete failed.', 'error');
            }
          },
          error: function (xhr) {
            Swal.fire('Error', 'Server response error.', 'error');
            console.error(xhr.responseText);
          }
        });
      }
    });
  });

  // ✅ Import CSV
  $('#importForm').on('submit', function (e) {
    e.preventDefault();
    const formData = new FormData(this);
    formData.append('action', 'ImportInquiries');

    Swal.fire({
      title: 'Importing...',
      text: 'Please wait while we process your file.',
      allowOutsideClick: false,
      didOpen: () => Swal.showLoading()
    });

    $.ajax({
      url: 'controller/InquiryController.php',
      type: 'POST',
      data: formData,
      contentType: false,
      processData: false,
      dataType: 'json',
      success: function (res) {
        Swal.close();
        if (res.status === 'success') {
          Swal.fire({
            icon: 'success',
            title: 'Imported!',
            text: res.message,
            timer: 1500,
            showConfirmButton: false
          });
          $('#importModal').modal('hide');
          const activeTab = $('.nav-link.active').attr('data-bs-target').replace('#', '');
          if (dataTables[activeTab]) dataTables[activeTab].ajax.reload(null, false);
        } else {
          Swal.fire('Error', res.message || 'Import failed.', 'error');
        }
      },
      error: function (xhr) {
        Swal.close();
        Swal.fire('Error', 'Failed to upload file.', 'error');
        console.error(xhr.responseText);
      }
    });
  });

  // ✅ Export Inquiries (CSV Download)
  $('#exportBtn').on('click', function () {
    const activeTab = $('.nav-link.active').attr('data-bs-target').replace('#', '');
    window.location.href =
      'controller/InquiryController.php?action=ExportInquiries&type=' + activeTab;
  });
});
</script>


<?php include('inc/footer.php');?>