<?php 
include('inc/template.php'); 
$id = $_GET['id'] ?? '';
$type = $_GET['type'] ?? '';
?>
<div class="container-fluid flex-grow-1 container-p-y">

  <nav aria-label="breadcrumb">
    <ol class="breadcrumb">
      <li class="breadcrumb-item"><a href="index.php">Home</a></li>
      <li class="breadcrumb-item"><a href="inquiry_list.php">Inquiry List</a></li>
      <li class="breadcrumb-item active"><?= $id ? 'Update Inquiry' : 'Add Inquiry'; ?></li>
    </ol>
  </nav>

  <div class="card mb-4">
    <div class="card-body">
      <form id="inquiryForm" method="post" enctype="multipart/form-data">
        <input type="hidden" name="id" id="upd" value="<?= $id ?>">
        <input type="hidden" name="updtype" id="updtype" value="<?= $type ?>">
        <input type="hidden" name="inquiry_type" id="inquiry_type" value="<?= $type ?: 'package' ?>">
        <input type="hidden" name="assigned_to" id="assigned_to" value="<?= $_SESSION['userid'] ?? '' ?>">
        <input type="hidden" name="action" value="<?= $id ? 'Update' : 'Create'; ?>">

        <!-- Customer Info -->
        <div class="row g-3 mb-3">
          <div class="col-md-6">
            <label class="form-label">Customer Name</label>
            <input type="text" id="name" name="name" class="form-control" required>
          </div>
          <div class="col-md-6">
            <label class="form-label">Mobile</label>
            <input type="tel" id="phone" name="phone" class="form-control" pattern="\d{10}" maxlength="10" required>
          </div>
          <div class="col-md-6">
            <label class="form-label">Email</label>
            <input type="email" id="email" name="email" class="form-control">
          </div>
          <div class="col-md-6">
            <label class="form-label">Address</label>
            <input type="text" id="address" name="address" class="form-control">
          </div>
        </div>

        <!-- Dynamic Type-Specific Fields -->
        <?php if ($type === 'package') { ?>
        <div class="row g-3">
          <div class="col-md-6"><label>Destination</label><input type="text" name="package_name" id="package_name" class="form-control"></div>
          <div class="col-md-3"><label>Start Date</label><input type="date" name="package_start_date" id="package_start_date" class="form-control"></div>
          <div class="col-md-3"><label>End Date</label><input type="date" name="package_end_date" id="package_end_date" class="form-control"></div>
          <div class="col-md-2"><label>Adults</label><input type="number" name="package_adults" id="package_adults" min="1" value="1" class="form-control"></div>
          <div class="col-md-2"><label>Children</label><input type="number" name="package_children" id="package_children" min="0" value="0" class="form-control"></div>
          <div class="col-md-8"><label>Special Requests</label><textarea name="package_requests" id="package_requests" class="form-control" rows="2"></textarea></div>
        </div>
        <?php } ?>

        <?php if ($type === 'hotel') { ?>
        <div class="row g-3">
          <div class="col-md-6"><label>City</label><input type="text" name="hotel_city" id="hotel_city" class="form-control"></div>
          <div class="col-md-6"><label>Hotel Name</label><input type="text" name="hotel_name" id="hotel_name" class="form-control"></div>
          <div class="col-md-3"><label>Check-in</label><input type="date" name="hotel_checkin_date" id="hotel_checkin_date" class="form-control"></div>
          <div class="col-md-3"><label>Check-out</label><input type="date" name="hotel_checkout_date" id="hotel_checkout_date" class="form-control"></div>
          <div class="col-md-2"><label>Rooms</label><input type="number" name="hotel_rooms" id="hotel_rooms" min="1" value="1" class="form-control"></div>
          <div class="col-md-2"><label>Adults</label><input type="number" name="hotel_adults" id="hotel_adults" min="1" value="1" class="form-control"></div>
          <div class="col-md-2"><label>Children</label><input type="number" name="hotel_children" id="hotel_children" min="0" value="0" class="form-control"></div>
          <div class="col-md-3">
            <label>Type</label>
            <select name="hotel_type" id="hotel_type" class="form-select">
              <option value="">Select</option>
              <option value="3-star">3-star</option>
              <option value="4-star">4-star</option>
              <option value="5-star">5-star</option>
            </select>
          </div>
        </div>
        <?php } ?>

        <?php if ($type === 'flight') { ?>
        <div class="row g-3">
          <div class="col-md-6"><label>From City</label><input type="text" name="flight_from" id="flight_from" class="form-control"></div>
          <div class="col-md-6"><label>To City</label><input type="text" name="flight_to" id="flight_to" class="form-control"></div>
          <div class="col-md-3"><label>Departure</label><input type="date" name="flight_departure" id="flight_departure" class="form-control"></div>
          <div class="col-md-3"><label>Return</label><input type="date" name="flight_return" id="flight_return" class="form-control"></div>
          <div class="col-md-2"><label class="form-label">Adults</label><input type="number" name="flight_adult" id="flight_adult" min="1" value="1" class="form-control"></div>
            <div class="col-md-2"><label class="form-label">Children</label><input type="number" name="flight_children" id="flight_children" min="0" value="0" class="form-control"></div>
            <div class="col-md-2"><label class="form-label">Infant</label><input type="number" name="flight_infant" id="flight_infant" min="0" value="0" class="form-control"></div>
          <div class="col-md-2">
            <label>Class</label>
            <select name="flight_class" id="flight_class" class="form-select">
              <option value="economy">Economy</option>
              <option value="business">Business</option>
              <option value="first">First</option>
            </select>
          </div>
        </div>
        <?php } ?>

        <?php if ($type === 'insurance') { ?>
        <div class="row g-3">
          <div class="col-md-3">
            <label>Type</label>
            <select id="insurance_type" name="insurance_type" class="form-select">
              <option value="">Select Insurance Type</option>
              <option value="travel">Travel Insurance</option>
              <option value="medical_travel">Medical Travel Insurance</option>
              <option value="trip_cancellation">Trip Cancellation Insurance</option>
              <option value="trip_delay">Trip Delay Insurance</option>
              <option value="baggage_loss">Baggage Loss / Delay Insurance</option>
              <option value="flight_accident">Flight Accident Insurance</option>
              <option value="adventure_sports">Adventure Sports Coverage</option>
              <option value="personal_liability">Personal Liability Insurance</option>
              <option value="emergency_evacuation">Emergency Evacuation Insurance</option>
              <option value="group_travel">Group Travel Insurance</option>
            </select>
          </div>
          <div class="col-md-3"><label>Start</label><input type="date" name="insurance_start" id="insurance_start" class="form-control"></div>
          <div class="col-md-3"><label>End</label><input type="date" name="insurance_end" id="insurance_end" class="form-control"></div>
          <div class="col-md-3"><label>Sum Insured</label><input type="number" name="insurance_sum" id="insurance_sum" class="form-control"></div>
        </div>
        <?php } ?>

        <?php if ($type === 'vehicle') { ?>
        <div class="row g-3">
          <div class="col-md-6">
            <label>Vehicle Type</label>
            <select name="vehicle_type" id="vehicle_type" class="form-select">
              <option value="">Select Vehicle</option>
              <?php
              $result = mysqli_query($conn, "SELECT vehicle_type FROM vehicles WHERE status='active'");
              while ($r = mysqli_fetch_assoc($result)) {
                  echo "<option value='{$r['vehicle_type']}'>{$r['vehicle_type']}</option>";
              }
              ?>
            </select>
          </div>
          <div class="col-md-3"><label>Pickup</label><input type="text" name="vehicle_pickup" id="vehicle_pickup" class="form-control"></div>
          <div class="col-md-3"><label>Drop</label><input type="text" name="vehicle_drop" id="vehicle_drop" class="form-control"></div>
          <div class="col-md-3"><label>Pickup Date & Time</label><input type="datetime-local" name="vehicle_pickup_date" id="vehicle_pickup_date" class="form-control"></div>
          <div class="col-md-3"><label>Drop Date & Time</label><input type="datetime-local" name="vehicle_drop_date" id="vehicle_drop_date" class="form-control"></div>
          <div class="col-md-2"><label>Passengers</label><input type="number" name="vehicle_passengers" id="vehicle_passengers" min="1" value="1" class="form-control"></div>
        </div>
        <?php } ?>

        <!-- Remarks -->
        <div class="mt-3">
          <label>Remarks</label>
          <textarea name="remarks" id="remarks" class="form-control" rows="2"></textarea>
        </div>

        <div class="pt-4">
          <button type="submit" class="btn btn-primary me-2"><?= $id ? 'Update' : 'Save'; ?></button>
          <button type="reset" class="btn btn-secondary">Cancel</button>
        </div>
      </form>
    </div>
  </div>
</div>
<script>
$(document).ready(function () {
    const $form = $('#inquiryForm');

    // 🔧 Utility: Safe date formatter
    function formatDate(dateStr, type = 'date') {
        if (!dateStr) return ''; // if null or empty
        try {
            const d = new Date(dateStr);
            if (isNaN(d.getTime())) return ''; // invalid date
            if (type === 'datetime-local') {
                return d.toISOString().slice(0, 16); // yyyy-MM-ddTHH:mm
            }
            return d.toISOString().slice(0, 10); // yyyy-MM-dd
        } catch {
            return '';
        }
    }

    // 🔹 Handle Submit (Create / Update)
    $form.on('submit', function (e) {
        e.preventDefault();

        const formData = new FormData(this);

        // Basic validation
        if (!formData.get('name') || !formData.get('phone')) {
            toastr.error("Customer Name and Phone are required.");
            return;
        }

        $.ajax({
            url: 'controller/InquiryController.php',
            method: 'POST',
            data: formData,
            processData: false,
            contentType: false,
            dataType: 'json',
            beforeSend: () => {
                $('button[type="submit"]').prop('disabled', true).text('Saving...');
            },
            success: (res) => {
                if (res.status === 'success') {
                    toastr.success(res.message || 'Inquiry saved successfully!');
                    setTimeout(() => window.location.href = 'inquiry_list.php', 1200);
                } else {
                    toastr.error(res.message || 'Failed to save inquiry.');
                }
            },
            error: (xhr) => {
                toastr.error('Server error. Please check console.');
                console.error('AJAX Error:', xhr.responseText);
            },
            complete: () => {
                $('button[type="submit"]').prop('disabled', false).text('Save');
            }
        });
    });

    // 🔹 Load Data if Updating
    const id = $('#upd').val();
    const type = $('#updtype').val() || 'package';
    $('#inquiry_type').val(type);

    if (id) {
        $.ajax({
            url: 'controller/InquiryController.php',
            method: 'POST',
            data: { action: 'Select', id: id },
            dataType: 'json',
            success: (res) => {
                if (res.status === 'success' && res.data) {
                    const data = res.data;

                    // Common fields
                    $('#upd').val(data.id);
                    $('#inquiry_type').val(data.inquiry_type);
                     $('#name').val(data.name);
                    $('#phone').val(data.phone);
                    $('#email').val(data.email);
                    $('#address').val(data.address);
                    $('#remarks').val(data.remarks);
					$('#assigned_to').val(data.assigned_to);

                    // Type-specific data filling
                    switch (data.inquiry_type) {
                        case 'package':
                            $('#package_name').val(data.package_name);
                            $('#package_start_date').val(formatDate(data.package_start_date));
                            $('#package_end_date').val(formatDate(data.package_end_date));
                            $('#package_adults').val(data.package_adults);
                            $('#package_children').val(data.package_children);
                            $('#package_requests').val(data.package_special_requests);
                            break;

                        case 'hotel':
                            $('#hotel_city').val(data.hotel_city);
                            $('#hotel_name').val(data.hotel_name);
                            $('#hotel_checkin_date').val(formatDate(data.hotel_checkin_date));
                            $('#hotel_checkout_date').val(formatDate(data.hotel_checkout_date));
                            $('#hotel_rooms').val(data.hotel_rooms);
                            $('#hotel_adults').val(data.hotel_adults);
                            $('#hotel_children').val(data.hotel_children);
                            $('#hotel_type').val(data.hotel_type);
                            break;

                        case 'flight':
                            $('#flight_from').val(data.flight_from_city);
                            $('#flight_to').val(data.flight_to_city);
                            $('#flight_departure').val(formatDate(data.flight_departure_date));
                            $('#flight_return').val(formatDate(data.flight_return_date));
                            $('#flight_adult').val(data.flight_adult);
                            $('#flight_children').val(data.flight_children);
                            $('#flight_infant').val(data.flight_infant);
                            $('#flight_class').val(data.flight_class);
                            break;

                        case 'insurance':
                            $('#insurance_type').val(data.insurance_type);
                            $('#insurance_start').val(formatDate(data.insurance_start_date));
                            $('#insurance_end').val(formatDate(data.insurance_end_date));
                            $('#insurance_sum').val(data.insurance_sum_insured);
                            break;

                        case 'vehicle':
                            $('#vehicle_type').val(data.vehicle_type);
                            $('#vehicle_pickup').val(data.vehicle_pickup_location);
                            $('#vehicle_drop').val(data.vehicle_drop_location);
                            $('#vehicle_pickup_date').val(formatDate(data.vehicle_pickup_datetime, 'datetime-local'));
                            $('#vehicle_drop_date').val(formatDate(data.vehicle_drop_datetime, 'datetime-local'));
                            $('#vehicle_passengers').val(data.vehicle_passengers);
                            break;
                    }
                } else {
                    toastr.error(res.message || 'Failed to load inquiry details.');
                }
            },
            error: (xhr) => {
                toastr.error('Error while loading inquiry data.');
                console.error('Select Error:', xhr.responseText);
            }
        });
    }
});
</script>

<?php include('inc/footer.php'); ?>
