<?php include( 'inc/template.php' ); ?>
<div class="container-fluid flex-grow-1 container-p-y">
	<?php include('inquiry_header.php');?>
	<div class="row">
                <div class="col-xl-12 col-lg-5 col-md-5">
                    
                    <div class="card">
                      
                      
						  <div class="card-body">
  <?php 
  $statusclass = strtolower($row['status']) == 'pending' ? 'bg-warning' :
                 (strtolower($row['status']) == 'in-progress' ? 'bg-info' :
                 (strtolower($row['status']) == 'closed' ? 'bg-secondary' : 'bg-success'));
  ?>  

  <div class="d-flex flex-wrap">
    <div class="me-5">
      <p><i class="ti ti-calendar"></i> Inquiry Date: <?= date('d-m-Y', strtotime($row['created_at'])) ?></p>
      <p><i class="ti ti-user"></i> Name: <?= htmlspecialchars(ucwords(strtolower($row['customer_name']))) ?>
</p>
      <p><i class="ti ti-map-pin"></i> Address: <?= htmlspecialchars(ucwords(strtolower($row['address']))) ?>
</p>
      <p><i class="ti ti-phone-call"></i> Phone: +91 <?= htmlspecialchars($row['customer_phone']) ?></p>
      <p><i class="ti ti-mail"></i> Email: <?= htmlspecialchars($row['customer_email']) ?></p>
    </div>
    <div>
      <p><i class="ti ti-beach"></i> Type: <?= ucfirst($row['inquiry_type']) ?></p>
      <p><i class="ti ti-clock"></i> Status: <span class="badge <?= $statusclass ?>"><?= ucfirst($row['status']) ?></span></p>
      <p><i class="ti ti-user-check"></i> Assigned To: <?= htmlspecialchars($row['assigned_to']) ?></p>
    </div>
  </div>
							  <hr>
<h5><?= ucfirst($row['inquiry_type']) ?> Inquiry Details</h5>

<?php if ($row['inquiry_type'] == 'hotel'): ?>
  <p><strong>City:</strong> <?= htmlspecialchars($row['hotel_city']) ?></p>
  <p><strong>Hotel Name:</strong> <?= htmlspecialchars($row['hotel_name']) ?></p>
  <p><strong>Check-In:</strong> <?= htmlspecialchars($row['hotel_checkin_date']) ?></p>
  <p><strong>Check-Out:</strong> <?= htmlspecialchars($row['hotel_checkout_date']) ?></p>
  <p><strong>Rooms:</strong> <?= htmlspecialchars($row['hotel_rooms']) ?></p>
  <p><strong>Adults:</strong> <?= htmlspecialchars($row['hotel_adults']) ?></p>
  <p><strong>Children:</strong> <?= htmlspecialchars($row['hotel_children']) ?></p>
  <p><strong>Hotel Type:</strong> <?= htmlspecialchars($row['hotel_type']) ?></p>

<?php elseif ($row['inquiry_type'] == 'package'): ?>
  <p><strong>Destination / Package Name:</strong> <?= htmlspecialchars($row['package_name']) ?></p>
  <p><strong>Travel Dates:</strong> 
    <?= date('d-m-Y', strtotime($row['package_start_date'])) . ' to ' . date('d-m-Y', strtotime($row['package_end_date'])) ?>
</p>
  <p><strong>Adults:</strong> <?= $row['package_adults'] ?> | <strong>Children:</strong> <?= $row['package_children'] ?></p>
  <p><strong>Special Requests:</strong> <?= htmlspecialchars($row['package_special_requests']) ?></p>

<?php elseif ($row['inquiry_type'] == 'flight'): ?>
  <p><strong>From City:</strong> <?= htmlspecialchars($row['flight_from_city']) ?></p>
  <p><strong>To City:</strong> <?= htmlspecialchars($row['flight_to_city']) ?></p>
  <p><strong>Departure:</strong> <?= !empty($row['flight_departure_date']) ? date('d-m-Y', strtotime($row['flight_departure_date'])) : '-' ?></p>
<p><strong>Return:</strong> <?= !empty($row['flight_return_date']) ? date('d-m-Y', strtotime($row['flight_return_date'])) : '-' ?></p>
  <p><strong>Passengers:</strong> <?= htmlspecialchars($row['flight_passengers']) ?></p>
  <p><strong>Class:</strong> <?= htmlspecialchars($row['flight_class']) ?></p>

<?php elseif ($row['inquiry_type'] === 'insurance'): ?>
  <p><strong>Destination:</strong> <?= htmlspecialchars($row['insurance_destination'] ?? '-') ?></p>
  <p><strong>Travel Type:</strong> <?= ucfirst($row['travel_type'] ?? '-') ?></p>
  <p><strong>No. of Travelers:</strong> <?= (int)($row['no_of_travelers'] ?? 0) ?></p>
  <p><strong>Insurance Type:</strong> <?= ucfirst(str_replace('_', ' ', htmlspecialchars($row['insurance_type'] ?? '-'))) ?></p>
  <p><strong>Start Date:</strong> <?= !empty($row['insurance_start_date']) ? date('d-m-Y', strtotime($row['insurance_start_date'])) : '-' ?></p>
  <p><strong>End Date:</strong> <?= !empty($row['insurance_end_date']) ? date('d-m-Y', strtotime($row['insurance_end_date'])) : '-' ?></p>
  <p><strong>Sum Insured:</strong> ₹<?= number_format((float)($row['insurance_sum_insured'] ?? 0), 2) ?></p>


<?php elseif ($row['inquiry_type'] == 'vehicle'): ?>
  <p><strong>Vehicle Type:</strong> <?= htmlspecialchars($row['vehicle_type']) ?></p>
  <p><strong>Pickup Location:</strong> <?= htmlspecialchars($row['vehicle_pickup_location']) ?></p>
  <p><strong>Drop Location:</strong> <?= htmlspecialchars($row['vehicle_drop_location']) ?></p>
  <p><strong>Pickup DateTime:</strong> 
  <?= !empty($row['vehicle_pickup_datetime']) ? date('d-m-Y h:i A', strtotime($row['vehicle_pickup_datetime'])) : '-' ?>
</p>

<p><strong>Drop DateTime:</strong> 
  <?= !empty($row['vehicle_drop_datetime']) ? date('d-m-Y h:i A', strtotime($row['vehicle_drop_datetime'])) : '-' ?>
</p>

  <p><strong>Passengers:</strong> <?= htmlspecialchars($row['vehicle_passengers']) ?></p>

<?php else: ?>
  <p>No specific details found for this inquiry type.</p>
<?php endif; ?>

</div>

						  
                      
                    </div>
                    
                                      
                  
                                  
                </div>
               
              </div>  
</div>
<?php include('inc/footer.php');?>