<?php include( 'inc/template.php' );?>
	<div class="container-fluid flex-grow-1 container-p-y">
		<nav aria-label="breadcrumb">
	<ol class="breadcrumb">
    <li class="breadcrumb-item"><a href="index.php">Home</a></li>
	<li class="breadcrumb-item"><a href="inquiry_list.php">Inquiry List</a></li>
    <li class="breadcrumb-item active"><?php echo isset($_GET['id']) ? 'Update Inquiry' : 'Inquiry Add'; ?></li>
    </ol>
</nav>
		<div class="card mb-4"> 
  <div class="card-body">
    <!-- Tabs -->
    <ul class="nav nav-tabs mb-3" id="inquiryTab" role="tablist">
      <li class="nav-item"><button class="nav-link active" data-bs-toggle="tab" data-bs-target="#package" type="button">Package</button></li>
      <li class="nav-item"><button class="nav-link" data-bs-toggle="tab" data-bs-target="#hotel" type="button">Hotel</button></li>
      <li class="nav-item"><button class="nav-link" data-bs-toggle="tab" data-bs-target="#flight" type="button">Flight</button></li>
      <li class="nav-item"><button class="nav-link" data-bs-toggle="tab" data-bs-target="#insurance" type="button">Insurance</button></li>
      <li class="nav-item"><button class="nav-link" data-bs-toggle="tab" data-bs-target="#vehicle" type="button">Vehicle</button></li>
    </ul>

    <form id="inquiryForm" method="post" enctype="multipart/form-data">
      <input type="hidden" name="id" id="upd" value="<?php echo $_GET['id'] ?? ''; ?>">
      <input type="hidden" name="inquiry_type" id="inquiry_type" value="package">
      <input type="hidden" name="assigned_to" id="assigned_to" value="<?php echo $_SESSION['userid'] ?? ''; ?>">
      <input type="hidden" name="action" value="<?php echo isset($_GET['id']) ? 'Update' : 'Create'; ?>">

      <!-- Customer Info -->
      <div class="row g-3 mb-3">
        <div class="col-md-6"><label class="form-label">Customer Name</label><input type="text" id="name" name="name" class="form-control" required></div>
        <div class="col-md-6"><label class="form-label">Mobile</label><input type="tel" id="phone" name="phone" class="form-control" pattern="\d{10}" maxlength="10" required></div>
        <div class="col-md-6"><label class="form-label">Email</label><input type="email" id="email" name="email" class="form-control"></div>
        <div class="col-md-6"><label class="form-label">Address</label><input type="text" id="address" name="address" class="form-control"></div>
      </div>

      <!-- Tab Content -->
      <div class="tab-content">
        <!-- Package -->
        <div class="tab-pane fade show active" id="package">
          <div class="row g-3">
            <div class="col-md-6"><label class="form-label">Destination</label><input type="text" name="package_name" id="package_name" class="form-control"></div>
            <div class="col-md-3"><label class="form-label">Start Date</label><input type="date" name="package_start_date" id="package_start_date" class="form-control"></div>
            <div class="col-md-3"><label class="form-label">End Date</label><input type="date" name="package_end_date" id="package_end_date" class="form-control"></div>
            <div class="col-md-2"><label class="form-label">Adults</label><input type="number" name="package_adults" id="package_adults" min="1" value="1" class="form-control"></div>
            <div class="col-md-2"><label class="form-label">Children</label><input type="number" name="package_children" id="package_children" min="0" value="0" class="form-control"></div>
            <div class="col-md-8"><label class="form-label">Special Requests</label><textarea name="package_requests" id="package_requests" class="form-control" rows="2"></textarea></div>
          </div>
        </div>

        <!-- Hotel -->
        <div class="tab-pane fade" id="hotel">
          <div class="row g-3">
            <div class="col-md-6"><label class="form-label">City</label><input type="text" name="hotel_city" id="hotel_city" class="form-control"></div>
            <div class="col-md-6"><label class="form-label">Hotel Name</label><input type="text" name="hotel_name" id="hotel_name" class="form-control"></div>
            <div class="col-md-3"><label class="form-label">Check-in</label><input type="date" name="hotel_checkin_date" id="hotel_checkin_date" class="form-control"></div>
            <div class="col-md-3"><label class="form-label">Check-out</label><input type="date" name="hotel_checkout_date" id="hotel_checkout_date" class="form-control"></div>
            <div class="col-md-2"><label class="form-label">Rooms</label><input type="number" name="hotel_rooms" id="hotel_rooms" min="1" value="1" class="form-control"></div>
            <div class="col-md-2"><label class="form-label">Adults</label><input type="number" name="hotel_adults" id="hotel_adults" min="1" value="1" class="form-control"></div>
            <div class="col-md-2"><label class="form-label">Children</label><input type="number" name="hotel_children" id="hotel_children" min="0" value="0" class="form-control"></div>
            <div class="col-md-3">
              <label class="form-label">Type</label>
              <select name="hotel_type" id="hotel_type" class="form-select">
                <option value="">Select</option>
                <option value="3-star">3-star</option>
                <option value="4-star">4-star</option>
                <option value="5-star">5-star</option>
              </select>
            </div>
          </div>
        </div>

        <!-- Flight -->
        <div class="tab-pane fade" id="flight">
          <div class="row g-3">
            <div class="col-md-6"><label class="form-label">From City</label><input type="text" name="flight_from" id="flight_from" class="form-control"></div>
            <div class="col-md-6"><label class="form-label">To City</label><input type="text" name="flight_to" id="flight_to" class="form-control"></div>
            <div class="col-md-3"><label class="form-label">Departure</label><input type="date" name="flight_departure" id="flight_departure" class="form-control"></div>
            <div class="col-md-3"><label class="form-label">Return</label><input type="date" name="flight_return" id="flight_return" class="form-control"></div>
            <div class="col-md-2"><label class="form-label">Adults</label><input type="number" name="flight_adult" id="flight_adult" min="1" value="1" class="form-control"></div>
            <div class="col-md-2"><label class="form-label">Children</label><input type="number" name="flight_children" id="flight_children" min="0" value="0" class="form-control"></div>
            <div class="col-md-2"><label class="form-label">Children</label><input type="number" name="flight_infant" id="flight_infant" min="0" value="0" class="form-control"></div>
            <div class="col-md-2">
              <label class="form-label">Class</label>
              <select name="flight_class" id="name" class="form-select">
                <option value="economy">Economy</option>
                <option value="business">Business</option>
                <option value="first">First</option>
              </select>
            </div>
          </div>
        </div>

        <!-- Insurance -->
        <div class="tab-pane fade" id="insurance">
  <div class="row g-3">

    <!-- Destination -->
    <div class="col-md-4">
      <label class="form-label">Destination</label>
      <input type="text" name="insurance_destination" id="insurance_destination" class="form-control" placeholder="e.g., Dubai, Singapore">
    </div>

    <!-- Travel Type -->
    <div class="col-md-4">
      <label class="form-label">Travel Type</label>
      <select name="travel_type" id="travel_type" class="form-select">
        <option value="">Select Type</option>
        <option value="domestic">Domestic</option>
        <option value="international">International</option>
      </select>
    </div>

    <!-- Number of Travelers -->
    <div class="col-md-4">
      <label class="form-label">Number of Travelers</label>
      <input type="number" name="no_of_travelers" id="no_of_travelers" class="form-control" min="1" placeholder="e.g., 2" >
    </div>

    <!-- Insurance Type -->
    <div class="col-md-4">
      <label class="form-label">Insurance Type</label>
      <select name="insurance_type" id="insurance_type" class="form-select" >
        <option value="">Select Type</option>
        <option value="travel">Travel Insurance</option>
        <option value="medical">Medical Insurance</option>
        <option value="baggage">Baggage Insurance</option>
        <option value="cancellation">Trip Cancellation / Delay</option>
        <option value="accidental">Accidental Coverage</option>
        <option value="student">Student Travel Insurance</option>
        <option value="corporate">Corporate Travel Insurance</option>
        <option value="family">Family Travel Insurance</option>
        <option value="senior">Senior Citizen Insurance</option>
        <option value="annual">Annual Multi-trip Insurance</option>
      </select>
    </div>

    <!-- Trip Duration -->
    <div class="col-md-4">
      <label class="form-label">Start Date</label>
      <input type="date" name="insurance_start" id="insurance_start" class="form-control" >
    </div>

    <div class="col-md-4">
      <label class="form-label">End Date</label>
      <input type="date" name="insurance_end" id="insurance_end" class="form-control" >
    </div>

    <!-- Sum Insured -->
    <div class="col-md-4">
      <label class="form-label">Sum Insured (₹)</label>
      <input type="number" name="insurance_sum" id="insurance_sum" class="form-control" placeholder="e.g., 500000" >
    </div>
  </div>
</div>


        <!-- Vehicle -->
        <div class="tab-pane fade" id="vehicle">
          <div class="row g-3">
            <div class="col-md-6">
              <label class="form-label">Vehicle Type</label>
              <select name="vehicle_type" id="vehicle_type" class="form-select">
                <option value="">Select Vehicle</option>
                <?php
                $query = "SELECT id, vehicle_type FROM vehicles WHERE status='active' ORDER BY id ASC";
                $result = mysqli_query($conn, $query);
                while ($r = mysqli_fetch_assoc($result)) {
                    echo "<option value='{$r['vehicle_type']}'>{$r['vehicle_type']}</option>";
                }
                ?>
              </select>
            </div>
            <div class="col-md-3"><label class="form-label">Pickup</label><input type="text" name="vehicle_pickup" id="vehicle_pickup" class="form-control"></div>
            <div class="col-md-3"><label class="form-label">Drop</label><input type="text" name="vehicle_drop" id="vehicle_drop" class="form-control"></div>
            <div class="col-md-3"><label class="form-label">Pickup Date & Time</label><input type="datetime-local"  name="vehicle_pickup_date" id="vehicle_pickup_date" class="form-control"></div>
            <div class="col-md-3"><label class="form-label">Drop Date & Time</label><input type="datetime-local" name="vehicle_drop_date" id="vehicle_drop_date" class="form-control"></div>
            <div class="col-md-2"><label class="form-label">Passengers</label><input type="number" name="vehicle_passengers" id="vehicle_passengers" min="1" value="1" class="form-control"></div>
          </div>
        </div>
      </div>
	<div class="mt-3">
  <label class="form-label">Source</label>
  <select name="source" id="source" class="form-control" required>
    <option value="">-- Select Source --</option>
    <option value="Facebook">Facebook</option>
    <option value="Instagram">Instagram</option>
    <option value="Google">Google</option>
    <option value="WhatsApp">WhatsApp</option>
    <option value="Referral">Referral</option>
    <option value="Walk-In">Walk-In</option>
    <option value="Website">Website</option>
    <option value="Other">Other</option>
  </select>
</div>

      <div class="mt-3">
        <label class="form-label">Remarks</label>
        <textarea name="remarks" id="remarks" class="form-control" rows="2"></textarea>
      </div>

      <div class="pt-4">
        <button type="submit" class="btn btn-primary me-2"><?php echo isset($_GET['id']) ? 'Update' : 'Save'; ?></button>
        <button type="reset" class="btn btn-secondary">Cancel</button>
      </div>
    </form>
  </div>
</div>



	</div>
<script>
$(document).ready(function () {
    const $form = $('#inquiryForm');

    // Set inquiry_type dynamically when tab changes
//    $('.nav-link').on('shown.bs.tab', function () {
//        const type = $(this).attr('data-bs-target').replace('#', '');
//        $('#inquiry_type').val(type);
//    });
	
	// Detect active tab and update hidden field inquiry_type
    $('#inquiryTab button[data-bs-toggle="tab"]').on('shown.bs.tab', function (e) {
        const target = $(e.target).data('bs-target').replace('#', '');
        $('#inquiry_type').val(target);
    });

    // Handle Submit
    $form.on('submit', function (e) {
        e.preventDefault();

        const formData = new FormData(this);

        // Basic validation
        if (!formData.get('name') || !formData.get('phone')) {
            toastr.error("Customer Name and Phone are required.");
            return;
        }

        $.ajax({
            url: 'controller/InquiryController.php',
            method: 'POST',
            data: formData,
            processData: false,
            contentType: false,
            dataType: 'json',
            success: (res) => {
                if (res.status === 'success') {
                    toastr.success(res.message);
                    setTimeout(() => window.location.href = 'inquiry_list.php', 1500);
                } else {
                    toastr.error(res.message);
                }
            },
            error: (xhr) => {
                toastr.error('Server error, please check console.');
                console.error(xhr.responseText);
            }
        });
    });

    
    // Load data if updating
    const id = $('#upd').val();
    if (id) {
        $.ajax({
            url: 'controller/InquiryController.php',
            type: 'POST',
            dataType: 'json',
            data: { id: id, action: 'Select' },
            success: function (res) {
                if (res && res.status === 'success') {
                    const data = res.data;

                    // Fill customer info
                    $('#name').val(data.name);
                    $('#phone').val(data.phone);
                    $('#email').val(data.email);
                    $('#address').val(data.address);
                    $('[name="assigned_to"]').val(data.assigned_to);
                    $('[name="package_requests"]').val(data.remarks);

                    // Show correct tab
                    const type = data.inquiry_type || 'package';
                    $(`button[data-bs-target="#${type}"]`).tab('show');
                    $('#inquiry_type').val(type);

                    // Auto-fill all matching input names
                    for (let key in data) {
                        $(`[name="${key}"]`).val(data[key]);
                    }
                } else {
                    toastr.error(res.message || 'Failed to load record.');
                }
            },
            error: function () {
                toastr.error('Server error while loading record.');
            }
        });
    }
});
</script>

<?php include('inc/footer.php');?>