<!DOCTYPE html>

<html lang="en" class="light-style layout-wide customizer-hide" dir="ltr" data-theme="theme-default" data-assets-path="assets/" data-template="horizontal-menu-template">
<head>
	<meta charset="utf-8"/>
	<meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0"/>
	<title>Login </title>
	<meta name="description" content=""/>
	<link rel="apple-touch-icon" sizes="180x180" href="assets/img/favicon/apple-touch-icon.png">
	<link rel="icon" type="image/png" sizes="32x32" href="assets/img/favicon/favicon-32x32.png">
	<link rel="icon" type="image/png" sizes="16x16" href="assets/img/favicon/favicon-16x16.png">
	<link rel="manifest" href="assets/img/favicon/site.webmanifest">
	<link rel="stylesheet" href="assets/vendor/fonts/fontawesome.css"/>
	<link rel="stylesheet" href="assets/vendor/fonts/tabler-icons.css"/>
	<link rel="stylesheet" href="assets/vendor/fonts/flag-icons.css"/>
	<link rel="stylesheet" href="assets/vendor/css/rtl/core.css" class="template-customizer-core-css"/>
	<link rel="stylesheet" href="assets/vendor/css/rtl/theme-default.css" class="template-customizer-theme-css"/>
	<link rel="stylesheet" href="assets/css/demo.css"/>
	<link rel="stylesheet" href="assets/vendor/libs/node-waves/node-waves.css"/>
	<link rel="stylesheet" href="assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.css"/>
	<link rel="stylesheet" href="assets/vendor/libs/typeahead-js/typeahead.css"/>
	<link rel="stylesheet" href="assets/vendor/css/pages/page-auth.css"/>
	<script src="assets/vendor/js/helpers.js"></script>
	<script src="assets/js/config.js"></script>
	<script src="assets/js/jquery.min.js"></script>
	<link rel="stylesheet" href="assets/toastr.min.css">
	<script src="assets/toastr.min.js"></script>
</head>

<body>
<?php
session_start();
require_once "inc/db.php"; // $conn connection file

if ($_SERVER["REQUEST_METHOD"] === "POST") {
    $username = trim($_POST["username"]);
    $password = $_POST["password"];

    if (empty($username) || empty($password)) {
        echo "<script>toastr.error('Username and password are required.');</script>";
        exit;
    }

    // Allow both admin and sales
    $stmt = $conn->prepare("
        SELECT id, username, password, name, role 
        FROM users 
        WHERE username = ? 
          AND status = 'active' 
          AND role IN ('admin', 'sales')
    ");
    $stmt->bind_param("s", $username);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result && $result->num_rows > 0) {
        $row = $result->fetch_assoc();

        if (password_verify($password, $row['password'])) {
            // --- Set session ---
            $_SESSION["userid"] = $row['id'];
            $_SESSION["userrole"] = $row['role'];
            $_SESSION["username"] = $row['name'];

            // --- Update last login ---
            date_default_timezone_set("Asia/Calcutta");
            $currentDateTime = date('Y-m-d H:i:s');
            $update = $conn->prepare("UPDATE users SET last_login = ? WHERE id = ?");
            $update->bind_param("si", $currentDateTime, $row['id']);
            $update->execute();

            // --- Handle "Remember Me" ---
            if (!empty($_POST["remember"])) {
                setcookie('userid', $row['id'], time() + (30 * 24 * 60 * 60), '/');
                setcookie('userrole', $row['role'], time() + (30 * 24 * 60 * 60), '/');
                setcookie('username', $row['name'], time() + (30 * 24 * 60 * 60), '/');
            } else {
                setcookie('userid', '', time() - 3600, '/');
                setcookie('userrole', '', time() - 3600, '/');
                setcookie('username', '', time() - 3600, '/');
            }

            // --- Redirect based on role ---
            if ($row['role'] === 'admin') {
                echo "<script>window.location.href = 'dashboard.php';</script>";
            } elseif ($row['role'] === 'sales') {
                echo "<script>window.location.href = 'dashboard.php';</script>";
            } else {
                echo "<script>toastr.error('Unauthorized role.');</script>";
            }
        } else {
            echo "<script>toastr.error('Invalid password.');</script>";
        }
    } else {
        echo "<script>toastr.error('User not found or inactive.');</script>";
    }

    $stmt->close();
    $conn->close();
}
?>

<div class="container-xxl">
      <div class="authentication-wrapper authentication-basic container-p-y">
        <div class="authentication-inner py-4">
          <!-- Login -->
          <div class="card">
            <div class="card-body">
              <!-- Logo -->
              <div class="app-brand justify-content-center mb-4 mt-2" >
              <img src="assets/img/logo.png" width="300" alt="My Treasure Trip" style="background:none; width:300px" >
               </div>
                         
              <form  class="mb-3" action="#" method="POST">
                <div class="mb-3">
                  <label for="username" class="form-label">Username</label>
                  <input type="text" class="form-control" name="username" placeholder="username"  autofocus />
                </div>
                <div class="mb-3 form-password-toggle">
                  <div class="d-flex justify-content-between">
                    <label class="form-label" for="password">Password</label>
                  </div>
                  <div class="input-group input-group-merge">
                    <input  type="password" class="form-control" name="password"  placeholder="&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;"
                      aria-describedby="password" />
                    <span class="input-group-text cursor-pointer"><i class="ti ti-eye-off"></i></span>
                  </div>
                </div>
                <div class="mb-3 my-8">
                  <div class="d-flex justify-content-between">
                    <div class="form-check mb-0 ms-2">
                     <input class="form-check-input" type="checkbox" id="remember-me" name="remember" />
                      <label class="form-check-label" for="remember-me"> Remember Me </label>
                    </div>
                    <!--<a href="#">-->
                    <!--  <p class="mb-0">Forgot Password?</p>-->
                    <!--</a>-->
                  </div>
                </div>
                
                                    
                <div class="mb-3">
				<button class="btn btn-primary d-grid w-100" type="submit" name="login">Login</button>
                </div>
              </form>
        
            </div>
          </div>
          <!-- /Register -->
        </div>
      </div>
    </div>
	<script src="assets/vendor/libs/jquery/jquery.js"></script>
	<script src="assets/vendor/libs/popper/popper.js"></script>
	<script src="assets/vendor/js/bootstrap.js"></script>
	<script src="assets/vendor/libs/node-waves/node-waves.js"></script>
	<script src="assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.js"></script>
	<script src="assets/vendor/libs/hammer/hammer.js"></script>
	<script src="assets/vendor/libs/i18n/i18n.js"></script>
	<script src="assets/vendor/libs/typeahead-js/typeahead.js"></script>
	<script src="assets/vendor/js/menu.js"></script>
	<script src="assets/js/main.js"></script>
	<script src="assets/js/pages-auth.js"></script>
</body>
</html>