<?php
session_start();
require_once "inc/db.php";

// --- Auto-login from cookies if session not set ---
if (!isset($_SESSION['userid']) && isset($_COOKIE['userid'], $_COOKIE['userrole'], $_COOKIE['username'])) {
    $_SESSION['userid'] = $_COOKIE['userid'];
    $_SESSION['userrole'] = $_COOKIE['userrole'];
    $_SESSION['username'] = $_COOKIE['username'];
}

$userId = $_SESSION['userid'] ?? null;
$userRole = $_SESSION['userrole'] ?? null;
$userName = $_SESSION['username'] ?? null;

// --- Check login ---
if (!$userId || !$userRole || !$userName) {
    alertAndRedirect('Please log in first.', 'index.php');
}

// --- Check account status in DB ---
$stmt = $conn->prepare("SELECT status FROM users WHERE id = ?");
$stmt->bind_param("i", $userId);
$stmt->execute();
$result = $stmt->get_result();

if ($result && $result->num_rows > 0) {
    $user = $result->fetch_assoc();
    if (strtolower($user['status']) !== 'active') {
        clearSessionAndCookies();
        alertAndRedirect('Your account has been deactivated. Please contact support.', 'index.php');
    }
} else {
    clearSessionAndCookies();
    alertAndRedirect('Account not found. Please login again.', 'index.php');
}

// --- Helper Functions ---
function clearSessionAndCookies()
{
    session_unset();
    session_destroy();
    setcookie('userid', '', time() - 3600, '/');
    setcookie('userrole', '', time() - 3600, '/');
    setcookie('username', '', time() - 3600, '/');
}

function alertAndRedirect($message, $url)
{
    echo "<script>alert('$message'); window.location.href = '$url';</script>";
    exit();
}
?>
