<?php include( 'inc/template.php' );?>
<div class="container-fluid flex-grow-1 container-p-y">
	<nav aria-label="breadcrumb">
	<ol class="breadcrumb">
    <li class="breadcrumb-item"><a href="index.php">Home</a></li>
	<li class="breadcrumb-item"><a href="hotel_add.php">Hotel Add</a></li>
    <li class="breadcrumb-item">Hotel List</li>
    </ol>
</nav>
<div class="card">
<div class="card-datatable table-responsive pt-0">
<table id="packageTable" class="table table-bordered table-responsive">
    <thead>
        <tr>
            <th>Hotel Name</th>
			<th>Address</th>
			 <th>City</th>
            <th>Star</th>
            <th>Status</th>
            <th>Action</th>
        </tr>
    </thead>
</table>


</div>
</div>
</div>
<script>
$(document).ready(function () {
    // Initialize DataTable with server-side processing
  $('#packageTable').DataTable({
        processing: true,
        serverSide: true,
        ajax: {
            url: 'controller/HotelController.php',
            type: 'POST',
            data: function(d) {
                d.action = 'List'; // must match PHP
            }
        },
        columns: [
            { data: 'hotel_name', title: 'Hotel Name' },
            { data: 'address', title: 'Address' },
            { data: 'destination', title: 'City' },
            { data: 'stars', title: 'Star' },
            { data: 'status', orderable: false, searchable: false },
            { data: 'action', orderable: false, searchable: false }
        ],
        order: [[0, 'asc']], // sort by Hotel Name initially
        pageLength: 25
    });


    // Status change
    window.statusChange = function (id) {
        $.post('controller/HotelController.php', { id: id, action: 'ToggleStatus' }, function(res){
            if(res.status === 'success'){
                toastr.success(`Status changed to ${res.new_status}`);
                table.ajax.reload(null, false); // Reload table without resetting pagination
            } else {
                toastr.error(res.message);
            }
        }, 'json');
    };

    // Delete row
    $(document).on('click', '.delete', function () {
        const id = $(this).attr("id");
        if(confirm('Are you sure you want to delete this package?')){
            $.post('controller/HotelController.php', { id: id, action: 'Delete' }, function(res){
                if(res.status === 'success'){
                    toastr.success(res.message);
                    table.ajax.reload(null, false); // Reload table without resetting pagination
                } else {
                    toastr.error(res.message);
                }
            }, 'json');
        }
    });
});
</script>
<?php include('inc/footer.php');?>