<?php
$book_id = isset($_GET['book_id']) ? intval($_GET['book_id']) : 0;
$current_page = basename($_SERVER['PHP_SELF']); 
$breadcrumb_title = ($current_page == 'hotel_booking_payment.php') ? 'Payment History' : 'Hotel Details';
/* -------------------------------
   FETCH BOOKING + CUSTOMER + USER
--------------------------------*/
$sql = "
SELECT 
    b.*, 
    c.name AS customer_name,
    c.email AS customer_email,
    c.phone AS customer_phone,
    c.address AS customer_address,
	pc.category_name,
    u.name AS assigned_to_name
FROM bookings b
LEFT JOIN customers c ON b.customer_id = c.id
LEFT JOIN package_categories pc ON b.category_id = pc.id
LEFT JOIN users u ON b.created_by = u.id
WHERE b.id = ?
";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $book_id);
$stmt->execute();
$result = $stmt->get_result();
$row = $result->fetch_assoc();

if (!$row) {
    die("Booking not found.");
}


/* -------------------------------
   FETCH TOTAL ADVANCE PAYMENT
--------------------------------*/
$payment_sql = "
SELECT 
    SUM(amount) AS total_credit
FROM payments
WHERE booking_id = ? 
AND payment_type = 'received'
AND status = 'completed'
";
$pay_stmt = $conn->prepare($payment_sql);
$pay_stmt->bind_param("i", $book_id);
$pay_stmt->execute();
$pay_res = $pay_stmt->get_result()->fetch_assoc();
$total_credit = $pay_res['total_credit'] ?? 0;

/* -------------------------------
   CALCULATIONS
--------------------------------*/
$subtotal = (float)$row['total_amount'];
$discount_amt = (float)$row['discount_amount'];
$gst_amt = (float)$row['gst_amount'];
$grand_total = $subtotal;
$due_total = $grand_total - $total_credit;

/* -------------------------------
   STATUS COLOR
--------------------------------*/
$statusclass = match(strtolower($row['status'])) {
    'pending'   => 'bg-warning',
    'confirmed' => 'bg-success',
    'cancelled' => 'bg-danger',
    'completed' => 'bg-secondary',
    default     => 'bg-info'
};
$breadcrumbLink = ($row['gst_included'] === 'yes') ? 'hotel_booking_list.php' : 'hotel_booking_list.php';
$sql = "
SELECT 
    p.*, 
    c.name AS customer_name, 
    u.name AS received_by_name
FROM payments p
LEFT JOIN customers c ON p.customer_id = c.id
LEFT JOIN users u ON p.received_by = u.id
WHERE p.booking_id = ?
ORDER BY p.payment_date DESC
";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $book_id);
$stmt->execute();
$payment_result = $stmt->get_result();
?>
<nav aria-label="breadcrumb">
    <ol class="breadcrumb">
        <li class="breadcrumb-item"><a href="index.php">Home</a></li>
        <li class="breadcrumb-item"><a href="<?php echo $breadcrumbLink; ?>">Hotel Booking List</a></li>
        <li class="breadcrumb-item active" aria-current="page"><?= $breadcrumb_title; ?></li>
    </ol>
</nav>

<div class="row">
    <div class="col-md-12">
        <div class="nav-align-top">
            <ul class="nav nav-pills flex-column flex-sm-row mb-6 gap-2 gap-lg-0">
                <li class="nav-item">
                    <a class="nav-link <?= ($current_page == 'hotel_booking_details.php') ? 'active' : ''; ?>" 
                       href="hotel_booking_details.php?book_id=<?= urlencode($book_id); ?>">
                        Package Details
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link <?= ($current_page == 'hotel_booking_payment.php') ? 'active' : ''; ?>" 
                       href="hotel_booking_payment.php?book_id=<?= urlencode($book_id); ?>">
                        Payment History
                    </a>
                </li>
            </ul>
        </div>
    </div>
</div>
