<?php include( 'inc/template.php' ); ?>
<div class="container-fluid flex-grow-1 container-p-y">
	<?php include('hotel_booking_header.php');?>
	
	<div class="row">
		<div class="col-xl-12 col-lg-5 col-md-5">
			<div class="accordion mt-3" id="accordionExample">
				<div class="card accordion-item active">
					<h2 class="accordion-header" id="headingOne">
                        <button type="button" class="accordion-button" data-bs-toggle="collapse" data-bs-target="#accordionOne" aria-expanded="true" aria-controls="accordionOne">
                          Hotel Details
                        </button>
                      </h2>
				

					<div id="accordionOne" class="accordion-collapse collapse show" data-bs-parent="#accordionExample">
						<div class="accordion-body">

							<?php $statusclass = strtolower($row['status']) == 'pending' ? 'bg-warning' :
    (strtolower($row['status']) == 'confirmed' ? 'bg-success' :
    (strtolower($row['status']) == 'cancelled' ? 'bg-danger' :
    (strtolower($row['status']) == 'completed' ? 'bg-secondary' : 'bg-info')));?>
							<div class="d-flex flex-wrap">
								<div class="me-5">
									<p class="text-nowrap">
										<i class="ti ti-calendar ti-sm me-2 mt-n2"></i>Book Date:
										<?php echo htmlspecialchars(date('d-m-Y', strtotime($row['booking_date']))); ?>
									</p>
									
									<p class="text-nowrap"><i class="ti ti-users ti-sm me-2 mt-n2"></i>Name:
										<?php echo htmlspecialchars(ucwords(strtolower($row['customer_name']))); ?>
									</p>
									<p class="text-nowrap"><i class="ti ti-map-pin ti-sm me-2 mt-n2"></i>Address:
										<?php echo htmlspecialchars(ucwords(strtolower($row['customer_address']))); ?>
									</p>
									<p class="text-nowrap"><i class="ti ti-phone-call ti-sm me-2 mt-n2"></i>Contact: +91
										<?php echo htmlspecialchars($row['customer_phone']); ?>
									</p>
									<p class="text-nowrap"><i class="ti ti-mail ti-sm me-2 mt-n2"></i>Email:
										<?php echo htmlspecialchars($row['customer_email']); ?>
									</p>
									
								</div>
								<div>
									<p class="text-nowrap"><i class="ti ti-search ti-sm me-2 mt-n2"></i>Book No.:
										<?php echo htmlspecialchars($row['booking_code']); ?>
									</p>
									
									<p class="text-nowrap">
										<i class="ti ti-clock ti-sm me-2 mt-n2"></i>Status:
										<span class="badge <?php echo $statusclass; ?> bg-glow">
											<?php echo htmlspecialchars(ucwords(strtolower($row['status']))); ?>
										</span>
									</p>
									
									<p class="text-nowrap">
										<i class="ti ti-calendar ti-sm me-2 mt-n2"></i>Assign to:
										<?php echo htmlspecialchars(ucwords(strtolower($row['assigned_to_name']))); ?>
									</p>
								</div>
							</div>
							<h5 class="mt-4">Hotel Details</h5>
							<div class="table-responsive text-nowrap">
								<table class="table table-bordered table-sm">

									<tbody>
										<tr>
											<td>Hotel Name</td>
											<td>
												<?php echo htmlspecialchars(ucwords($row['hotel_name'])); ?>&nbsp;(<?php echo htmlspecialchars($row['hotel_type']); ?>*)
											</td>
											</tr>
										<tr>
											<td>Hotel City</td>
											<td>
												<?php echo htmlspecialchars(ucwords($row['hotel_city'])); ?>
											</td>
										</tr>
										
										<tr>
											<td>Checkin/Checkout</td>
											<td>
												<?php echo htmlspecialchars(date('d-m-Y', strtotime($row['hotel_checkin_date']))); ?> to <?php echo htmlspecialchars(date('d-m-Y', strtotime($row['hotel_checkin_date']))); ?>
											</td>
											</tr>
											<tr>
											<td>No. of Nights</td>
											
										
											<td>
    <?php
        $start_date = new DateTime($row['hotel_checkin_date']);
        $end_date   = new DateTime($row['hotel_checkin_date']);
        $interval   = $start_date->diff($end_date);
        echo $interval->days . ' Nights';
    ?>
</td>
										</tr>
										<tr>
											<td>No. of Rooms</td>
											
										
											<td>
    									<?php echo htmlspecialchars($row['hotel_rooms']); ?>
											</td>
										</tr>
										<tr>
											
											<?php /*?><td>Total Rooms</td>
											<td>
												<?php echo htmlspecialchars($row['rooms']); ?>
											</td><?php */?>
											<td>Guests (Adult/Child)</td>
											<td>
												<?php echo htmlspecialchars($row['hotel_adults']); ?> Adults /
												<?php echo htmlspecialchars($row['hotel_children']); ?> Child</td>
										</tr>
										
										<tr>
											<td>Extra Bed</td>
											<td>
												<?php echo htmlspecialchars($row['hotel_extrabed']); ?>
											</td>
											
										</tr>
										<tr>
											<td>Room Type</td>
											<td>
												<?php echo htmlspecialchars($row['hotel_room_type']); ?>
											</td>
											
										</tr>
										<tr>
											<td>Meal Type</td>
											<td>
												<?php echo htmlspecialchars($row['meal_plan']); ?>
											</td>
											
										</tr>
										<?php /*?><tr>
											<td>Special Request</td>
											<td>
												<?php echo htmlspecialchars($row['special_request']); ?>
											</td>
											
										</tr><?php */?>

									</tbody>
								</table>
							</div>
							<?php /*?><h5 class="mt-4">Hotel Details</h5>
							<div class="table nsive text-nowrap">
								<?php
							$sql = "SELECT hotel_name, hotel_location, hotel_rooms, hotel_type, meal_plan 
									FROM package_categories 
									WHERE booking_id = ?";
							$stmt = $conn->prepare($sql);
							$stmt->bind_param("i", $packagebooking_id);
							$stmt->execute();
							$result = $stmt->get_result();
							?>

							<table class="table table-bordered table-sm">
								<thead>
									<tr>
										<th>Hotel Name</th>
										<th>Location</th>
										<th>Room</th>
										<th>Hotel Type</th>
										<th>Meal Plan</th>
									</tr>
								</thead>
								<tbody>
									<?php while ($hotelrow = $result->fetch_assoc()): ?>
										<tr>
											<td><?= htmlspecialchars(ucwords($hotelrow['hotel_name'])) ?></td>
											<td><?= htmlspecialchars(ucwords($hotelrow['hotel_location'])) ?></td>
											<td><?= htmlspecialchars($hotelrow['hotel_rooms']) ?></td>
											<td><?= htmlspecialchars(ucwords($hotelrow['hotel_type'])) ?></td>
											<td><?= htmlspecialchars(ucwords($hotelrow['meal_plan'])) ?></td>
										</tr>
									<?php endwhile; ?>
								</tbody>
							</table>

							</div><?php */?>
							<h5 class="mt-4">Pricing Details</h5>
							<div class="table-responsive text-nowrap">
								<table class="table table-bordered table-sm">

									<tbody>
										<tr>
											<td>Room Price (<?= htmlspecialchars($row['hotel_rooms']) ?> × <?= htmlspecialchars($row['adult_price']) ?>)</td>
											<td><?= number_format((float)$row['adult_price'] * (int)$row['hotel_rooms'], 2) ?></td>

										</tr>
										<?php if ($row['hotel_children'] > 0) { ?>
										<tr>
											<td>Child Price (<?= htmlspecialchars($row['hotel_children']) ?>)</td>
											<td><?= number_format((float)$row['child_price'], 2) ?></td>
										</tr>
										<?php } ?>
										<?php if ($row['hotel_extrabed'] > 0) { ?>
										<tr>
											<td>Extra Bed (<?= htmlspecialchars($row['hotel_extrabed']) ?>)</td>
											<td><?= number_format((float)$row['extra_bed_price'], 2) ?></td>
										</tr>
										<?php } ?>
										
										<?php if ($row['discount'] > 0) {?>
										<tr>
											<td>Discount (<?= htmlspecialchars($row['discount']) ?>%)</td>
											<td><?= number_format((float)$row['discount_amount'], 2) ?></td>
										</tr>
										<?php } ?>
										<?php if ($row['gst_included'] === 'yes') { ?>
										<tr>
											<td>GST (<?= htmlspecialchars($row['gst_rate']) ?>%)</td>
											<td><?= number_format((float)$row['gst_amount'], 2) ?></td>
										</tr>
										<?php }?>
										<?php if (!empty($row['transport_charges']) && $row['transport_charges'] > 0) { ?>
<tr>
    <td>Transport Charges (<?= ucwords($row['vehicle_type'] ?? '-') ?>)</td>
    <td><?= number_format((float)$row['transport_charges'], 2) ?></td>
</tr>
<?php } ?>
										<tr>
    <td><b>Grand Total</b></td>
    <td><b><?= number_format((float)$row['total_amount'], 2) ?></b></td>
</tr>
<tr>
    <td><b>Advance Total</b></td>
    <td><b><?= number_format((float)$total_credit, 2) ?></b></td>
</tr>
<tr>
    <td><b>Due Total</b></td>
    <td><b><?= number_format((float)($row['total_amount'] - $total_credit), 2) ?></b></td>
</tr>

										
									</tbody>
								</table>
							</div>
						</div>

						

					</div>
				</div>
				

			</div>

		</div>

	</div>
</div>
<?php include('inc/footer.php');?>