<?php include( 'inc/template.php' );?>
<div class="container-fluid flex-grow-1 container-p-y">
	<nav aria-label="breadcrumb">
		<ol class="breadcrumb">
			<li class="breadcrumb-item"><a href="index.php">Home</a>
			</li>
			<li class="breadcrumb-item"><a href="booking_list_with_gst.php">Hotel Booking List</a>
			</li>
			<li class="breadcrumb-item active">
				<?php echo isset($_GET['id']) ? 'Update Hotel Booking' : 'Hotel Booking Add'; ?>
			</li>
		</ol>
	</nav>
	<div class="row">
		<div class="col-9">
			<div class="card shadow p-4">
				<form method="post" enctype="multipart/form-data">
					<!-- Customer Details -->
					<div class="row g-3">

						<div class="col-md-4">
							<label for="package_id" class="form-label">Booking Date</label>
							<input type="date" id="booking_date" name="booking_date" class="form-control" required value="<?php echo date('Y-m-d'); ?>"/>

						</div>
						<div class="col-md-8">
							<label for="customer_id" class="form-label">Customer Name</label>
							<input type="hidden" id="inquiry_id" name="inquiry_id" />
							<select name="customer_id" id="customer_id" required class="select2 form-select form-select-lg">
								<option value="">Select Customer</option>

								<!-- In-Progress Inquiry Customers -->
								<optgroup label="In-Progress Inquiries">
									<?php
									$inProgress = $conn->query( "SELECT c.id AS customer_id,c.name,c.phone, i.id AS inquiry_id FROM customers c INNER JOIN inquiries i ON c.id = i.customer_id AND i.inquiry_type = 'hotel' AND i.status = 'in-progress' WHERE c.status = 'active' ORDER BY c.name ASC" );
									if ( $inProgress->num_rows > 0 ) {
										while ( $row = $inProgress->fetch_assoc() ) {
											echo '<option value="' . $row[ 'customer_id' ] . '" data-inquiry="' . $row[ 'inquiry_id' ] . '">'
											. htmlspecialchars( ucwords( strtolower( $row[ 'name' ] ) ) ) . ' (' . $row[ 'phone' ] . ')'
											. '</option>';
										}
									} else {
										echo '<option disabled>No in-progress inquiries</option>';
									}
									?>
								</optgroup>

								<!-- Other Customers (no in-progress inquiry) -->
								<optgroup label="Other Customers">
									<?php
									$others = $conn->query( "SELECT c.id AS customer_id, c.name, c.phone FROM customers c WHERE c.status = 'active' AND c.id NOT IN ( SELECT customer_id FROM inquiries WHERE status = 'in-progress' AND inquiry_type = 'package' ) ORDER BY c.name ASC" );
									if ( $others->num_rows > 0 ) {
										while ( $row = $others->fetch_assoc() ) {
											echo '<option value="' . $row[ 'customer_id' ] . '" data-inquiry="">'
											. htmlspecialchars( ucwords( strtolower( $row[ 'name' ] ) ) ) . ' (' . $row[ 'phone' ] . ')'
											. '</option>';
										}
									} else {
										echo '<option disabled>All customers have in-progress inquiries</option>';
									}
									?>
								</optgroup>
							</select>

						</div>
						<!-- Destination (City) -->
						<div class="col-md-6 position-relative">
							<label class="form-label">Destination (City)</label>
							<input type="text" name="destination" id="destination" class="form-control" autocomplete="off" required>
							<input type="hidden" name="hotel_city_id" id="hotel_city_id">
							<div id="citySuggestions" class="list-group position-absolute w-100 bg-white shadow-sm rounded-2" style="z-index:1050; max-height:250px; overflow-y:auto;"></div>
						</div>

						<!-- Hotel Dropdown -->
						<div class="col-md-6">
							<label for="hotel_id" class="form-label">Hotel Name</label>
							<select name="hotel_id" id="hotel_id" class="form-select" required>
								<option value="">Select City First</option>
							</select>
						</div>

						<!-- Package -->



						<div class="col-md-4">
							<label for="hotel_checkin_date" class="form-label">Check in Date</label>
							<input type="date" id="hotel_checkin_date" name="hotel_checkin_date" class="form-control" required min="<?= date('Y-m-d'); ?>" />

						</div>
						<div class="col-md-4">
							<label for="hotel_checkout_date" class="form-label">Check out Date</label>
							<input type="date" id="hotel_checkout_date" name="hotel_checkout_date" class="form-control" required min="<?= date('Y-m-d'); ?>"/>
						</div>

						<div class="col-md-4">
							<label for="rooms" class="form-label">No. of Rooms</label>
							<input type="number" id="hotel_rooms" name="hotel_rooms" min="1" max="100" class="form-control" value="1"/>
						</div>
						<div class="col-md-4">
							<label for="rooms" class="form-label">Room Type</label>

							<select name="hotel_room_type" id="hotel_room_type" class="form-select">
								<option value="">Select Room Type</option>
								<!-- Basic -->
								<option value="Standard Room">Standard Room</option>
								<option value="Single Room">Single Room</option>
								<option value="Double Room">Double Room</option>
								<option value="Twin Room">Twin Room</option>
								<option value="Triple Room">Triple Room</option>
								<option value="Economy Room">Economy Room</option>

								<!-- Mid-Range -->
								<option value="Deluxe Room">Deluxe Room</option>
								<option value="Super Deluxe Room">Super Deluxe Room</option>
								<option value="Executive Room">Executive Room</option>
								<option value="Premium Room">Premium Room</option>
								<option value="Family Room">Family Room</option>

								<!-- Luxury -->
								<option value="Club Room">Club Room</option>
								<option value="Suite Room">Suite Room</option>
								<option value="Junior Suite">Junior Suite</option>
								<option value="Executive Suite">Executive Suite</option>
								<option value="Presidential Suite">Presidential Suite</option>
								<option value="Royal Suite">Royal Suite</option>
								<option value="Penthouse Suite">Penthouse Suite</option>

								<!-- View-Based -->
								<option value="Garden View Room">Garden View Room</option>
								<option value="City View Room">City View Room</option>
								<option value="Pool View Room">Pool View Room</option>
								<option value="Sea View Room">Sea View Room</option>
								<option value="Mountain View Room">Mountain View Room</option>

								<!-- Exclusive / Resort -->
								<option value="Cottage">Cottage</option>
								<option value="Bungalow">Bungalow</option>
								<option value="Villa">Villa</option>
								<option value="Luxury Villa">Luxury Villa</option>
								<option value="Private Pool Villa">Private Pool Villa</option>

								<!-- Others -->
								<option value="Heritage Room">Heritage Room</option>
								<option value="Tent Room">Tent Room</option>
								<option value="Dormitory">Dormitory</option>
								<option value="Studio Room">Studio Room</option>
								<option value="Serviced Apartment">Serviced Apartment</option>
							</select>

						</div>
						<!--<div class="col-md-4">
							<label for="rooms" class="form-label">Preferred Accommodation</label>
							<select name="meal_plan[]" data-name="meal_plan" class="form-select" required>
								<option value="hotel">Hotel</option>
    <option value="villa">Villa</option>
    <option value="apartment">Apartment</option>
    <option value="resort">Resort</option>
    <option value="homestay">Homestay</option>
    <option value="hostel">Hostel</option>
							</select>
						</div>-->
						<div class="col-md-4">
							<label for="rooms" class="form-label">Meal Type</label>
							<select name="meal_plan[]" data-name="meal_plan" class="form-select" required>
								<option value="">Select</option>
								<option value="CP">CP (Room + Breakfast)</option>
								<option value="MAP">MAP (Room + Breakfast + Dinner)</option>
								<option value="AP">AP (Room + All Meals)</option>
							</select>
						</div>
						

					</div>

					<!-- Pricing -->
					<div class="row g-3 mt-2">
						<h5>Hotel Pricing (Per Person)</h5>
						<div class="col-md-4">
							<label for="rooms" class="form-label">Adult</label>
							<input type="number" id="hotel_adults" name="hotel_adults" min="1" max="100" class="form-control" value="1"/>
						</div>
						<div class="col-md-4">
							<label for="rooms" class="form-label">Child</label>
							<input type="number" id="hotel_children" name="hotel_children" min="0" max="100" class="form-control" value="0"/>
						</div>
						<div class="col-md-4">
							<label for="rooms" class="form-label">Extra bed</label>
							<input type="number" id="hotel_extrabed" name="hotel_extrabed" min="0" max="100" class="form-control" value="0"/>
						</div>
						<div class="col-md-4">
							<label>Room Price (INR)</label>
							<input type="number" name="adult_price" id="adult_price" class="form-control" required>
						</div>
						<div class="col-md-4">
							<label>Child Price (INR)</label>
							<input type="number" name="child_price" id="child_price" class="form-control">
						</div>
						<div class="col-md-4">
							<label>Extra Bed Price (INR)</label>
							<input type="number" name="extra_bed_price" id="extra_bed_price" class="form-control">
						</div>
					</div>

					<!-- Other Charges -->
					<div class="row g-3 mt-2">
						<h5>Other Charges</h5>
						<div class="col-md-3">
							<label>Transport Type</label>
							<select name="transport_type" id="transport_type" class="form-select">
								<option value="">Select Vehicle</option>
								<?php
								$query = "SELECT id, vehicle_type FROM vehicles WHERE status='active' ORDER BY id ASC";
								$result = mysqli_query( $conn, $query );
								while ( $r = mysqli_fetch_assoc( $result ) ) {
									echo "<option value='{$r['vehicle_type']}'>{$r['vehicle_type']}</option>";
								}
								?>
							</select>
						</div>
						<div class="col-md-3">
							<label>Transport Charges (INR)</label>
							<input type="number" name="transport_charges" id="transport_charges" class="form-control" value="0">
						</div>
						<!--
    <div class="col-md-3">
      <label>Extra Charges (INR)</label>
      <input type="number" name="extra_charges" id="extra_charges" class="form-control" value="0">
    </div>
-->
						<div class="col-md-3">
							<label for="gst_included" class="form-label">With GST?</label>
							<select id="gst_included" name="gst_included" class="form-select" required>
<!--            <option value="no">No</option>-->
			  <option value="yes">Yes</option>
             </select>
						
						</div>

						<input type="hidden" name="gst" id="gst" class="form-control" value="5">

						<div class="col-md-3">
							<label>Discount %</label>
							<input type="number" name="discount" id="discount" class="form-control" value="0">
						</div>
						<div class="col-md-6">
							<label>Grand Total (INR)</label>
							<input type="text" name="grand_total" id="grand_total" class="form-control" readonly>
						</div>
					</div>

					<!-- Total -->

					<!-- Payment Mode and Advance Payment -->
					<div class="row g-3 mt-2">
						<!-- Payment Mode -->
						<div class="col-md-4">
							<label for="payment_mode" class="form-label">Payment Mode</label>
							<select name="payment_mode" id="payment_mode" class="form-select" required>
								<option value="">Select Mode</option>
								<option value="cash">Cash</option>
								<option value="upi">UPI</option>
								<option value="bank">Bank Transfer</option>
								<option value="card">Card</option>
								<option value="online">Online</option>
							</select>
						</div>

						<!-- UPI Details -->
						<div class="col-md-4" id="upi_details_group" style="display:none;">
							<label for="upi_id" class="form-label">UPI ID</label>
							<input type="text" name="upi_id" id="upi_id" class="form-control" placeholder="e.g. username@upi">
						</div>

						<!-- Bank Details -->
						<div class="col-md-4" id="bank_details_group" style="display:none;">
							<label for="bank_name" class="form-label">Bank Name</label>
							<input type="text" name="bank_name" id="bank_name" class="form-control" placeholder="Bank Name">
						</div>

						<div class="col-md-4" id="account_no_group" style="display:none;">
							<label for="account_no" class="form-label">Account / Cheque No</label>
							<input type="text" name="account_no" id="account_no" class="form-control" placeholder="Account or Cheque Number">
						</div>

						<div class="col-md-4" id="transaction_id_group" style="display:none;">
							<label for="transaction_id" class="form-label">Transaction / Reference ID</label>
							<input type="text" name="transaction_id" id="transaction_id" class="form-control" placeholder="Transaction ID">
						</div>

						<!-- Advance Payment -->
						<div class="col-md-4" id="advance_payment_group" style="display:none;">
							<label for="advance_payment" class="form-label">Advance Payment (INR)</label>
							<input type="number" name="advance_payment" id="advance_payment" class="form-control" min="1" placeholder="Enter amount">
						</div>
					</div>

					<script>
						$( document ).ready( function () {
							$( '#payment_mode' ).on( 'change', function () {
								const mode = $( this ).val();

								// Hide all optional sections first
								$( '#upi_details_group, #bank_details_group, #account_no_group, #transaction_id_group, #advance_payment_group' ).hide();

								// Remove required from all
								$( '#upi_id, #bank_name, #account_no, #transaction_id, #advance_payment' ).prop( 'required', false );

								// Clear old values
								$( '#upi_id, #bank_name, #account_no, #transaction_id, #advance_payment' ).val( '' );

								// Show based on mode
								if ( mode === 'upi' ) {
									$( '#upi_details_group, #transaction_id_group, #advance_payment_group' ).show();
									$( '#upi_id, #transaction_id, #advance_payment' ).prop( 'required', true );
								} else if ( mode === 'bank' || mode === 'card' || mode === 'online' ) {
									$( '#bank_details_group, #account_no_group, #transaction_id_group, #advance_payment_group' ).show();
									$( '#bank_name, #account_no, #transaction_id, #advance_payment' ).prop( 'required', true );
								} else if ( mode === 'cash' ) {
									$( '#advance_payment_group' ).show();
									$( '#advance_payment' ).prop( 'required', true );
								}
							} );

							// Prevent submission if payment = 0 or mode not selected
							$( 'form' ).on( 'submit', function ( e ) {
								const mode = $( '#payment_mode' ).val();
								const payment = parseFloat( $( '#advance_payment' ).val() || 0 );

								if ( !mode ) {
									alert( 'Please select a payment mode.' );
									e.preventDefault();
									return false;
								}

								if ( payment <= 0 ) {
									alert( 'Advance payment must be greater than 0.' );
									e.preventDefault();
									return false;
								}
							} );
						} );
					</script>

					<!-- Hidden Fields -->
					<input type="hidden" name="useridnew" value="<?php echo $userId; ?>"/>
					<input type="hidden" name="id" value="<?php echo isset($_GET['id']) ? $_GET['id'] : ''; ?>"/>
					<input type="hidden" name="action" value="<?php echo isset($_GET['id']) ? 'Update' : 'Create'; ?>"/>
					<div class="mt-4">
						<button type="submit" class="btn btn-primary me-2">
							<?php echo isset($_GET['id']) ? 'Update' : 'Save'; ?>
						</button>
						<button type="submit" id="download-pdf" class="btn btn-primary me-2">
							<?php echo isset($_GET['id']) ? 'Download PDF' : 'Download PDF'; ?>
						</button>

						<button type="reset" class="btn btn-secondary">Reset</button>
					</div>
				</form>
			</div>
		</div>
		<div class="col-3">
  <div class="card shadow p-4 sticky-card">
    <div class="row g-3">
      <h5>Hotel Inquiry Detail</h5>

      <div class="col-md-12">
        <label class="form-label">Hotel Name</label>
        <input type="text" id="hotel_name" class="form-control" readonly>
      </div>

      <div class="col-md-12">
        <label class="form-label">Hotel City</label>
        <input type="text" id="hotel_city" class="form-control" readonly>
      </div>

      <div class="col-md-12">
        <label class="form-label">Check-in</label>
        <input type="text" id="checkin_date" class="form-control" readonly>
      </div>

      <div class="col-md-12">
        <label class="form-label">Check-out</label>
        <input type="text" id="checkout_date" class="form-control" readonly>
      </div>

      <div class="col-md-12">
        <label class="form-label">Rooms</label>
        <input type="text" id="rooms" class="form-control" readonly>
      </div>

      <div class="col-md-12">
        <label class="form-label">Adults</label>
        <input type="text" id="adults" class="form-control" readonly>
      </div>

      <div class="col-md-12">
        <label class="form-label">Children</label>
        <input type="text" id="children" class="form-control" readonly>
      </div>

      <div class="col-md-12">
        <label class="form-label">Remarks</label>
        <textarea id="remarks" class="form-control" rows="4" readonly></textarea>
      </div>
    </div>
  </div>
</div>

	</div>
</div>
<script>
	$(document).ready(function () {
  $('#customer_id').on('change', function () {
    const customerId = $(this).val();

    if (customerId) {
      $.ajax({
        url: 'ajax/fetchInquiryDetails.php',
        type: 'POST',
        data: { customer_id: customerId },
        dataType: 'json',
        beforeSend: function () {
          $('#inquiry_id,#hotel_name, #hotel_city, #checkin_date, #checkout_date, #rooms, #adults, #children, #remarks').val('');
        },
        success: function (res) {
          if (res.status === 'success') {
            const d = res.hotel || {}; // ✅ use res.hotel here

            function formatDate(dateStr) {
              if (!dateStr) return '';
              const parts = dateStr.split('-');
              if (parts.length !== 3) return '';
              return `${parts[2]}-${parts[1]}-${parts[0]}`;
            }
			$('#inquiry_id').val(d.inquiry_id || 0);
            $('#hotel_name').val(d.hotel_name || '');
            $('#hotel_city').val(d.hotel_city || '');
            $('#checkin_date').val(formatDate(d.hotel_checkin_date));
            $('#checkout_date').val(formatDate(d.hotel_checkout_date));
            $('#rooms').val(d.hotel_rooms || 1);
            $('#adults').val(d.hotel_adults || 1);
            $('#children').val(d.hotel_children || 0);
            $('#remarks').val(d.package_special_requests || d.remarks || '');
          }
        },
        error: function (xhr, status, error) {
          console.error(error);
          toastr.error('Error fetching hotel inquiry details.');
        }
      });
    } else {
      $('#inquiry_id,#hotel_name, #hotel_city, #checkin_date, #checkout_date, #rooms, #adults, #children, #remarks').val('');
    }
  });
});


	$( document ).ready( function () {

		// ================================
		//  City Autocomplete
		// ================================
		$( '#destination' ).on( 'input', function () {
			let query = $( this ).val().trim();
			if ( query.length < 2 ) {
				$( '#citySuggestions' ).empty();
				return;
			}

			$.ajax( {
				url: 'ajax/city_search.php',
				type: 'GET',
				data: {
					q: query
				},
				success: function ( res ) {
					let cities = JSON.parse( res );
					let html = '';

					if ( cities.length > 0 ) {
						cities.forEach( city => {
							html += `
              <a href="javascript:void(0)" 
                 class="list-group-item list-group-item-action city-item" 
                 data-id="${city.id}" 
                 data-name="${city.city_name}">
                 ${city.city_name}
              </a>`;
						} );
					} else {
						html = '<span class="list-group-item">No cities found</span>';
					}

					$( '#citySuggestions' ).html( html ).show();
				},
				error: function () {
					$( '#citySuggestions' ).html( '<span class="list-group-item text-danger">Error fetching cities</span>' );
				}
			} );
		} );

		// ================================
		// ðŸ”¹ City Selection â†’ Load Hotels
		// ================================
		$( document ).on( 'click', '.city-item', function () {
			let cityName = $( this ).data( 'name' );
			let cityId = $( this ).data( 'id' );

			$( '#destination' ).val( cityName );
			$( '#hotel_city_id' ).val( cityId );
			$( '#citySuggestions' ).empty();

			fetchHotelsByCity( cityId );
		} );

		// Hide suggestions if clicked outside
		$( document ).click( function ( e ) {
			if ( !$( e.target ).closest( '#destination, #citySuggestions' ).length ) {
				$( '#citySuggestions' ).empty();
			}
		} );

		// ================================
		// ðŸ”¹ Fetch Hotels by City
		// ================================
		function fetchHotelsByCity( cityId ) {
			$( '#hotel_id' ).html( '<option value="">Loading hotels...</option>' );

			$.ajax( {
				url: 'ajax/fetch_hotels.php',
				type: 'GET', // or 'POST' â€” both work, since PHP uses $_REQUEST
				data: {
					city_id: cityId
				},
				success: function ( res ) {
					$( '#hotel_id' ).html( res );
				},
				error: function () {
					$( '#hotel_id' ).html( '<option value="">Error loading hotels</option>' );
				}
			} );
		}

		// ================================
		// ðŸ”¹ Total Calculation (Room-wise)
		// ================================
		function num( val ) {
			return parseFloat( val ) || 0;
		}

		function calculateTotal() {
			const rooms = num( $( '#hotel_rooms' ).val() );
			const adult_price = num( $( '#adult_price' ).val() );
			const child_price = num( $( '#child_price' ).val() );
			const extra_bed_price = num( $( '#extra_bed_price' ).val() );
			const transport = num( $( '#transport_charges' ).val() );
			const discount = num( $( '#discount' ).val() );
			const gstRate = num( $( '#gst' ).val() );
			const gstIncluded = $( '#gst_included' ).val();

			// âœ… Calculate base price per room
			// (Each room includes adult + child + extra bed prices)
			let baseRoomPrice = adult_price + child_price + extra_bed_price;

			// ðŸ§® Total = Room price Ã— No. of rooms
			let total = baseRoomPrice * rooms;

			// âž• Add transport cost
			total += transport;

			// ðŸ’¸ Apply discount
			if ( discount > 0 ) {
				total -= ( total * discount / 100 );
			}

			// ðŸ§¾ Apply GST if included
			if ( gstIncluded === 'yes' ) {
				total += ( total * gstRate / 100 );
			}

			// ðŸ’° Final total
			$( '#grand_total' ).val( total.toFixed( 2 ) );
		}

		// ðŸ” Trigger recalculation when relevant fields change
		$( document ).on(
			'input change',
			'#hotel_rooms, #adult_price, #child_price, #extra_bed_price, #transport_charges, #discount, #gst_included, #gst',
			calculateTotal
		);

		// âœ… Initial run
		$( document ).ready( calculateTotal );

		// ================================
		// ðŸ”¹ Form Submission + PDF Handling
		// ================================
		let downloadPdfAfterSubmit = false;

		$( '#download-pdf' ).click( function ( e ) {
			e.preventDefault();
			downloadPdfAfterSubmit = true;
			$( 'form' ).submit();
		} );

		$( 'form' ).submit( function ( e ) {
			e.preventDefault();
			let formData = new FormData( this );
			const payment = parseFloat( $( '#advance_payment' ).val() || 0 );
			if ( payment <= 0 ) {
				alert( 'Advance payment must be greater than 0.' );
				e.preventDefault();
				return false;
			}
			// Basic validation
			if ( !formData.get( "customer_id" ) || !formData.get( "hotel_id" ) ) {
				toastr.error( "Please select Customer and Hotel." );
				return;
			}

			$.ajax( {
				url: 'controller/HotelBookingController.php',
				method: 'POST',
				data: formData,
				contentType: false,
				processData: false,
				dataType: 'json',
				success: function ( response ) {
					if ( response.status === 'success' ) {
						toastr.success( response.message );

						if ( downloadPdfAfterSubmit && response.id ) {
							window.open( 'controller/DownloadPDFHotelBookingController.php?id=' + response.id, '_blank' );
							downloadPdfAfterSubmit = false;
						}

						let redirectUrl = response.gst_included === 'yes' ?
							'hotel_booking_list.php' : 'hotel_booking_list.php';

						setTimeout( () => window.location.href = redirectUrl, 1500 );
					} else {
						toastr.error( response.message || 'Failed to save booking.' );
					}
				},
				error: function ( xhr, status, error ) {
					toastr.error( 'An error occurred while submitting the form.' );
					console.error( 'AJAX Error:', status, error, xhr.responseText );
				}
			} );
		} );

	} );
</script>
<?php include('inc/footer.php');?>